/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.util.tool;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import android.view.View;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import java.util.concurrent.TimeUnit;
import me.xujichang.util.simple.SimpleObserver;
import me.xujichang.util.tool.LogTool;

public class ViewTool {
    private static ViewTool instance;
    private Lifecycle mLifecycle;
    private CompositeDisposable mDisposable;

    private ViewTool() {
    }

    protected ViewTool(String pS) {
    }

    public static ViewTool getInstance(Lifecycle lifecycle) {
        if (null == instance) {
            instance = ClassHolder.mViewTool;
        }
        instance.init(lifecycle);
        return instance;
    }

    public static ViewTool getInstance(LifecycleOwner lifecycleOwner) {
        return ViewTool.getInstance(lifecycleOwner.getLifecycle());
    }

    private void init(Lifecycle lifecycle) {
        this.clear();
        this.mDisposable = new CompositeDisposable();
        this.mLifecycle = lifecycle;
        LogTool.d("init");
        this.mLifecycle.addObserver((LifecycleObserver)new XSimpleLifeCycleObserver(){

            @Override
            void onDestroy() {
                ViewTool.this.mDisposable.dispose();
                LogTool.d("dispose");
            }
        });
    }

    private void clear() {
        this.mLifecycle = null;
        this.mDisposable = null;
    }

    public <T extends View> void proxyClickListener(T view, final XOnClickListener<T> listener, int seconds) {
        XObservableOnSubscribe subscribe = new XObservableOnSubscribe<T>(view){

            @Override
            protected void subscribe(final ObservableEmitter<T> e, T view) {
                view.setOnClickListener(new View.OnClickListener((View)view){
                    final /* synthetic */ View val$view;
                    {
                        this.val$view = view;
                    }

                    public void onClick(View v) {
                        e.onNext((Object)this.val$view);
                    }
                });
            }
        };
        SimpleObserver observer = new SimpleObserver<T>(){

            public void onNext(@NonNull T t) {
                listener.onClick(t);
            }
        };
        Observable.create((ObservableOnSubscribe)subscribe).throttleFirst((long)seconds, TimeUnit.SECONDS).subscribe((Observer)observer);
    }

    public <T extends View> void proxyClickListener(T view, XOnClickListener<T> listener) {
        this.proxyClickListener(view, listener, 1);
    }

    public static abstract class XLifeCycleObserver
    implements LifecycleObserver {
        @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
        abstract void onStart();

        @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
        abstract void onStop();

        @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
        abstract void onResume();

        @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
        abstract void onPause();

        @OnLifecycleEvent(value=Lifecycle.Event.ON_CREATE)
        abstract void onCreate();

        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        abstract void onDestroy();

        @OnLifecycleEvent(value=Lifecycle.Event.ON_ANY)
        abstract void onChange();
    }

    public static class XSimpleLifeCycleObserver
    extends XLifeCycleObserver {
        @Override
        void onStart() {
        }

        @Override
        void onStop() {
        }

        @Override
        void onResume() {
        }

        @Override
        void onPause() {
        }

        @Override
        void onCreate() {
        }

        @Override
        void onDestroy() {
        }

        @Override
        void onChange() {
        }
    }

    public static interface XOnClickListener<T extends View> {
        public void onClick(T var1);
    }

    static abstract class XObservableOnSubscribe<T extends View>
    implements ObservableOnSubscribe<T> {
        private T view;

        XObservableOnSubscribe(T view) {
            this.view = view;
        }

        public void subscribe(@NonNull ObservableEmitter<T> e) throws Exception {
            this.subscribe(e, this.view);
        }

        protected abstract void subscribe(ObservableEmitter<T> var1, T var2);
    }

    private static class ClassHolder {
        public static ViewTool mViewTool = new ViewTool();

        private ClassHolder() {
        }
    }
}

