/*
 * Decompiled with CFR 0.152.
 */
package me.xujichang.util.retrofit;

import android.text.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitManager {
    public static final int TOKEN_IN_QUERY = 1;
    public static final int TOKEN_IN_HEADER = 2;
    public static final String URL_EXTEND = "extend_url";
    private String token_key;
    private static RetrofitManager ourInstance = null;
    private static Retrofit retrofit;
    private String token;
    private static String reactUrl;
    private Retrofit tempRetrofit;
    private static String BASE_URL;
    private int tokenPos;
    private HashMap<String, String> extendUrls;

    protected RetrofitManager(String pS) {
    }

    public static RetrofitManager getOurInstance() {
        if (null == ourInstance) {
            ourInstance = new RetrofitManager();
        }
        reactUrl = null;
        return ourInstance;
    }

    public static RetrofitManager getOurInstance(String url) {
        if (null == ourInstance) {
            ourInstance = new RetrofitManager();
        }
        reactUrl = url;
        return ourInstance;
    }

    public static RetrofitManager getOurInstance(OkHttpClient client) {
        if (null == ourInstance) {
            ourInstance = new RetrofitManager();
        }
        return ourInstance;
    }

    private Retrofit initRetrofit(String url) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor((Interceptor)new RequestCheckIntercept());
        builder.addInterceptor((Interceptor)loggingInterceptor);
        builder.connectTimeout(15L, TimeUnit.SECONDS);
        builder.readTimeout(50L, TimeUnit.SECONDS);
        builder.writeTimeout(50L, TimeUnit.SECONDS);
        builder.retryOnConnectionFailure(true);
        OkHttpClient client = builder.build();
        return new Retrofit.Builder().baseUrl(url).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(client).build();
    }

    private RetrofitManager() {
        this.initRetrofit();
    }

    public void refreshToken(String newToken) {
        this.token = newToken;
    }

    private void initRetrofit() {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor((Interceptor)new RequestCheckIntercept());
        builder.addInterceptor((Interceptor)loggingInterceptor);
        builder.connectTimeout(15L, TimeUnit.SECONDS);
        builder.readTimeout(50L, TimeUnit.SECONDS);
        builder.writeTimeout(50L, TimeUnit.SECONDS);
        builder.retryOnConnectionFailure(true);
        OkHttpClient client = builder.build();
        this.tempRetrofit = retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).client(client).build();
    }

    public RetrofitManager withNewClient(OkHttpClient client) {
        retrofit.newBuilder().client(client);
        return this;
    }

    private Request dealRequest(Request request) {
        String extendUrlKey;
        Request.Builder requestBuilder = request.newBuilder();
        HttpUrl.Builder urlBuilder = request.url().newBuilder();
        Headers.Builder headersBuilder = request.headers().newBuilder();
        if (!TextUtils.isEmpty((CharSequence)this.token)) {
            if (this.tokenPos == 1) {
                urlBuilder.addQueryParameter(this.token_key, this.token);
            } else if (this.tokenPos == 2) {
                headersBuilder.add(this.token_key, this.token);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(extendUrlKey = headersBuilder.get(URL_EXTEND)))) {
            if (null != this.extendUrls && !this.extendUrls.isEmpty()) {
                if (!this.extendUrls.containsKey(extendUrlKey)) {
                    throw new RuntimeException("the key | " + extendUrlKey + " | is not exist in extends Url Map");
                }
                this.patchUrl(urlBuilder, this.extendUrls.get(extendUrlKey));
            } else {
                throw new RuntimeException("the extends Url Map is null or size = 0");
            }
        }
        return requestBuilder.headers(headersBuilder.build()).url(urlBuilder.build()).build();
    }

    private void patchUrl(HttpUrl.Builder builder, String extendUrl) {
        HttpUrl extend = HttpUrl.parse((String)extendUrl);
        if (null == extend) {
            return;
        }
        builder.scheme(extend.scheme()).host(extend.host()).port(extend.port());
        ArrayList strings = new ArrayList(builder.build().pathSegments());
        try {
            for (int i = 0; i < strings.size(); ++i) {
                builder.removePathSegment(0);
            }
            strings.addAll(0, extend.pathSegments());
            for (String string : strings) {
                builder.addPathSegment(string);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> T createReq(Class<T> apiService) {
        retrofit = !TextUtils.isEmpty((CharSequence)reactUrl) ? this.initRetrofit(reactUrl) : this.tempRetrofit;
        return (T)retrofit.create(apiService);
    }

    private void initWithBuilder(Builder builder) {
        this.token = builder.token;
        this.token_key = builder.tokenKey;
        this.tokenPos = builder.tokenPos;
        this.extendUrls = builder.extendUrlMap;
    }

    public static class Builder {
        private String baseUrl;
        private String token;
        private String tokenKey = "token";
        private int tokenPos = 1;
        private HashMap<String, String> extendUrlMap = new HashMap();

        public Builder baseUrl(String url) {
            this.baseUrl = url;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder tokenKey(String token_key) {
            this.tokenKey = token_key;
            return this;
        }

        public Builder token(String token, String token_key) {
            this.token(token);
            this.tokenKey(token_key);
            return this;
        }

        public Builder token(int tokenPos, String token, String token_key) {
            this.token(token);
            this.tokenKey(token_key);
            this.tokenPos(tokenPos);
            return this;
        }

        public Builder tokenPos(int tokenPos) {
            this.tokenPos = tokenPos;
            return this;
        }

        public Builder addExtendUrl(String tag, String url) {
            if (this.extendUrlMap.containsKey(tag)) {
                throw new RuntimeException("the key is already in Map");
            }
            this.extendUrlMap.put(tag, url);
            return this;
        }

        public Builder addExtendUrlMap(HashMap<String, String> hashMap) {
            this.extendUrlMap.clear();
            this.extendUrlMap.putAll(hashMap);
            return this;
        }

        public void build() {
            BASE_URL = this.baseUrl;
            RetrofitManager.getOurInstance().initWithBuilder(this);
        }
    }

    private class RequestCheckIntercept
    implements Interceptor {
        private RequestCheckIntercept() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Request newRequest = RetrofitManager.this.dealRequest(request);
            return chain.proceed(newRequest);
        }
    }
}

