/*
 * Decompiled with CFR 0.152.
 */
package me.weilunli.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.List;
import me.weilunli.views.R;

public class RubyTextView
extends AppCompatTextView {
    private Paint textPaint;
    private Paint rubyTextPaint;
    private String combinedText = "";
    private float rubyTextSize = 28.0f;
    private int rubyTextColor;
    private float spacing = 0.0f;
    private float lineheight = 0.0f;
    private float firstLineheight = 0.0f;
    StringBuilder originalText;
    List<String[]> combinedTextArray;

    public RubyTextView(Context context) {
        super(context);
        this.initialize();
        this.setValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.RubyTextView);
        try {
            this.combinedText = ta.getString(R.styleable.RubyTextView_combinedText);
            this.rubyTextSize = ta.getDimension(R.styleable.RubyTextView_rubyTextSize, 28.0f);
            this.rubyTextColor = ta.getColor(R.styleable.RubyTextView_rubyTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.black));
            this.spacing = ta.getDimension(R.styleable.RubyTextView_spacing, 0.0f);
        }
        finally {
            ta.recycle();
        }
        this.setValue();
    }

    private void initialize() {
        this.textPaint = this.getPaint();
        this.rubyTextPaint = new Paint();
        this.originalText = new StringBuilder();
        this.rubyTextColor = this.getCurrentTextColor();
        this.combinedTextArray = new ArrayList<String[]>();
    }

    private void setValue() {
        this.textPaint.setColor(this.getCurrentTextColor());
        this.rubyTextPaint.setTextSize(this.getRubyTextSize());
        this.rubyTextPaint.setColor(this.getRubyTextColor());
        this.lineheight = this.getTextSize() + this.getRubyTextSize() + this.getLineSpacingExtra() + this.getSpacing();
        this.firstLineheight = this.lineheight - this.getLineSpacingExtra();
        this.splitCombinedText();
        this.setLineHeight((int)this.lineheight);
    }

    private int getMySize(int measureSpec, int mBoundLength) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? Math.min(mBoundLength, specSize) : mBoundLength);
        return result;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float cur_x = 0.0f;
        int lineCount = 1;
        for (String[] t : this.combinedTextArray) {
            float textWidth = this.textPaint.measureText(t[0]);
            if (t[0].equals(System.getProperty("line.separator"))) {
                cur_x = 0.0f;
                ++lineCount;
                continue;
            }
            if (cur_x + textWidth > (float)width) {
                cur_x = 0.0f;
                ++lineCount;
            }
            cur_x += textWidth;
        }
        int height = this.getMySize(heightMeasureSpec, (int)(this.firstLineheight + this.lineheight * (float)(lineCount - 1)) + this.getLastBaselineToBottomHeight());
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), height);
    }

    protected void onDraw(Canvas canvas) {
        boolean isFirstLine = true;
        float cur_x = 0.0f;
        float cur_y = this.firstLineheight;
        for (String[] t : this.combinedTextArray) {
            float textWidth = this.textPaint.measureText(t[0]);
            if (t[0].equals(System.getProperty("line.separator"))) {
                cur_x = 0.0f;
                if (isFirstLine) {
                    isFirstLine = false;
                }
                cur_y += this.lineheight;
                continue;
            }
            if (cur_x + textWidth > (float)this.getWidth()) {
                cur_x = 0.0f;
                if (isFirstLine) {
                    isFirstLine = false;
                }
                cur_y += this.lineheight;
            }
            canvas.drawText(t[0], cur_x, cur_y, this.textPaint);
            float rubyText_posX = cur_x + 0.5f * (textWidth - this.rubyTextPaint.measureText(t[1]));
            canvas.drawText(t[1], rubyText_posX, cur_y - this.getTextSize() - this.getSpacing(), this.rubyTextPaint);
            cur_x += textWidth;
        }
    }

    public String getCombinedText() {
        return this.combinedText;
    }

    public float getRubyTextSize() {
        return this.rubyTextSize;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public int getRubyTextColor() {
        return this.rubyTextColor;
    }

    private void updateLineheight() {
        this.lineheight = this.getTextSize() + this.getRubyTextSize() + this.getLineSpacingExtra() + this.getSpacing();
        this.firstLineheight = this.lineheight - this.getLineSpacingExtra();
    }

    public void setCombinedText(String text) {
        this.combinedText = text;
        this.splitCombinedText();
        this.requestLayout();
        this.invalidate();
    }

    public void setRubyTextSize(float textSize) {
        this.rubyTextSize = this.sp2px(textSize);
        this.rubyTextPaint.setTextSize(this.rubyTextSize);
        this.updateLineheight();
        this.invalidate();
        this.requestLayout();
    }

    public void setRubyTextColor(int color2) {
        this.rubyTextColor = color2;
        this.rubyTextPaint.setColor(this.rubyTextColor);
        this.invalidate();
    }

    public void setLetterSpacing(float letterSpacing) {
        super.setLetterSpacing(letterSpacing);
        this.invalidate();
        this.requestLayout();
    }

    public void setTextSize(float size) {
        super.setTextSize(size);
        this.updateLineheight();
        this.requestLayout();
        this.invalidate();
    }

    public void setSpacing(float spacing) {
        this.spacing = this.dp2px(spacing);
        this.updateLineheight();
        this.invalidate();
        this.requestLayout();
    }

    public void setTextColor(int color2) {
        this.textPaint.setColor(color2);
        super.setTextColor(color2);
    }

    public void splitCombinedText() {
        String[] split;
        this.combinedTextArray.clear();
        this.originalText.setLength(0);
        for (String value : split = this.getCombinedText().split(" ")) {
            String[] t = value.split("\\|");
            if (t.length == 2) {
                if (t[1].equals("-")) {
                    this.combinedTextArray.add(new String[]{t[0], ""});
                } else {
                    this.combinedTextArray.add(new String[]{t[0], t[1]});
                }
            } else {
                for (int j = 0; j < t[0].length(); ++j) {
                    String s = String.valueOf(t[0].charAt(j));
                    this.combinedTextArray.add(new String[]{s, ""});
                }
            }
            this.originalText.append(t[0]);
        }
        this.setText(this.originalText);
    }

    private float dp2px(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private float sp2px(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

