/*
 * Decompiled with CFR 0.152.
 */
package me.weilunli.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import me.weilunli.views.R;

public class RubyTextView
extends AppCompatTextView {
    private Bitmap bitmapToSaveCanvas;
    private Canvas tempCanvas;
    private TypedArray ta;
    private Paint textPaint;
    private Paint rubyTextPaint;
    private Rect mRect;
    private String rubyText;
    private float rubyTextSize;
    private int rubyTextColor;
    private float spacing;

    public RubyTextView(Context context) {
        super(context);
        this.initialize();
    }

    public RubyTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
        this.ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.RubyTextView);
        try {
            this.rubyText = this.ta.getString(R.styleable.RubyTextView_rubyText);
            this.rubyTextSize = this.ta.getDimension(R.styleable.RubyTextView_rubyTextSize, 50.0f);
            this.rubyTextColor = this.ta.getColor(R.styleable.RubyTextView_rubyTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.black));
            this.spacing = this.ta.getDimension(R.styleable.RubyTextView_spacing, 10.0f);
        }
        finally {
            this.ta.recycle();
        }
    }

    private void initialize() {
        this.rubyText = "";
        this.rubyTextSize = 50.0f;
        this.rubyTextColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.black);
        this.spacing = 10.0f;
        this.textPaint = new Paint();
        this.rubyTextPaint = new Paint();
        this.mRect = new Rect();
        this.tempCanvas = new Canvas();
    }

    private int getMySize(int measureSpec, int mBoundLength) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int result = specMode == 0x40000000 ? specSize : (specMode == Integer.MIN_VALUE ? Math.min(mBoundLength, specSize) : mBoundLength);
        return result;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.textPaint.setTextSize(this.getTextSize());
        int width = this.getMySize(widthMeasureSpec, (int)((float)this.getText().length() * this.getTextSize()));
        int height = this.getMySize(heightMeasureSpec, (int)(this.getTextSize() + this.rubyTextSize + this.spacing));
        this.setMeasuredDimension(width, height);
    }

    protected void onDraw(Canvas canvas) {
        float textXpos = 0.0f;
        float textYpos = (float)canvas.getHeight() - this.getTextSize() - this.textPaint.descent();
        this.bitmapToSaveCanvas = Bitmap.createBitmap((int)canvas.getWidth(), (int)canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.tempCanvas.setBitmap(this.bitmapToSaveCanvas);
        super.onDraw(this.tempCanvas);
        canvas.drawBitmap(this.bitmapToSaveCanvas, textXpos, textYpos, null);
        this.rubyTextPaint.setTextSize(this.getRubyTextSize());
        this.rubyTextPaint.setColor(this.rubyTextColor);
        String[] splited = this.getRubyText().split(" ");
        for (int i = 0; i < splited.length; ++i) {
            this.rubyTextPaint.getTextBounds(splited[i], 0, splited[i].length(), this.mRect);
            float rubyTextXpos = this.getTextSize() * ((float)i + 0.5f) - (float)this.mRect.width() * 0.5f;
            float rubyTextYpos = (float)canvas.getHeight() - this.getTextSize() - this.getSpacing();
            canvas.drawText(splited[i], rubyTextXpos, rubyTextYpos, this.rubyTextPaint);
        }
    }

    public String getRubyText() {
        return this.rubyText;
    }

    public float getRubyTextSize() {
        return this.rubyTextSize;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setRubyText(String text) {
        this.rubyText = text;
        this.invalidate();
        this.requestLayout();
    }

    public void setRubyTextSize(float rubyTextSize) {
        this.rubyTextSize = this.sp2px(rubyTextSize);
        this.invalidate();
        this.requestLayout();
    }

    public void setRubyTextColor(int color2) {
        this.rubyTextColor = color2;
        this.invalidate();
    }

    public void setSpacing(float spacing) {
        this.spacing = this.dp2px(spacing);
        this.invalidate();
        this.requestLayout();
    }

    private float dp2px(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private float sp2px(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

