/*
 * Decompiled with CFR 0.152.
 */
package me.solidev.statusviewlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import me.solidev.statusviewlayout.R;
import me.solidev.statusviewlayout.StatusViewConfig;

public class StatusViewLayout
extends FrameLayout {
    private View mLoadingView;
    private View mErrorView;
    private View mEmptyView;
    private View mNoNetWorkView;
    private TextView tv_loading;
    private TextView tv_empty;
    private TextView tv_error;
    private TextView tv_no_network;
    private ImageView iv_empty;
    private ImageView iv_error;
    private ImageView iv_no_network;
    private int loadingResId;
    private int errorResId;
    private int emptyResId;
    private int noNetWorkResId;
    private View.OnClickListener mOnRetryListener;

    public StatusViewLayout(Context context) {
        this(context, null);
    }

    public StatusViewLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StatusViewLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StatusViewLayout, defStyleAttr, 0);
        this.loadingResId = a.getResourceId(R.styleable.StatusViewLayout_loading_view, StatusViewConfig.config.loadingResId);
        this.errorResId = a.getResourceId(R.styleable.StatusViewLayout_error_view, StatusViewConfig.config.errorResId);
        this.emptyResId = a.getResourceId(R.styleable.StatusViewLayout_empty_view, StatusViewConfig.config.emptyResId);
        this.noNetWorkResId = a.getResourceId(R.styleable.StatusViewLayout_no_network_view, StatusViewConfig.config.noNetWorkResId);
        a.recycle();
        this.setUpView();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.showContent();
    }

    private void setUpView() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.mLoadingView = LayoutInflater.from((Context)this.getContext()).inflate(this.loadingResId, null);
        this.mErrorView = LayoutInflater.from((Context)this.getContext()).inflate(this.errorResId, null);
        this.mEmptyView = LayoutInflater.from((Context)this.getContext()).inflate(this.emptyResId, null);
        this.mNoNetWorkView = LayoutInflater.from((Context)this.getContext()).inflate(this.noNetWorkResId, null);
        this.tv_loading = (TextView)this.mLoadingView.findViewById(R.id.status_view_tv_loading);
        this.tv_empty = (TextView)this.mEmptyView.findViewById(R.id.status_view_tv_empty);
        this.tv_error = (TextView)this.mErrorView.findViewById(R.id.status_view_tv_error);
        this.tv_no_network = (TextView)this.mErrorView.findViewById(R.id.status_view_tv_no_network);
        this.iv_empty = (ImageView)this.mEmptyView.findViewById(R.id.status_view_iv_empty);
        this.iv_error = (ImageView)this.mErrorView.findViewById(R.id.status_view_iv_error);
        this.iv_no_network = (ImageView)this.mErrorView.findViewById(R.id.status_view_iv_no_network);
        if (StatusViewConfig.config.emptyDrawable != -1) {
            this.setErrorDrawable(StatusViewConfig.config.emptyDrawable);
        }
        if (StatusViewConfig.config.errorDrawable != -1) {
            this.setEmptyDrawable(StatusViewConfig.config.errorDrawable);
        }
        if (StatusViewConfig.config.noNetWorkDrawable != -1) {
            this.setNoNetWorkDrawable(StatusViewConfig.config.noNetWorkDrawable);
        }
        this.addView(this.mLoadingView, (ViewGroup.LayoutParams)layoutParams);
        this.addView(this.mErrorView, (ViewGroup.LayoutParams)layoutParams);
        this.addView(this.mEmptyView, (ViewGroup.LayoutParams)layoutParams);
        this.addView(this.mNoNetWorkView, (ViewGroup.LayoutParams)layoutParams);
        View mRetryView = this.mErrorView.findViewById(R.id.status_view_btn_reload);
        View mRetryViewNoNet = this.mNoNetWorkView.findViewById(R.id.status_view_btn_reload);
        if (mRetryView != null) {
            mRetryView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (StatusViewLayout.this.mOnRetryListener != null) {
                        StatusViewLayout.this.mOnRetryListener.onClick(v);
                    }
                }
            });
        }
        if (mRetryViewNoNet != null) {
            mRetryViewNoNet.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (StatusViewLayout.this.mOnRetryListener != null) {
                        StatusViewLayout.this.mOnRetryListener.onClick(v);
                    }
                }
            });
        }
    }

    public void setOnRetryListener(View.OnClickListener listener) {
        this.mOnRetryListener = listener;
    }

    public void showLoading() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setVisibility(8);
        }
        this.mLoadingView.setVisibility(0);
    }

    public void showLoading(String loadingText) {
        if (this.tv_loading != null && !TextUtils.isEmpty((CharSequence)loadingText)) {
            this.tv_loading.setText((CharSequence)loadingText);
        }
        this.showLoading();
    }

    public void showError() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setVisibility(8);
        }
        this.mErrorView.setVisibility(0);
    }

    public void showError(String errorText) {
        if (this.tv_error != null && !TextUtils.isEmpty((CharSequence)errorText)) {
            this.tv_error.setText((CharSequence)"");
            this.tv_error.append((CharSequence)errorText);
            this.tv_error.append((CharSequence)" ");
            this.tv_error.append((CharSequence)this.getContext().getString(R.string.status_view_error_text_click_reload));
        }
        this.showError();
    }

    public void showEmpty() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setVisibility(8);
        }
        this.mEmptyView.setVisibility(0);
    }

    public void showEmpty(String emptyText) {
        if (this.tv_empty != null && !TextUtils.isEmpty((CharSequence)emptyText)) {
            this.tv_empty.setText((CharSequence)emptyText);
        }
        this.showEmpty();
    }

    public void showNetWorkException(String noNetWorkText) {
        if (this.tv_no_network != null && !TextUtils.isEmpty((CharSequence)noNetWorkText)) {
            this.tv_no_network.setText((CharSequence)noNetWorkText);
        }
        this.showNetWorkException();
    }

    public void showNetWorkException() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setVisibility(8);
        }
        this.mNoNetWorkView.setVisibility(0);
    }

    public void showContent() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setVisibility(8);
        }
        this.getChildAt(this.getChildCount() - 1).setVisibility(0);
    }

    public void setErrorDrawable(int errorDrawable) {
        if (this.iv_error != null) {
            this.iv_error.setImageResource(errorDrawable);
        }
    }

    public void setEmptyDrawable(int emptyDrawable) {
        if (this.iv_empty != null) {
            this.iv_empty.setImageResource(emptyDrawable);
        }
    }

    public void setNoNetWorkDrawable(int noNetWorkDrawable) {
        if (this.iv_no_network != null) {
            this.iv_no_network.setImageResource(noNetWorkDrawable);
        }
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
    }
}

