/*
 * Decompiled with CFR 0.152.
 */
package me.shouheng.uix.widget.timeline;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Dimension;
import android.util.AttributeSet;
import android.view.View;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.shouheng.uix.widget.R;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B'\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0014J(\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0014J\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\nR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lme/shouheng/uix/widget/timeline/Timeline;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "atomDrawable", "Landroid/graphics/drawable/Drawable;", "atomSize", "finishLine", "lineSize", "startLine", "init", "", "initDrawableSize", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "setAtomDrawable", "setAtomSize", "setFinishLine", "setLineSize", "setStartLine", "uix-widget_release"})
public final class Timeline
extends View {
    @Dimension
    private int atomSize;
    @Dimension
    private int lineSize;
    private Drawable startLine;
    private Drawable finishLine;
    private Drawable atomDrawable;
    private HashMap _$_findViewCache;

    private final void init(AttributeSet attrs) {
        block2: {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.Timeline);
            this.atomSize = typedArray.getDimensionPixelSize(R.styleable.Timeline_atom_size, this.atomSize);
            this.lineSize = typedArray.getDimensionPixelSize(R.styleable.Timeline_line_size, this.lineSize);
            this.startLine = typedArray.getDrawable(R.styleable.Timeline_start_line);
            this.finishLine = typedArray.getDrawable(R.styleable.Timeline_finish_line);
            this.atomDrawable = typedArray.getDrawable(R.styleable.Timeline_atom);
            typedArray.recycle();
            Drawable drawable2 = this.startLine;
            if (drawable2 != null) {
                drawable2.setCallback((Drawable.Callback)this);
            }
            Drawable drawable3 = this.finishLine;
            if (drawable3 != null) {
                drawable3.setCallback((Drawable.Callback)this);
            }
            Drawable drawable4 = this.atomDrawable;
            if (drawable4 == null) break block2;
            drawable4.setCallback((Drawable.Callback)this);
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Drawable drawable2 = this.startLine;
        if (drawable2 != null) {
            drawable2.draw(canvas);
        }
        Drawable drawable3 = this.finishLine;
        if (drawable3 != null) {
            drawable3.draw(canvas);
        }
        Drawable drawable4 = this.atomDrawable;
        if (drawable4 != null) {
            drawable4.draw(canvas);
        }
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int w = this.getPaddingLeft() + this.getPaddingRight();
        int h = this.getPaddingTop() + this.getPaddingBottom();
        if (this.atomDrawable != null) {
            w += this.atomSize;
            h += this.atomSize;
        }
        w = RangesKt.coerceAtLeast((int)w, (int)this.getMeasuredWidth());
        h = RangesKt.coerceAtLeast((int)h, (int)this.getMeasuredHeight());
        int width = View.resolveSizeAndState((int)w, (int)widthMeasureSpec, (int)0);
        int height = View.resolveSizeAndState((int)h, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initDrawableSize();
    }

    private final void initDrawableSize() {
        block5: {
            Rect rect;
            int pLeft = this.getPaddingLeft();
            int pRight = this.getPaddingRight();
            int pTop = this.getPaddingTop();
            int pBottom = this.getPaddingBottom();
            int width = this.getWidth();
            int height = this.getHeight();
            int cWidth = width - pLeft - pRight;
            int cHeight = height - pTop - pBottom;
            Rect bounds = null;
            if (this.atomDrawable != null) {
                int atomSize = RangesKt.coerceAtMost((int)this.atomSize, (int)RangesKt.coerceAtMost((int)cWidth, (int)cHeight));
                Drawable drawable2 = this.atomDrawable;
                if (drawable2 != null) {
                    drawable2.setBounds(pLeft, pTop, pLeft + atomSize, pTop + atomSize);
                }
                Drawable drawable3 = this.atomDrawable;
                if (drawable3 == null) {
                    Intrinsics.throwNpe();
                }
                Rect rect2 = drawable3.getBounds();
                rect = rect2;
                Intrinsics.checkExpressionValueIsNotNull((Object)rect2, (String)"atomDrawable!!.bounds");
            } else {
                rect = new Rect(pLeft, pTop, pLeft + cWidth, pTop + cHeight);
            }
            bounds = rect;
            int halfLineSize = this.lineSize >> 1;
            int lineLeft = bounds.centerX() - halfLineSize;
            Drawable drawable4 = this.startLine;
            if (drawable4 != null) {
                drawable4.setBounds(lineLeft, 0, lineLeft + this.lineSize, bounds.top);
            }
            Drawable drawable5 = this.finishLine;
            if (drawable5 == null) break block5;
            drawable5.setBounds(lineLeft, bounds.bottom, lineLeft + this.lineSize, height);
        }
    }

    public final void setLineSize(int lineSize) {
        if (this.lineSize != lineSize) {
            this.lineSize = lineSize;
            this.initDrawableSize();
            this.invalidate();
        }
    }

    public final void setAtomSize(int atomSize) {
        if (this.atomSize != atomSize) {
            this.atomSize = atomSize;
            this.initDrawableSize();
            this.invalidate();
        }
    }

    public final void setStartLine(@NotNull Drawable startLine) {
        Intrinsics.checkParameterIsNotNull((Object)startLine, (String)"startLine");
        if (this.startLine != startLine) {
            Drawable drawable2 = this.startLine = startLine;
            if (drawable2 != null) {
                drawable2.setCallback((Drawable.Callback)this);
            }
            this.initDrawableSize();
            this.invalidate();
        }
    }

    public final void setFinishLine(@NotNull Drawable finishLine) {
        Intrinsics.checkParameterIsNotNull((Object)finishLine, (String)"finishLine");
        if (this.finishLine != finishLine) {
            Drawable drawable2 = this.finishLine = finishLine;
            if (drawable2 != null) {
                drawable2.setCallback((Drawable.Callback)this);
            }
            this.initDrawableSize();
            this.invalidate();
        }
    }

    public final void setAtomDrawable(@NotNull Drawable atomDrawable) {
        Intrinsics.checkParameterIsNotNull((Object)atomDrawable, (String)"atomDrawable");
        if (this.atomDrawable != atomDrawable) {
            Drawable drawable2 = this.atomDrawable = atomDrawable;
            if (drawable2 != null) {
                drawable2.setCallback((Drawable.Callback)this);
            }
            this.initDrawableSize();
            this.invalidate();
        }
    }

    @JvmOverloads
    public Timeline(@Nullable Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.atomSize = 24;
        this.lineSize = 12;
        this.init(attrs);
    }

    public /* synthetic */ Timeline(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public Timeline(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public Timeline(@Nullable Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

