/*
 * Decompiled with CFR 0.152.
 */
package me.shouheng.uix.widget.pager;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import me.shouheng.uix.widget.R;

public class MultiViewPager
extends ViewPager {
    private final Point size;
    private final Point maxSize;
    private int mMaxWidth = -1;
    private int mMaxHeight = -1;
    private int mMatchWidthChildResId;
    private boolean mNeedsMeasurePage;

    public MultiViewPager(Context context) {
        super(context);
        this.size = new Point();
        this.maxSize = new Point();
    }

    public MultiViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
        this.size = new Point();
        this.maxSize = new Point();
    }

    private static void constrainTo(Point size, Point maxSize) {
        if (maxSize.x >= 0 && size.x > maxSize.x) {
            size.x = maxSize.x;
        }
        if (maxSize.y >= 0 && size.y > maxSize.y) {
            size.y = maxSize.y;
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.setClipChildren(false);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MultiViewPager);
        this.setMaxWidth(ta.getDimensionPixelSize(R.styleable.MultiViewPager_android_maxWidth, -1));
        this.setMaxHeight(ta.getDimensionPixelSize(R.styleable.MultiViewPager_android_maxHeight, -1));
        this.setMatchChildWidth(ta.getResourceId(R.styleable.MultiViewPager_matchChildWidth, 0));
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.size.set(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        if (this.mMaxWidth >= 0 || this.mMaxHeight >= 0) {
            this.maxSize.set(this.mMaxWidth, this.mMaxHeight);
            MultiViewPager.constrainTo(this.size, this.maxSize);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.size.x, (int)0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.size.y, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.onMeasurePage(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onMeasurePage(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.mNeedsMeasurePage) {
            return;
        }
        if (this.mMatchWidthChildResId == 0) {
            this.mNeedsMeasurePage = false;
        } else if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            child.measure(widthMeasureSpec, heightMeasureSpec);
            int pageWidth = child.getMeasuredWidth();
            View match = child.findViewById(this.mMatchWidthChildResId);
            if (match == null) {
                throw new NullPointerException("MatchWithChildResId did not find that ID in the first fragment of the ViewPager; is that view defined in the child view's layout? Note that MultiViewPager only measures the child for index 0.");
            }
            int childWidth = match.getMeasuredWidth();
            if (childWidth > 0) {
                this.mNeedsMeasurePage = false;
                int difference = pageWidth - childWidth;
                this.setPageMargin(-difference);
                int offscreen = (int)Math.ceil((float)pageWidth / (float)childWidth) + 1;
                this.setOffscreenPageLimit(offscreen);
                this.requestLayout();
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mNeedsMeasurePage = true;
    }

    public void setMatchChildWidth(int matchChildWidthResId) {
        if (this.mMatchWidthChildResId != matchChildWidthResId) {
            this.mMatchWidthChildResId = matchChildWidthResId;
            this.mNeedsMeasurePage = true;
        }
    }

    public void setMaxWidth(int width) {
        this.mMaxWidth = width;
    }

    public void setMaxHeight(int height) {
        this.mMaxHeight = height;
    }
}

