/*
 * Decompiled with CFR 0.152.
 */
package me.shouheng.uix.widget.text;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0015J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tH\u0015R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lme/shouheng/uix/widget/text/VerticalTextView;", "Landroid/support/v7/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "verticalMode", "", "isVerticalMode", "()Z", "setVerticalMode", "(Z)V", "mLineBreakIndex", "", "mLineCount", "mLineWidths", "", "init", "", "isCJKCharacter", "input", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "uix-widget_release"})
public final class VerticalTextView
extends AppCompatTextView {
    private boolean isVerticalMode;
    private int mLineCount;
    private float[] mLineWidths;
    private int[] mLineBreakIndex;
    private HashMap _$_findViewCache;

    public final boolean isVerticalMode() {
        return this.isVerticalMode;
    }

    public final void setVerticalMode(boolean verticalMode) {
        this.isVerticalMode = verticalMode;
        this.requestLayout();
    }

    private final void init() {
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"DrawAllocation"})
    @TargetApi(value=16)
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isVerticalMode) {
            float currentLineHeight;
            TextPaint paint;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            float width = this.getPaddingLeft() + this.getPaddingRight();
            float height = this.getPaddingTop() + this.getPaddingBottom();
            String string = ((Object)this.getText()).toString();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] chars = cArray;
            TextPaint textPaint = paint = this.getPaint();
            Intrinsics.checkExpressionValueIsNotNull((Object)textPaint, (String)"paint");
            Paint.FontMetricsInt fontMetricsInt = textPaint.getFontMetricsInt();
            int lineMaxBottom = (heightMode == 0 ? Integer.MAX_VALUE : heightSize) - this.getPaddingBottom();
            float lineMaxHeight = currentLineHeight = (float)this.getPaddingTop();
            int lineIndex = 0;
            this.mLineCount = 0;
            this.mLineWidths = new float[chars.length + 1];
            this.mLineBreakIndex = new int[chars.length + 1];
            int step = 1;
            Object object = this;
            int n = 0;
            boolean bl2 = false;
            VerticalTextView $this$run = object;
            boolean bl3 = false;
            for (int i = 0; i < chars.length; i += step) {
                boolean needBreakLine;
                int codePoint = Character.codePointAt(chars, i);
                step = Character.charCount(codePoint);
                boolean needRotate = !$this$run.isCJKCharacter(codePoint);
                float charHeight = 0.0f;
                float charWidth = 0.0f;
                if (needRotate) {
                    charWidth = fontMetricsInt.descent - fontMetricsInt.ascent;
                    charHeight = paint.measureText(chars, i, step);
                } else {
                    charWidth = paint.measureText(chars, i, step);
                    charHeight = fontMetricsInt.descent - fontMetricsInt.ascent;
                }
                boolean bl4 = needBreakLine = currentLineHeight + charHeight > (float)lineMaxBottom && i > 0;
                if (needBreakLine) {
                    if (lineMaxHeight < currentLineHeight) {
                        lineMaxHeight = currentLineHeight;
                    }
                    if ($this$run.mLineBreakIndex != null) {
                        $this$run.mLineBreakIndex[lineIndex] = i - step;
                    }
                    if ($this$run.mLineWidths == null) {
                        Intrinsics.throwNpe();
                    }
                    width += $this$run.mLineWidths[lineIndex];
                    int n2 = lineIndex;
                    lineIndex = n2 + 1;
                    currentLineHeight = (float)$this$run.getPaddingTop() + charHeight;
                } else if (lineMaxHeight < (currentLineHeight += charHeight)) {
                    lineMaxHeight = currentLineHeight;
                }
                if ($this$run.mLineWidths == null) {
                    Intrinsics.throwNpe();
                }
                if ($this$run.mLineWidths[lineIndex] < charWidth) {
                    if ($this$run.mLineWidths == null) {
                        Intrinsics.throwNpe();
                    }
                    $this$run.mLineWidths[lineIndex] = charWidth;
                }
                if (i + step < chars.length) continue;
                if ($this$run.mLineWidths == null) {
                    Intrinsics.throwNpe();
                }
                width += $this$run.mLineWidths[lineIndex];
                height = lineMaxHeight + (float)$this$run.getPaddingBottom();
            }
            object = chars;
            n = 0;
            Object object2 = object;
            boolean bl5 = false;
            if (!(((VerticalTextView)object2).length == 0)) {
                this.mLineCount = lineIndex + 1;
                if (this.mLineBreakIndex == null) {
                    Intrinsics.throwNpe();
                }
                this.mLineBreakIndex[lineIndex] = chars.length - step;
            }
            if (this.mLineCount > 1) {
                int lineSpacingCount = this.mLineCount - 1;
                n = 0;
                int n3 = lineSpacingCount;
                while (n < n3) {
                    void i;
                    if (this.mLineWidths == null) {
                        Intrinsics.throwNpe();
                    }
                    width += this.mLineWidths[i] * (this.getLineSpacingMultiplier() - 1.0f) + this.getLineSpacingExtra();
                    ++i;
                }
            }
            if (heightMode == 0x40000000) {
                height = heightSize;
            } else if (heightMode == Integer.MIN_VALUE) {
                height = RangesKt.coerceAtMost((float)height, (float)heightSize);
            }
            if (widthMode == 0x40000000) {
                width = widthSize;
            } else if (widthMode == Integer.MIN_VALUE) {
                width = RangesKt.coerceAtMost((float)width, (float)widthSize);
            }
            this.setMeasuredDimension((int)width, (int)height);
        }
    }

    @TargetApi(value=16)
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (!this.isVerticalMode) {
            super.onDraw(canvas);
        } else {
            float curLineX;
            TextPaint paint;
            if (this.mLineCount == 0) {
                return;
            }
            TextPaint textPaint = paint = this.getPaint();
            Intrinsics.checkExpressionValueIsNotNull((Object)textPaint, (String)"paint");
            textPaint.setColor(this.getCurrentTextColor());
            paint.drawableState = this.getDrawableState();
            Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
            String string = ((Object)this.getText()).toString();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] chars = cArray;
            canvas.save();
            int curLine = 0;
            float f = (float)this.getWidth() - (float)this.getPaddingRight();
            if (this.mLineWidths == null) {
                Intrinsics.throwNpe();
            }
            float curX = curLineX = f - this.mLineWidths[curLine];
            float curY = this.getPaddingTop();
            int step = 0;
            for (int i = 0; i < chars.length; i += step) {
                boolean nextCharBreakLine;
                boolean hasNextChar;
                float f2;
                int codePoint = Character.codePointAt(chars, i);
                step = Character.charCount(codePoint);
                boolean needRotate = !this.isCJKCharacter(codePoint);
                int saveCount = canvas.save();
                if (needRotate) {
                    canvas.rotate(90.0f, curX, curY);
                }
                float textX = curX;
                if (needRotate) {
                    if (this.mLineWidths == null) {
                        Intrinsics.throwNpe();
                    }
                    f2 = curY - (this.mLineWidths[curLine] - (float)(fontMetricsInt.bottom - fontMetricsInt.top)) / (float)2 - (float)fontMetricsInt.descent;
                } else {
                    f2 = curY - (float)fontMetricsInt.ascent;
                }
                float textBaseline = f2;
                canvas.drawText(chars, i, step, textX, textBaseline, (Paint)paint);
                canvas.restoreToCount(saveCount);
                boolean bl2 = hasNextChar = i + step < chars.length;
                if (!hasNextChar) continue;
                if (this.mLineBreakIndex == null) {
                    Intrinsics.throwNpe();
                }
                boolean bl3 = nextCharBreakLine = i + 1 > this.mLineBreakIndex[curLine];
                if (nextCharBreakLine) {
                    if (this.mLineWidths == null) {
                        Intrinsics.throwNpe();
                    }
                    if (curLine + 1 < this.mLineWidths.length) {
                        ++curLine;
                        if (this.mLineWidths == null) {
                            Intrinsics.throwNpe();
                        }
                        curX = curLineX -= this.mLineWidths[curLine] * this.getLineSpacingMultiplier() + this.getLineSpacingExtra();
                        curY = this.getPaddingTop();
                        continue;
                    }
                }
                curY += needRotate ? paint.measureText(chars, i, step) : (float)(fontMetricsInt.descent - fontMetricsInt.ascent);
            }
            canvas.restore();
        }
    }

    private final boolean isCJKCharacter(int input) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(input);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.HANGUL_SYLLABLES || ub == Character.UnicodeBlock.HANGUL_JAMO || ub == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || ub == Character.UnicodeBlock.HIRAGANA || ub == Character.UnicodeBlock.KATAKANA || ub == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS;
    }

    public VerticalTextView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.isVerticalMode = true;
        this.init();
    }

    public VerticalTextView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.isVerticalMode = true;
        this.init();
    }

    public VerticalTextView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.isVerticalMode = true;
        this.init();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

