/*
 * Decompiled with CFR 0.152.
 */
package me.shouheng.uix.widget.layout;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;

public class AnimCardView
extends CardView {
    private View.OnClickListener listener;
    private boolean isDelay = false;
    private boolean isAnimEnd = false;
    private boolean isOnClick = true;
    private Animator.AnimatorListener outListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            AnimCardView.this.isAnimEnd = true;
            if (!AnimCardView.this.isOnClick) {
                AnimCardView.this.handleClickEvent();
            }
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };
    private Animator.AnimatorListener inListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            AnimCardView.this.resetControl();
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    public AnimCardView(@NonNull Context context) {
        this(context, null);
    }

    public AnimCardView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AnimCardView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.zoomOut();
                return true;
            }
            case 1: {
                if (this.isAnimEnd) {
                    this.handleClickEvent();
                    break;
                }
                this.isOnClick = false;
                break;
            }
            case 3: {
                this.zoomIn();
                break;
            }
        }
        return super.onTouchEvent(ev);
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.listener = listener;
    }

    public void setDelay(boolean delay) {
        this.isDelay = delay;
    }

    public AnimatorSet zoomIn() {
        ObjectAnimator animX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{0.96f, 1.0f});
        ObjectAnimator animY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{0.96f, 1.0f});
        AnimatorSet upSet = new AnimatorSet();
        upSet.play((Animator)animX).with((Animator)animY);
        upSet.setDuration(120L);
        upSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        upSet.addListener(this.inListener);
        upSet.start();
        return upSet;
    }

    public AnimatorSet zoomOut() {
        ObjectAnimator animX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{1.0f, 0.96f});
        ObjectAnimator animY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{1.0f, 0.96f});
        AnimatorSet downSet = new AnimatorSet();
        downSet.play((Animator)animX).with((Animator)animY);
        downSet.setDuration(120L);
        downSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        downSet.addListener(this.outListener);
        downSet.start();
        return downSet;
    }

    private void handleClickEvent() {
        if (null != this.listener) {
            this.listener.onClick((View)this);
        }
        this.resetControl();
        if (this.isDelay) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    AnimCardView.this.zoomIn();
                }
            }, 500L);
        } else {
            this.zoomIn();
        }
    }

    private void resetControl() {
        this.isOnClick = true;
        this.isAnimEnd = false;
    }
}

