/*
 * Decompiled with CFR 0.152.
 */
package me.shouheng.uix.widget.image;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import java.util.Arrays;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import me.shouheng.uix.widget.R;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 T2\u00020\u0001:\u0001TB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u00101\u001a\u0004\u0018\u00010\u001a2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002072\u0006\u00109\u001a\u00020:H\u0014J(\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\bH\u0014J\u0010\u0010@\u001a\u0002072\u0006\u0010A\u001a\u00020\u0013H\u0016J\u0010\u0010B\u001a\u0002072\b\b\u0001\u0010C\u001a\u00020\bJ\u0010\u0010D\u001a\u0002072\u0006\u0010E\u001a\u00020*H\u0016J\u000e\u0010F\u001a\u0002072\u0006\u0010G\u001a\u00020\bJ\u0010\u0010H\u001a\u0002072\u0006\u0010I\u001a\u00020\u001aH\u0016J\u0012\u0010J\u001a\u0002072\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0012\u0010K\u001a\u0002072\b\b\u0001\u0010L\u001a\u00020\bH\u0016J\u0012\u0010M\u001a\u0002072\b\u0010N\u001a\u0004\u0018\u00010OH\u0016J\u0010\u0010P\u001a\u0002072\u0006\u0010Q\u001a\u000205H\u0016J\b\u0010R\u001a\u000207H\u0002J\b\u0010S\u001a\u000207H\u0002R$\u0010\n\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lme/shouheng/uix/widget/image/CircleImageView;", "Landroid/support/v7/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "borderColor", "getBorderColor", "()I", "setBorderColor", "(I)V", "borderWidth", "getBorderWidth", "setBorderWidth", "borderOverlay", "", "isBorderOverlay", "()Z", "setBorderOverlay", "(Z)V", "isFillingColor", "mBitmap", "Landroid/graphics/Bitmap;", "mBitmapHeight", "mBitmapPaint", "Landroid/graphics/Paint;", "mBitmapShader", "Landroid/graphics/BitmapShader;", "mBitmapWidth", "mBorderColor", "mBorderOverlay", "mBorderPaint", "mBorderRadius", "", "mBorderRect", "Landroid/graphics/RectF;", "mBorderWidth", "mColorFilter", "Landroid/graphics/ColorFilter;", "mDrawableRadius", "mDrawableRect", "mReady", "mSetupPending", "mShaderMatrix", "Landroid/graphics/Matrix;", "getBitmapFromDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "getScaleType", "Landroid/widget/ImageView$ScaleType;", "init", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "setAdjustViewBounds", "adjustViewBounds", "setBorderColorResource", "borderColorRes", "setColorFilter", "cf", "setFillingCircleColor", "color", "setImageBitmap", "bm", "setImageDrawable", "setImageResource", "resId", "setImageURI", "uri", "Landroid/net/Uri;", "setScaleType", "scaleType", "setup", "updateShaderMatrix", "Companion", "uix-widget_release"})
public final class CircleImageView
extends AppCompatImageView {
    private final RectF mDrawableRect;
    private final RectF mBorderRect;
    private final Matrix mShaderMatrix;
    private final Paint mBitmapPaint;
    private final Paint mBorderPaint;
    private int mBorderColor;
    private int mBorderWidth;
    private Bitmap mBitmap;
    private BitmapShader mBitmapShader;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private float mDrawableRadius;
    private float mBorderRadius;
    private ColorFilter mColorFilter;
    private boolean mReady;
    private boolean mSetupPending;
    private boolean mBorderOverlay;
    private boolean isFillingColor;
    private static final ImageView.ScaleType SCALE_TYPE;
    private static final Bitmap.Config BITMAP_CONFIG;
    private static final int COLOR_DRAWABLE_DIMENSION = 2;
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final boolean DEFAULT_BORDER_OVERLAY = false;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final int getBorderColor() {
        return this.mBorderColor;
    }

    public final void setBorderColor(int borderColor) {
        if (borderColor == this.mBorderColor) {
            return;
        }
        this.mBorderColor = borderColor;
        this.mBorderPaint.setColor(this.mBorderColor);
        this.invalidate();
    }

    public final int getBorderWidth() {
        return this.mBorderWidth;
    }

    public final void setBorderWidth(int borderWidth) {
        if (borderWidth == this.mBorderWidth) {
            return;
        }
        this.mBorderWidth = borderWidth;
        this.setup();
    }

    public final boolean isBorderOverlay() {
        return this.mBorderOverlay;
    }

    public final void setBorderOverlay(boolean borderOverlay) {
        if (borderOverlay == this.mBorderOverlay) {
            return;
        }
        this.mBorderOverlay = borderOverlay;
        this.setup();
    }

    private final void init() {
        super.setScaleType(SCALE_TYPE);
        this.mReady = true;
        if (this.mSetupPending) {
            this.setup();
            this.mSetupPending = false;
        }
    }

    @NotNull
    public ImageView.ScaleType getScaleType() {
        return SCALE_TYPE;
    }

    public void setScaleType(@NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
        boolean bl = scaleType == SCALE_TYPE;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "ScaleType %s not supported.";
            Object[] objectArray = new Object[]{scaleType};
            boolean bl5 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        boolean bl = !adjustViewBounds;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "adjustViewBounds not supported.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.isFillingColor) {
            this.mDrawableRadius = RangesKt.coerceAtMost((int)(this.getWidth() / 2), (int)(this.getHeight() / 2));
        } else if (this.getDrawable() == null) {
            return;
        }
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.mDrawableRadius, this.mBitmapPaint);
        if (this.mBorderWidth != 0) {
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), this.mBorderRadius, this.mBorderPaint);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.setup();
    }

    public final void setBorderColorResource(@ColorRes int borderColorRes) {
        this.setBorderColor(ContextCompat.getColor((Context)this.getContext(), (int)borderColorRes));
    }

    public void setImageBitmap(@NotNull Bitmap bm) {
        Intrinsics.checkParameterIsNotNull((Object)bm, (String)"bm");
        super.setImageBitmap(bm);
        this.mBitmap = bm;
        this.setup();
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.mBitmap = this.getBitmapFromDrawable(drawable2);
        this.setup();
    }

    public void setImageResource(@DrawableRes int resId) {
        super.setImageResource(resId);
        this.mBitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.setup();
    }

    public final void setFillingCircleColor(int color2) {
        this.mBitmapPaint.setColor(color2);
        this.mBitmapPaint.setAntiAlias(true);
        this.isFillingColor = true;
        this.invalidate();
    }

    public void setImageURI(@Nullable Uri uri) {
        super.setImageURI(uri);
        this.mBitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.setup();
    }

    public void setColorFilter(@NotNull ColorFilter cf) {
        Intrinsics.checkParameterIsNotNull((Object)cf, (String)"cf");
        if (cf == this.mColorFilter) {
            return;
        }
        this.mColorFilter = cf;
        this.mBitmapPaint.setColorFilter(this.mColorFilter);
        this.invalidate();
    }

    private final Bitmap getBitmapFromDrawable(Drawable drawable2) {
        Bitmap bitmap;
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        try {
            Bitmap bitmap2;
            if (drawable2 instanceof ColorDrawable) {
                Bitmap bitmap3 = Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG);
                bitmap2 = bitmap3;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"Bitmap.createBitmap(COLO\u2026DIMENSION, BITMAP_CONFIG)");
            } else {
                Bitmap bitmap4 = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
                bitmap2 = bitmap4;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"Bitmap.createBitmap(draw\u2026sicHeight, BITMAP_CONFIG)");
            }
            Bitmap bitmap5 = bitmap2;
            Canvas canvas = new Canvas(bitmap5);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        catch (OutOfMemoryError e) {
            bitmap = null;
        }
        return bitmap;
    }

    private final void setup() {
        if (!this.mReady) {
            this.mSetupPending = true;
            return;
        }
        if (this.mBitmap == null) {
            return;
        }
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            Intrinsics.throwNpe();
        }
        this.mBitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        Bitmap bitmap2 = this.mBitmap;
        if (bitmap2 == null) {
            Intrinsics.throwNpe();
        }
        this.mBitmapHeight = bitmap2.getHeight();
        Bitmap bitmap3 = this.mBitmap;
        if (bitmap3 == null) {
            Intrinsics.throwNpe();
        }
        this.mBitmapWidth = bitmap3.getWidth();
        this.mBorderRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.mBorderRadius = RangesKt.coerceAtMost((float)((this.mBorderRect.height() - (float)this.mBorderWidth) / (float)2), (float)((this.mBorderRect.width() - (float)this.mBorderWidth) / (float)2));
        this.mDrawableRect.set(this.mBorderRect);
        if (!this.mBorderOverlay) {
            this.mDrawableRect.inset((float)this.mBorderWidth, (float)this.mBorderWidth);
        }
        this.mDrawableRadius = RangesKt.coerceAtMost((float)(this.mDrawableRect.height() / (float)2), (float)(this.mDrawableRect.width() / (float)2));
        this.updateShaderMatrix();
        this.invalidate();
    }

    private final void updateShaderMatrix() {
        float scale = 0.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        this.mShaderMatrix.set(null);
        if ((float)this.mBitmapWidth * this.mDrawableRect.height() > this.mDrawableRect.width() * (float)this.mBitmapHeight) {
            scale = this.mDrawableRect.height() / (float)this.mBitmapHeight;
            dx = (this.mDrawableRect.width() - (float)this.mBitmapWidth * scale) * 0.5f;
        } else {
            scale = this.mDrawableRect.width() / (float)this.mBitmapWidth;
            dy = (this.mDrawableRect.height() - (float)this.mBitmapHeight * scale) * 0.5f;
        }
        this.mShaderMatrix.setScale(scale, scale);
        this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)) + this.mDrawableRect.left, (float)((int)(dy + 0.5f)) + this.mDrawableRect.top);
        BitmapShader bitmapShader = this.mBitmapShader;
        if (bitmapShader == null) {
            Intrinsics.throwNpe();
        }
        bitmapShader.setLocalMatrix(this.mShaderMatrix);
    }

    public CircleImageView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mDrawableRect = new RectF();
        this.mBorderRect = new RectF();
        this.mShaderMatrix = new Matrix();
        this.mBitmapPaint = new Paint();
        this.mBorderPaint = new Paint();
        this.mBorderColor = -16777216;
        this.init();
    }

    @JvmOverloads
    public CircleImageView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.mDrawableRect = new RectF();
        this.mBorderRect = new RectF();
        this.mShaderMatrix = new Matrix();
        this.mBitmapPaint = new Paint();
        this.mBorderPaint = new Paint();
        this.mBorderColor = -16777216;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircleImageView, defStyle, 0);
        this.mBorderWidth = a.getDimensionPixelSize(R.styleable.CircleImageView_border_width, 0);
        this.mBorderColor = a.getColor(R.styleable.CircleImageView_border_color, -16777216);
        this.mBorderOverlay = a.getBoolean(R.styleable.CircleImageView_border_overlay, false);
        a.recycle();
        this.init();
    }

    public /* synthetic */ CircleImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CircleImageView(@NotNull Context context, @NotNull AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    static {
        Companion = new Companion(null);
        SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
        BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/shouheng/uix/widget/image/CircleImageView$Companion;", "", "()V", "BITMAP_CONFIG", "Landroid/graphics/Bitmap$Config;", "COLOR_DRAWABLE_DIMENSION", "", "DEFAULT_BORDER_COLOR", "DEFAULT_BORDER_OVERLAY", "", "DEFAULT_BORDER_WIDTH", "SCALE_TYPE", "Landroid/widget/ImageView$ScaleType;", "uix-widget_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

