/*
 * Decompiled with CFR 0.152.
 */
package me.shouheng.uix.widget.button;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.Px;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.shouheng.uix.common.anno.LoadingButtonState;
import me.shouheng.uix.common.utils.UIXColorUtils;
import me.shouheng.uix.common.utils.UIXImageUtils;
import me.shouheng.uix.common.utils.UIXResUtils;
import me.shouheng.uix.common.utils.UIXViewUtils;
import me.shouheng.uix.widget.R;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001'B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020!J\u0010\u0010$\u001a\u00020\u001c2\b\b\u0001\u0010%\u001a\u00020\tJ\u000e\u0010&\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lme/shouheng/uix/widget/button/LoadingButton;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "disableDrawable", "Landroid/graphics/drawable/Drawable;", "ll", "loadingButtonState", "loadingStyle", "normalDrawable", "pb", "Landroid/widget/ProgressBar;", "stateListDrawable", "Landroid/graphics/drawable/StateListDrawable;", "text", "", "textColor", "textDisableColor", "tv", "Landroid/widget/TextView;", "setEllipsize", "", "ellipsize", "Landroid/text/TextUtils$TruncateAt;", "setEnabled", "enabled", "", "setLoading", "loading", "setState", "state", "setText", "GlobalConfig", "uix-widget_release"})
public final class LoadingButton
extends LinearLayout {
    private final LinearLayout ll;
    private final ProgressBar pb;
    private final TextView tv;
    private StateListDrawable stateListDrawable;
    private Drawable disableDrawable;
    private Drawable normalDrawable;
    private int loadingStyle;
    private String text;
    private int textColor;
    private int textDisableColor;
    private int loadingButtonState;
    private HashMap _$_findViewCache;

    public final void setState(@LoadingButtonState int state) {
        this.loadingButtonState = state;
        switch (state) {
            case 0: {
                this.pb.setVisibility(8);
                this.setClickable(true);
                StateListDrawable stateListDrawable = this.stateListDrawable;
                if (stateListDrawable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stateListDrawable");
                }
                this.ll.setBackground((Drawable)stateListDrawable);
                this.tv.setTextColor(this.textColor);
                break;
            }
            case 1: {
                this.pb.setVisibility(0);
                this.setClickable(false);
                Drawable drawable = this.normalDrawable;
                if (drawable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"normalDrawable");
                }
                this.ll.setBackground(drawable);
                this.tv.setTextColor(this.textColor);
                break;
            }
            case 2: {
                this.pb.setVisibility(8);
                this.setClickable(false);
                Drawable drawable = this.disableDrawable;
                if (drawable == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"disableDrawable");
                }
                this.ll.setBackground(drawable);
                this.tv.setTextColor(this.textDisableColor);
            }
        }
    }

    public final void setLoading(boolean loading) {
        if (loading) {
            this.setState(1);
        } else {
            this.setState(0);
        }
    }

    public final void setText(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.tv.setText((CharSequence)text);
    }

    public final void setEllipsize(@NotNull TextUtils.TruncateAt ellipsize) {
        Intrinsics.checkParameterIsNotNull((Object)ellipsize, (String)"ellipsize");
        this.tv.setEllipsize(ellipsize);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.setState(0);
        } else {
            this.setState(2);
        }
    }

    public LoadingButton(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public LoadingButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public LoadingButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.textColor = -16777216;
        this.textDisableColor = -16777216;
        LayoutInflater.from((Context)context).inflate(R.layout.uix_loading_button, (ViewGroup)this, true);
        View view = this.findViewById(R.id.ll_btn);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.ll_btn)");
        this.ll = (LinearLayout)view;
        View view2 = this.findViewById(R.id.pb);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.pb)");
        this.pb = (ProgressBar)view2;
        View view3 = this.findViewById(R.id.text);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.text)");
        this.tv = (TextView)view3;
        if (attrs != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LoadingButton);
            this.text = typedArray.getString(R.styleable.LoadingButton_loading_button_text);
            int size = typedArray.getDimensionPixelSize(R.styleable.LoadingButton_loading_button_text_size, UIXViewUtils.INSTANCE.sp2px(16.0f));
            this.textColor = typedArray.getColor(R.styleable.LoadingButton_loading_button_text_color, GlobalConfig.INSTANCE.getTextColor());
            this.textDisableColor = typedArray.getColor(R.styleable.LoadingButton_loading_button_text_disable_color, GlobalConfig.INSTANCE.getTextDisableColor());
            int normalColor = typedArray.getColor(R.styleable.LoadingButton_loading_button_normal_color, GlobalConfig.INSTANCE.getNormalColor());
            int disableColor = typedArray.getColor(R.styleable.LoadingButton_loading_button_disable_color, GlobalConfig.INSTANCE.getDisableColor());
            int selectedColor = typedArray.hasValue(R.styleable.LoadingButton_loading_button_selected_color) ? typedArray.getColor(R.styleable.LoadingButton_loading_button_selected_color, GlobalConfig.INSTANCE.getSelectedColor()) : UIXColorUtils.INSTANCE.computeColor(normalColor, -16777216, GlobalConfig.INSTANCE.getFraction());
            int cornerRadius = typedArray.getDimensionPixelSize(R.styleable.LoadingButton_loading_button_corner_radius, GlobalConfig.INSTANCE.getCornerRadius());
            this.normalDrawable = (Drawable)UIXImageUtils.INSTANCE.getGradientDrawable(normalColor, (float)cornerRadius);
            this.disableDrawable = (Drawable)UIXImageUtils.INSTANCE.getGradientDrawable(disableColor, (float)cornerRadius);
            GradientDrawable selectedDrawable = UIXImageUtils.INSTANCE.getGradientDrawable(selectedColor, (float)cornerRadius);
            this.loadingStyle = typedArray.getInt(R.styleable.LoadingButton_loading_button_style, 0);
            this.loadingButtonState = typedArray.getInt(R.styleable.LoadingButton_loading_button_state, 0);
            StateListDrawable stateListDrawable = this.stateListDrawable = new StateListDrawable();
            if (stateListDrawable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stateListDrawable");
            }
            stateListDrawable.addState(new int[]{16842919}, (Drawable)selectedDrawable);
            StateListDrawable stateListDrawable2 = this.stateListDrawable;
            if (stateListDrawable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stateListDrawable");
            }
            int[] nArray = new int[]{-16842919};
            Drawable drawable2 = this.normalDrawable;
            if (drawable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"normalDrawable");
            }
            stateListDrawable2.addState(nArray, drawable2);
            this.setState(this.loadingButtonState);
            this.tv.setText((CharSequence)this.text);
            this.tv.setTextSize(0, (float)size);
            this.tv.setTextColor(this.textColor);
            if (this.loadingStyle == 1) {
                this.pb.setIndeterminateDrawable(UIXResUtils.INSTANCE.getDrawable(R.drawable.uix_anim_loading));
            }
            typedArray.recycle();
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001e\u0010\u0015\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001e\u0010\u0018\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001e\u0010\u001b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\b\u00a8\u0006\u001e"}, d2={"Lme/shouheng/uix/widget/button/LoadingButton$GlobalConfig;", "", "()V", "cornerRadius", "", "getCornerRadius", "()I", "setCornerRadius", "(I)V", "disableColor", "getDisableColor", "setDisableColor", "fraction", "", "getFraction", "()F", "setFraction", "(F)V", "normalColor", "getNormalColor", "setNormalColor", "selectedColor", "getSelectedColor", "setSelectedColor", "textColor", "getTextColor", "setTextColor", "textDisableColor", "getTextDisableColor", "setTextDisableColor", "uix-widget_release"})
    public static final class GlobalConfig {
        @ColorInt
        private static int textColor;
        @ColorInt
        private static int textDisableColor;
        @ColorInt
        private static int normalColor;
        @FloatRange(from=0.0, to=1.0)
        private static float fraction;
        @ColorInt
        private static int selectedColor;
        @ColorInt
        private static int disableColor;
        @Px
        private static int cornerRadius;
        public static final GlobalConfig INSTANCE;

        public final int getTextColor() {
            return textColor;
        }

        public final void setTextColor(int n) {
            textColor = n;
        }

        public final int getTextDisableColor() {
            return textDisableColor;
        }

        public final void setTextDisableColor(int n) {
            textDisableColor = n;
        }

        public final int getNormalColor() {
            return normalColor;
        }

        public final void setNormalColor(int n) {
            normalColor = n;
        }

        public final float getFraction() {
            return fraction;
        }

        public final void setFraction(float f) {
            fraction = f;
        }

        public final int getSelectedColor() {
            return selectedColor;
        }

        public final void setSelectedColor(int n) {
            selectedColor = n;
        }

        public final int getDisableColor() {
            return disableColor;
        }

        public final void setDisableColor(int n) {
            disableColor = n;
        }

        public final int getCornerRadius() {
            return cornerRadius;
        }

        public final void setCornerRadius(int n) {
            cornerRadius = n;
        }

        private GlobalConfig() {
        }

        static {
            GlobalConfig globalConfig;
            INSTANCE = globalConfig = new GlobalConfig();
            textColor = -16777216;
            textDisableColor = -16777216;
            fraction = 0.1f;
            cornerRadius = UIXViewUtils.INSTANCE.dp2px(30.0f);
        }
    }
}

