/*
 * Decompiled with CFR 0.152.
 */
package me.shouheng.uix.widget.button;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.CompoundButton;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.shouheng.uix.common.utils.UIXColorUtils;
import me.shouheng.uix.widget.R;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\r\n\u0002\b \n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b(\u0018\u0000 \u00ce\u00012\u00020\u0001:\u0004\u00ce\u0001\u00cf\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020(H\u0004J\n\u0010\u008d\u0001\u001a\u00030\u008b\u0001H\u0002J\u0013\u0010\u008e\u0001\u001a\u00020\u00072\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0002J\n\u0010\u0091\u0001\u001a\u00030\u008b\u0001H\u0014J\u0014\u0010\u0092\u0001\u001a\u00030\u008b\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010\u0093\u0001\u001a\u00020C2\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010jH\u0002J\u0012\u0010\u0095\u0001\u001a\u00020\u00072\u0007\u0010\u0096\u0001\u001a\u00020\u0007H\u0002J\u0012\u0010\u0097\u0001\u001a\u00020\u00072\u0007\u0010\u0098\u0001\u001a\u00020\u0007H\u0002J\u0014\u0010\u0099\u0001\u001a\u00030\u008b\u00012\b\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0014J\u001c\u0010\u009c\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u0098\u0001\u001a\u00020\u00072\u0007\u0010\u0096\u0001\u001a\u00020\u0007H\u0014J\u0014\u0010\u009d\u0001\u001a\u00030\u008b\u00012\b\u0010\u009e\u0001\u001a\u00030\u009f\u0001H\u0016J\f\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u009f\u0001H\u0016J.\u0010\u00a1\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00a2\u0001\u001a\u00020\u00072\u0007\u0010\u00a3\u0001\u001a\u00020\u00072\u0007\u0010\u00a4\u0001\u001a\u00020\u00072\u0007\u0010\u00a5\u0001\u001a\u00020\u0007H\u0014J\u0013\u0010\u00a6\u0001\u001a\u00020(2\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u0001H\u0016J\t\u0010\u00a9\u0001\u001a\u00020(H\u0016J\u0011\u0010\u00aa\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00ab\u0001\u001a\u00020\u0007J\u0011\u0010\u00ac\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00ad\u0001\u001a\u00020\u0007J\u0013\u0010\u00ae\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020(H\u0016J\u0011\u0010\u00af\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020(J\u0011\u0010\u00b0\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020(J\u0011\u0010\u00b1\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u008c\u0001\u001a\u00020(J\u0015\u0010\u00b2\u0001\u001a\u00030\u008b\u00012\t\u0010\u00b3\u0001\u001a\u0004\u0018\u00010\u0018H\u0002J\u0015\u0010\u00b4\u0001\u001a\u00030\u008b\u00012\t\u0010\u00b5\u0001\u001a\u0004\u0018\u000108H\u0016J\u001e\u0010\u00b6\u0001\u001a\u00030\u008b\u00012\t\u0010\u00b7\u0001\u001a\u0004\u0018\u00010j2\t\u0010\u00b8\u0001\u001a\u0004\u0018\u00010jJ\u0011\u0010\u00b9\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00ba\u0001\u001a\u00020\u0007J\u0011\u0010\u00bb\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00bc\u0001\u001a\u00020\u0007J\u0011\u0010\u00bd\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00be\u0001\u001a\u00020\u0007J\u0011\u0010\u00bf\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00c0\u0001\u001a\u00020\u0007J\u0011\u0010\u00c1\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00c2\u0001\u001a\u00020\u0007J+\u0010{\u001a\u00030\u008b\u00012\u0007\u0010\u00c3\u0001\u001a\u00020\u001e2\u0007\u0010\u00c4\u0001\u001a\u00020\u001e2\u0007\u0010\u00c5\u0001\u001a\u00020\u001e2\u0007\u0010\u00c6\u0001\u001a\u00020\u001eJ\u001a\u0010\u00c7\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00c8\u0001\u001a\u00020\u00072\u0007\u0010\u00c9\u0001\u001a\u00020\u0007J\n\u0010\u00ca\u0001\u001a\u00030\u008b\u0001H\u0002J\b\u0010\u00cb\u0001\u001a\u00030\u008b\u0001J\b\u0010\u00cc\u0001\u001a\u00030\u008b\u0001J\b\u0010\u00cd\u0001\u001a\u00030\u008b\u0001R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R$\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010*\"\u0004\b.\u0010,R\u0010\u0010/\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010U\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010V\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010W\u001a\u0004\u0018\u00010XX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010Z\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010[\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\\\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010^\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010`\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010a\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010e\u001a\u00020\u001e2\u0006\u0010e\u001a\u00020\u001e@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\bf\u0010\"R\u0014\u0010g\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bh\u0010*R\"\u0010k\u001a\u0004\u0018\u00010j2\b\u0010i\u001a\u0004\u0018\u00010j@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010mR\"\u0010n\u001a\u0004\u0018\u00010j2\b\u0010i\u001a\u0004\u0018\u00010j@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010mR(\u0010p\u001a\u0004\u0018\u00010\u00122\b\u0010p\u001a\u0004\u0018\u00010\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bq\u0010\u0014\"\u0004\br\u0010\u0016R(\u0010s\u001a\u0004\u0018\u00010\u00182\b\u0010s\u001a\u0004\u0018\u00010\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bt\u0010\u001a\"\u0004\bu\u0010\u001cR\u0011\u0010v\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\bw\u0010 R(\u0010x\u001a\u0004\u0018\u0001042\b\u0010x\u001a\u0004\u0018\u0001048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\by\u0010z\"\u0004\b{\u0010|R$\u0010}\u001a\u00020\u001e2\u0006\u0010}\u001a\u00020\u001e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b~\u0010 \"\u0004\b\u007f\u0010\"R(\u0010\u0080\u0001\u001a\u00020\u001e2\u0007\u0010\u0080\u0001\u001a\u00020\u001e8F@FX\u0086\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0081\u0001\u0010 \"\u0005\b\u0082\u0001\u0010\"R\u0013\u0010\u0083\u0001\u001a\u00020\u001e8F\u00a2\u0006\u0007\u001a\u0005\b\u0084\u0001\u0010 R*\u0010\u0085\u0001\u001a\u00020\u00072\u0007\u0010\u0085\u0001\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\u0010\u001a\u0006\b\u0086\u0001\u0010\u0087\u0001\"\u0006\b\u0088\u0001\u0010\u0089\u0001\u00a8\u0006\u00d0\u0001"}, d2={"Lme/shouheng/uix/widget/button/SwitchButton;", "Landroid/widget/CompoundButton;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "(Landroid/content/Context;)V", "animationDuration", "", "getAnimationDuration", "()J", "setAnimationDuration", "(J)V", "backColor", "Landroid/content/res/ColorStateList;", "getBackColor", "()Landroid/content/res/ColorStateList;", "setBackColor", "(Landroid/content/res/ColorStateList;)V", "backDrawable", "Landroid/graphics/drawable/Drawable;", "getBackDrawable", "()Landroid/graphics/drawable/Drawable;", "setBackDrawable", "(Landroid/graphics/drawable/Drawable;)V", "backRadius", "", "getBackRadius", "()F", "setBackRadius", "(F)V", "backSizeF", "Landroid/graphics/PointF;", "getBackSizeF", "()Landroid/graphics/PointF;", "drawDebugRect", "", "isDrawDebugRect", "()Z", "setDrawDebugRect", "(Z)V", "isFadeBack", "setFadeBack", "mBackColor", "mBackDrawable", "mBackHeight", "mBackRadius", "mBackRectF", "Landroid/graphics/RectF;", "mBackWidth", "mCatch", "mChildOnCheckedChangeListener", "Landroid/widget/CompoundButton$OnCheckedChangeListener;", "mClickTimeout", "mCurrBackColor", "mCurrThumbColor", "mCurrentBackDrawable", "mIsBackUseDrawable", "mIsThumbUseDrawable", "mLastX", "mNextBackColor", "mNextBackDrawable", "mOffLayout", "Landroid/text/Layout;", "mOffTextColor", "mOnLayout", "mOnTextColor", "mPaint", "Landroid/graphics/Paint;", "mPresentThumbRectF", "mProgressAnimator", "Landroid/animation/ObjectAnimator;", "mReady", "mRectPaint", "mRestoring", "mSafeRectF", "mStartX", "mStartY", "mTextAdjust", "mTextExtra", "mTextHeight", "mTextOffRectF", "mTextOnRectF", "mTextPaint", "Landroid/text/TextPaint;", "mTextThumbInset", "mTextWidth", "mThumbColor", "mThumbDrawable", "mThumbHeight", "mThumbMargin", "mThumbRadius", "mThumbRangeRatio", "mThumbRectF", "mThumbWidth", "mTintColor", "mTouchSlop", "progress", "setProgress", "statusBasedOnPos", "getStatusBasedOnPos", "<set-?>", "", "textOff", "getTextOff", "()Ljava/lang/CharSequence;", "textOn", "getTextOn", "thumbColor", "getThumbColor", "setThumbColor", "thumbDrawable", "getThumbDrawable", "setThumbDrawable", "thumbHeight", "getThumbHeight", "thumbMargin", "getThumbMargin", "()Landroid/graphics/RectF;", "setThumbMargin", "(Landroid/graphics/RectF;)V", "thumbRadius", "getThumbRadius", "setThumbRadius", "thumbRangeRatio", "getThumbRangeRatio", "setThumbRangeRatio", "thumbWidth", "getThumbWidth", "tintColor", "getTintColor", "()I", "setTintColor", "(I)V", "animateToState", "", "checked", "catchView", "ceil", "dimen", "", "drawableStateChanged", "init", "makeLayout", "text", "measureHeight", "heightMeasureSpec", "measureWidth", "widthMeasureSpec", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "performClick", "setBackColorRes", "backColorRes", "setBackDrawableRes", "backDrawableRes", "setChecked", "setCheckedImmediately", "setCheckedImmediatelyNoEvent", "setCheckedNoEvent", "setDrawableState", "drawable", "setOnCheckedChangeListener", "onCheckedChangeListener", "setText", "onText", "offText", "setTextAdjust", "textAdjust", "setTextExtra", "textExtra", "setTextThumbInset", "textThumbInset", "setThumbColorRes", "thumbColorRes", "setThumbDrawableRes", "thumbDrawableRes", "left", "top", "right", "bottom", "setThumbSize", "width", "height", "setup", "toggleImmediately", "toggleImmediatelyNoEvent", "toggleNoEvent", "Companion", "SavedState", "uix-widget_release"})
public final class SwitchButton
extends CompoundButton {
    private Drawable mThumbDrawable;
    private Drawable mBackDrawable;
    private ColorStateList mBackColor;
    private ColorStateList mThumbColor;
    private float mThumbRadius;
    private float mBackRadius;
    private RectF mThumbMargin;
    private float mThumbRangeRatio;
    private long animationDuration;
    private boolean isFadeBack;
    private int mTintColor;
    private int mThumbWidth;
    private int mThumbHeight;
    private int mBackWidth;
    private int mBackHeight;
    private int mCurrThumbColor;
    private int mCurrBackColor;
    private int mNextBackColor;
    private int mOnTextColor;
    private int mOffTextColor;
    private Drawable mCurrentBackDrawable;
    private Drawable mNextBackDrawable;
    private RectF mThumbRectF;
    private RectF mBackRectF;
    private RectF mSafeRectF;
    private RectF mTextOnRectF;
    private RectF mTextOffRectF;
    private Paint mPaint;
    private boolean mIsThumbUseDrawable;
    private boolean mIsBackUseDrawable;
    private boolean isDrawDebugRect;
    private ObjectAnimator mProgressAnimator;
    private float progress;
    private RectF mPresentThumbRectF;
    private float mStartX;
    private float mStartY;
    private float mLastX;
    private int mTouchSlop;
    private int mClickTimeout;
    private Paint mRectPaint;
    @Nullable
    private CharSequence textOn;
    @Nullable
    private CharSequence textOff;
    private TextPaint mTextPaint;
    private Layout mOnLayout;
    private Layout mOffLayout;
    private float mTextWidth;
    private float mTextHeight;
    private int mTextThumbInset;
    private int mTextExtra;
    private int mTextAdjust;
    private boolean mRestoring;
    private boolean mReady;
    private boolean mCatch;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    public static final float DEFAULT_THUMB_RANGE_RATIO = 1.8f;
    public static final int DEFAULT_THUMB_SIZE_DP = 20;
    public static final int DEFAULT_THUMB_MARGIN_DP = 2;
    public static final int DEFAULT_ANIMATION_DURATION = 250;
    public static final int DEFAULT_TINT_COLOR = 3309506;
    private static final int[] CHECKED_PRESSED_STATE;
    private static final int[] UNCHECKED_PRESSED_STATE;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final long getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(long l) {
        this.animationDuration = l;
    }

    public final boolean isFadeBack() {
        return this.isFadeBack;
    }

    public final void setFadeBack(boolean bl) {
        this.isFadeBack = bl;
    }

    public final boolean isDrawDebugRect() {
        return this.isDrawDebugRect;
    }

    public final void setDrawDebugRect(boolean drawDebugRect) {
        this.isDrawDebugRect = drawDebugRect;
        this.invalidate();
    }

    private final void setProgress(float progress) {
        float tp = progress;
        if (tp > 1.0f) {
            tp = 1.0f;
        } else if (tp < 0.0f) {
            tp = 0.0f;
        }
        this.progress = tp;
        this.invalidate();
    }

    @Nullable
    public final CharSequence getTextOn() {
        return this.textOn;
    }

    @Nullable
    public final CharSequence getTextOff() {
        return this.textOff;
    }

    private final boolean getStatusBasedOnPos() {
        return this.progress > 0.5f;
    }

    @Nullable
    public final Drawable getThumbDrawable() {
        return this.mThumbDrawable;
    }

    public final void setThumbDrawable(@Nullable Drawable thumbDrawable) {
        this.mThumbDrawable = thumbDrawable;
        this.mIsThumbUseDrawable = this.mThumbDrawable != null;
        this.refreshDrawableState();
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    @Nullable
    public final Drawable getBackDrawable() {
        return this.mBackDrawable;
    }

    public final void setBackDrawable(@Nullable Drawable backDrawable) {
        this.mBackDrawable = backDrawable;
        this.mIsBackUseDrawable = this.mBackDrawable != null;
        this.refreshDrawableState();
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    @Nullable
    public final ColorStateList getBackColor() {
        return this.mBackColor;
    }

    public final void setBackColor(@Nullable ColorStateList backColor) {
        this.mBackColor = backColor;
        if (this.mBackColor != null) {
            this.setBackDrawable(null);
        }
        this.invalidate();
    }

    @Nullable
    public final ColorStateList getThumbColor() {
        return this.mThumbColor;
    }

    public final void setThumbColor(@Nullable ColorStateList thumbColor) {
        this.mThumbColor = thumbColor;
        if (this.mThumbColor != null) {
            this.setThumbDrawable(null);
        }
        this.invalidate();
    }

    public final float getThumbRangeRatio() {
        return this.mThumbRangeRatio;
    }

    public final void setThumbRangeRatio(float thumbRangeRatio) {
        this.mThumbRangeRatio = thumbRangeRatio;
        this.mReady = false;
        this.requestLayout();
    }

    @Nullable
    public final RectF getThumbMargin() {
        return this.mThumbMargin;
    }

    public final void setThumbMargin(@Nullable RectF thumbMargin) {
        if (thumbMargin == null) {
            this.setThumbMargin(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            this.setThumbMargin(thumbMargin.left, thumbMargin.top, thumbMargin.right, thumbMargin.bottom);
        }
    }

    public final float getThumbWidth() {
        return this.mThumbWidth;
    }

    public final float getThumbHeight() {
        return this.mThumbHeight;
    }

    public final float getThumbRadius() {
        return this.mThumbRadius;
    }

    public final void setThumbRadius(float thumbRadius) {
        this.mThumbRadius = thumbRadius;
        if (!this.mIsThumbUseDrawable) {
            this.invalidate();
        }
    }

    @NotNull
    public final PointF getBackSizeF() {
        RectF rectF = this.mBackRectF;
        if (rectF == null) {
            Intrinsics.throwNpe();
        }
        float f = rectF.width();
        RectF rectF2 = this.mBackRectF;
        if (rectF2 == null) {
            Intrinsics.throwNpe();
        }
        return new PointF(f, rectF2.height());
    }

    public final float getBackRadius() {
        return this.mBackRadius;
    }

    public final void setBackRadius(float backRadius) {
        this.mBackRadius = backRadius;
        if (!this.mIsBackUseDrawable) {
            this.invalidate();
        }
    }

    public final int getTintColor() {
        return this.mTintColor;
    }

    public final void setTintColor(int tintColor) {
        this.mTintColor = tintColor;
        this.mThumbColor = UIXColorUtils.INSTANCE.generateThumbColorWithTintColor(this.mTintColor);
        this.mBackColor = UIXColorUtils.INSTANCE.generateBackColorWithTintColor(this.mTintColor);
        this.mIsBackUseDrawable = false;
        this.mIsThumbUseDrawable = false;
        this.refreshDrawableState();
        this.invalidate();
    }

    private final void init(AttributeSet attrs) {
        TypedArray ta;
        Resources res;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)viewConfiguration, (String)"ViewConfiguration.get(context)");
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mClickTimeout = ViewConfiguration.getPressedStateDuration() + ViewConfiguration.getTapTimeout();
        this.mPaint = new Paint(1);
        Paint paint = this.mRectPaint = new Paint(1);
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        paint.setStyle(Paint.Style.STROKE);
        Paint paint2 = this.mRectPaint;
        if (paint2 == null) {
            Intrinsics.throwNpe();
        }
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        paint2.setStrokeWidth(resources.getDisplayMetrics().density);
        this.mTextPaint = this.getPaint();
        this.mThumbRectF = new RectF();
        this.mBackRectF = new RectF();
        this.mSafeRectF = new RectF();
        this.mThumbMargin = new RectF();
        this.mTextOnRectF = new RectF();
        this.mTextOffRectF = new RectF();
        ObjectAnimator objectAnimator = this.mProgressAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"progress", (float[])new float[]{0.0f, 0.0f}).setDuration((long)250);
        if (objectAnimator == null) {
            Intrinsics.throwNpe();
        }
        objectAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mPresentThumbRectF = new RectF();
        Resources resources2 = res = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"res");
        float density = resources2.getDisplayMetrics().density;
        Drawable thumbDrawable = null;
        ColorStateList thumbColor = null;
        float margin = density * (float)2;
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        float marginTop = 0.0f;
        float marginBottom = 0.0f;
        float thumbWidth = 0.0f;
        float thumbHeight = 0.0f;
        float thumbRadius = -1.0f;
        float backRadius = -1.0f;
        Drawable backDrawable = null;
        ColorStateList backColor = null;
        float thumbRangeRatio = 1.8f;
        int animationDuration = 250;
        boolean fadeBack = true;
        int tintColor = 0;
        String textOn = null;
        String textOff = null;
        int textThumbInset = 0;
        int textExtra = 0;
        int textAdjust = 0;
        TypedArray typedArray = ta = attrs == null ? null : this.getContext().obtainStyledAttributes(attrs, R.styleable.SwitchButton);
        if (ta != null) {
            thumbDrawable = ta.getDrawable(R.styleable.SwitchButton_kswThumbDrawable);
            thumbColor = ta.getColorStateList(R.styleable.SwitchButton_kswThumbColor);
            margin = ta.getDimension(R.styleable.SwitchButton_kswThumbMargin, margin);
            marginLeft = ta.getDimension(R.styleable.SwitchButton_kswThumbMarginLeft, margin);
            marginRight = ta.getDimension(R.styleable.SwitchButton_kswThumbMarginRight, margin);
            marginTop = ta.getDimension(R.styleable.SwitchButton_kswThumbMarginTop, margin);
            marginBottom = ta.getDimension(R.styleable.SwitchButton_kswThumbMarginBottom, margin);
            thumbWidth = ta.getDimension(R.styleable.SwitchButton_kswThumbWidth, thumbWidth);
            thumbHeight = ta.getDimension(R.styleable.SwitchButton_kswThumbHeight, thumbHeight);
            thumbRadius = ta.getDimension(R.styleable.SwitchButton_kswThumbRadius, thumbRadius);
            backRadius = ta.getDimension(R.styleable.SwitchButton_kswBackRadius, backRadius);
            backDrawable = ta.getDrawable(R.styleable.SwitchButton_kswBackDrawable);
            backColor = ta.getColorStateList(R.styleable.SwitchButton_kswBackColor);
            thumbRangeRatio = ta.getFloat(R.styleable.SwitchButton_kswThumbRangeRatio, thumbRangeRatio);
            animationDuration = ta.getInteger(R.styleable.SwitchButton_kswAnimationDuration, animationDuration);
            fadeBack = ta.getBoolean(R.styleable.SwitchButton_kswFadeBack, true);
            tintColor = ta.getColor(R.styleable.SwitchButton_kswTintColor, tintColor);
            textOn = ta.getString(R.styleable.SwitchButton_kswTextOn);
            textOff = ta.getString(R.styleable.SwitchButton_kswTextOff);
            textThumbInset = ta.getDimensionPixelSize(R.styleable.SwitchButton_kswTextThumbInset, 0);
            textExtra = ta.getDimensionPixelSize(R.styleable.SwitchButton_kswTextExtra, 0);
            textAdjust = ta.getDimensionPixelSize(R.styleable.SwitchButton_kswTextAdjust, 0);
            ta.recycle();
        }
        TypedArray typedArray2 = ta = attrs == null ? null : this.getContext().obtainStyledAttributes(attrs, new int[]{16842970, 16842981});
        if (ta != null) {
            boolean focusable = ta.getBoolean(0, true);
            boolean clickable = ta.getBoolean(1, focusable);
            this.setFocusable(focusable);
            this.setClickable(clickable);
            ta.recycle();
        } else {
            this.setFocusable(true);
            this.setClickable(true);
        }
        this.textOn = textOn;
        this.textOff = textOff;
        this.mTextThumbInset = textThumbInset;
        this.mTextExtra = textExtra;
        this.mTextAdjust = textAdjust;
        this.mThumbDrawable = thumbDrawable;
        this.mThumbColor = thumbColor;
        this.mIsThumbUseDrawable = this.mThumbDrawable != null;
        this.mTintColor = tintColor;
        if (this.mTintColor == 0) {
            TypedValue typedValue = new TypedValue();
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            boolean found = context.getTheme().resolveAttribute(R.attr.colorAccent, typedValue, true);
            this.mTintColor = found ? typedValue.data : 3309506;
        }
        if (!this.mIsThumbUseDrawable && this.mThumbColor == null) {
            ColorStateList colorStateList = this.mThumbColor = UIXColorUtils.INSTANCE.generateThumbColorWithTintColor(this.mTintColor);
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            this.mCurrThumbColor = colorStateList.getDefaultColor();
        }
        this.mThumbWidth = this.ceil(thumbWidth);
        this.mThumbHeight = this.ceil(thumbHeight);
        this.mBackDrawable = backDrawable;
        this.mBackColor = backColor;
        boolean bl = this.mIsBackUseDrawable = this.mBackDrawable != null;
        if (!this.mIsBackUseDrawable && this.mBackColor == null) {
            ColorStateList colorStateList = this.mBackColor = UIXColorUtils.INSTANCE.generateBackColorWithTintColor(this.mTintColor);
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            this.mCurrBackColor = colorStateList.getDefaultColor();
            ColorStateList colorStateList2 = this.mBackColor;
            if (colorStateList2 == null) {
                Intrinsics.throwNpe();
            }
            this.mNextBackColor = colorStateList2.getColorForState(CHECKED_PRESSED_STATE, this.mCurrBackColor);
        }
        RectF rectF = this.mThumbMargin;
        if (rectF == null) {
            Intrinsics.throwNpe();
        }
        rectF.set(marginLeft, marginTop, marginRight, marginBottom);
        RectF rectF2 = this.mThumbMargin;
        if (rectF2 == null) {
            Intrinsics.throwNpe();
        }
        this.mThumbRangeRatio = rectF2.width() >= 0.0f ? Math.max(thumbRangeRatio, 1.0f) : thumbRangeRatio;
        this.mThumbRadius = thumbRadius;
        this.mBackRadius = backRadius;
        this.animationDuration = animationDuration;
        this.isFadeBack = fadeBack;
        ObjectAnimator objectAnimator2 = this.mProgressAnimator;
        if (objectAnimator2 == null) {
            Intrinsics.throwNpe();
        }
        objectAnimator2.setDuration(this.animationDuration);
        if (this.isChecked()) {
            this.setProgress(1.0f);
        }
    }

    private final Layout makeLayout(CharSequence text) {
        return (Layout)new StaticLayout(text, this.mTextPaint, (int)Math.ceil(Layout.getDesiredWidth((CharSequence)text, (TextPaint)this.mTextPaint)), Layout.Alignment.ALIGN_CENTER, 1.0f, 0.0f, false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.mOnLayout == null && !TextUtils.isEmpty((CharSequence)this.textOn)) {
            this.mOnLayout = this.makeLayout(this.textOn);
        }
        if (this.mOffLayout == null && !TextUtils.isEmpty((CharSequence)this.textOff)) {
            this.mOffLayout = this.makeLayout(this.textOff);
        }
        if (this.mOnLayout != null) {
            Layout layout2 = this.mOnLayout;
            if (layout2 == null) {
                Intrinsics.throwNpe();
            }
            n4 = layout2.getWidth();
        } else {
            n4 = 0;
        }
        float onWidth = n4;
        if (this.mOffLayout != null) {
            Layout layout3 = this.mOffLayout;
            if (layout3 == null) {
                Intrinsics.throwNpe();
            }
            n3 = layout3.getWidth();
        } else {
            n3 = 0;
        }
        float offWidth = n3;
        this.mTextWidth = onWidth != 0.0f || offWidth != 0.0f ? Math.max(onWidth, offWidth) : 0.0f;
        if (this.mOnLayout != null) {
            Layout layout4 = this.mOnLayout;
            if (layout4 == null) {
                Intrinsics.throwNpe();
            }
            n2 = layout4.getHeight();
        } else {
            n2 = 0;
        }
        float onHeight = n2;
        if (this.mOffLayout != null) {
            Layout layout5 = this.mOffLayout;
            if (layout5 == null) {
                Intrinsics.throwNpe();
            }
            n = layout5.getHeight();
        } else {
            n = 0;
        }
        float offHeight = n;
        this.mTextHeight = onHeight != 0.0f || offHeight != 0.0f ? Math.max(onHeight, offHeight) : 0.0f;
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private final int measureWidth(int widthMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int measuredWidth = widthSize;
        if (this.mThumbWidth == 0 && this.mIsThumbUseDrawable) {
            Drawable drawable2 = this.mThumbDrawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            this.mThumbWidth = drawable2.getIntrinsicWidth();
        }
        int moveRange = 0;
        int textWidth = this.ceil(this.mTextWidth);
        int textExtraSpace = 0;
        int contentSize = 0;
        if (this.mThumbRangeRatio == 0.0f) {
            this.mThumbRangeRatio = 1.8f;
        }
        if (widthMode == 0x40000000) {
            contentSize = widthSize - this.getPaddingLeft() - this.getPaddingRight();
            if (this.mThumbWidth != 0) {
                moveRange = this.ceil((float)this.mThumbWidth * this.mThumbRangeRatio);
                RectF rectF = this.mThumbMargin;
                if (rectF == null) {
                    Intrinsics.throwNpe();
                }
                float f = rectF.left;
                RectF rectF2 = this.mThumbMargin;
                if (rectF2 == null) {
                    Intrinsics.throwNpe();
                }
                textExtraSpace = textWidth + this.mTextExtra - (moveRange - this.mThumbWidth + this.ceil(Math.max(f, rectF2.right)));
                float f2 = moveRange;
                RectF rectF3 = this.mThumbMargin;
                if (rectF3 == null) {
                    Intrinsics.throwNpe();
                }
                float f3 = f2 + rectF3.left;
                RectF rectF4 = this.mThumbMargin;
                if (rectF4 == null) {
                    Intrinsics.throwNpe();
                }
                this.mBackWidth = this.ceil(f3 + rectF4.right + (float)Math.max(textExtraSpace, 0));
                if (this.mBackWidth < 0) {
                    this.mThumbWidth = 0;
                }
                float f4 = moveRange;
                RectF rectF5 = this.mThumbMargin;
                if (rectF5 == null) {
                    Intrinsics.throwNpe();
                }
                float f5 = f4 + Math.max(rectF5.left, 0.0f);
                RectF rectF6 = this.mThumbMargin;
                if (rectF6 == null) {
                    Intrinsics.throwNpe();
                }
                if (f5 + Math.max(rectF6.right, 0.0f) + (float)Math.max(textExtraSpace, 0) > (float)contentSize) {
                    this.mThumbWidth = 0;
                }
            }
            if (this.mThumbWidth == 0) {
                contentSize = widthSize - this.getPaddingLeft() - this.getPaddingRight();
                float f = contentSize;
                RectF rectF = this.mThumbMargin;
                if (rectF == null) {
                    Intrinsics.throwNpe();
                }
                float f6 = f - Math.max(rectF.left, 0.0f);
                RectF rectF7 = this.mThumbMargin;
                if (rectF7 == null) {
                    Intrinsics.throwNpe();
                }
                if ((moveRange = this.ceil(f6 - Math.max(rectF7.right, 0.0f))) < 0) {
                    this.mThumbWidth = 0;
                    this.mBackWidth = 0;
                    return measuredWidth;
                }
                this.mThumbWidth = this.ceil((float)moveRange / this.mThumbRangeRatio);
                float f7 = moveRange;
                RectF rectF8 = this.mThumbMargin;
                if (rectF8 == null) {
                    Intrinsics.throwNpe();
                }
                float f8 = f7 + rectF8.left;
                RectF rectF9 = this.mThumbMargin;
                if (rectF9 == null) {
                    Intrinsics.throwNpe();
                }
                this.mBackWidth = this.ceil(f8 + rectF9.right);
                if (this.mBackWidth < 0) {
                    this.mThumbWidth = 0;
                    this.mBackWidth = 0;
                    return measuredWidth;
                }
                RectF rectF10 = this.mThumbMargin;
                if (rectF10 == null) {
                    Intrinsics.throwNpe();
                }
                float f9 = rectF10.left;
                RectF rectF11 = this.mThumbMargin;
                if (rectF11 == null) {
                    Intrinsics.throwNpe();
                }
                if ((textExtraSpace = textWidth + this.mTextExtra - (moveRange - this.mThumbWidth + this.ceil(Math.max(f9, rectF11.right)))) > 0) {
                    this.mThumbWidth -= textExtraSpace;
                }
                if (this.mThumbWidth < 0) {
                    this.mThumbWidth = 0;
                    this.mBackWidth = 0;
                    return measuredWidth;
                }
            }
        } else {
            if (this.mThumbWidth == 0) {
                Resources resources = this.getResources();
                Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
                this.mThumbWidth = this.ceil(resources.getDisplayMetrics().density * (float)20);
            }
            if (this.mThumbRangeRatio == 0.0f) {
                this.mThumbRangeRatio = 1.8f;
            }
            moveRange = this.ceil((float)this.mThumbWidth * this.mThumbRangeRatio);
            float f = textWidth + this.mTextExtra;
            float f10 = moveRange - this.mThumbWidth;
            RectF rectF = this.mThumbMargin;
            if (rectF == null) {
                Intrinsics.throwNpe();
            }
            float f11 = rectF.left;
            RectF rectF12 = this.mThumbMargin;
            if (rectF12 == null) {
                Intrinsics.throwNpe();
            }
            textExtraSpace = this.ceil(f - (f10 + Math.max(f11, rectF12.right) + (float)this.mTextThumbInset));
            float f12 = moveRange;
            RectF rectF13 = this.mThumbMargin;
            if (rectF13 == null) {
                Intrinsics.throwNpe();
            }
            float f13 = f12 + rectF13.left;
            RectF rectF14 = this.mThumbMargin;
            if (rectF14 == null) {
                Intrinsics.throwNpe();
            }
            this.mBackWidth = this.ceil(f13 + rectF14.right + (float)Math.max(0, textExtraSpace));
            if (this.mBackWidth < 0) {
                this.mThumbWidth = 0;
                this.mBackWidth = 0;
                return measuredWidth;
            }
            float f14 = moveRange;
            RectF rectF15 = this.mThumbMargin;
            if (rectF15 == null) {
                Intrinsics.throwNpe();
            }
            float f15 = f14 + Math.max(0.0f, rectF15.left);
            RectF rectF16 = this.mThumbMargin;
            if (rectF16 == null) {
                Intrinsics.throwNpe();
            }
            contentSize = this.ceil(f15 + Math.max(0.0f, rectF16.right) + (float)Math.max(0, textExtraSpace));
            measuredWidth = Math.max(contentSize, contentSize + this.getPaddingLeft() + this.getPaddingRight());
        }
        return measuredWidth;
    }

    private final int measureHeight(int heightMeasureSpec) {
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int measuredHeight = heightSize;
        if (this.mThumbHeight == 0 && this.mIsThumbUseDrawable) {
            Drawable drawable2 = this.mThumbDrawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            this.mThumbHeight = drawable2.getIntrinsicHeight();
        }
        int contentSize = 0;
        int textExtraSpace = 0;
        if (heightMode == 0x40000000) {
            if (this.mThumbHeight != 0) {
                float f = this.mThumbHeight;
                RectF rectF = this.mThumbMargin;
                if (rectF == null) {
                    Intrinsics.throwNpe();
                }
                float f2 = f + rectF.top;
                RectF rectF2 = this.mThumbMargin;
                if (rectF2 == null) {
                    Intrinsics.throwNpe();
                }
                this.mBackHeight = this.ceil(f2 + rectF2.bottom);
                this.mBackHeight = this.ceil(Math.max((float)this.mBackHeight, this.mTextHeight));
                float f3 = this.mBackHeight + this.getPaddingTop() + this.getPaddingBottom();
                RectF rectF3 = this.mThumbMargin;
                if (rectF3 == null) {
                    Intrinsics.throwNpe();
                }
                float f4 = f3 - Math.min(0.0f, rectF3.top);
                RectF rectF4 = this.mThumbMargin;
                if (rectF4 == null) {
                    Intrinsics.throwNpe();
                }
                if (f4 - Math.min(0.0f, rectF4.bottom) > (float)heightSize) {
                    this.mThumbHeight = 0;
                }
            }
            if (this.mThumbHeight == 0) {
                float f = heightSize - this.getPaddingTop() - this.getPaddingBottom();
                RectF rectF = this.mThumbMargin;
                if (rectF == null) {
                    Intrinsics.throwNpe();
                }
                float f5 = f + Math.min(0.0f, rectF.top);
                RectF rectF5 = this.mThumbMargin;
                if (rectF5 == null) {
                    Intrinsics.throwNpe();
                }
                this.mBackHeight = this.ceil(f5 + Math.min(0.0f, rectF5.bottom));
                if (this.mBackHeight < 0) {
                    this.mBackHeight = 0;
                    this.mThumbHeight = 0;
                    return measuredHeight;
                }
                float f6 = this.mBackHeight;
                RectF rectF6 = this.mThumbMargin;
                if (rectF6 == null) {
                    Intrinsics.throwNpe();
                }
                float f7 = f6 - rectF6.top;
                RectF rectF7 = this.mThumbMargin;
                if (rectF7 == null) {
                    Intrinsics.throwNpe();
                }
                this.mThumbHeight = this.ceil(f7 - rectF7.bottom);
            }
            if (this.mThumbHeight < 0) {
                this.mBackHeight = 0;
                this.mThumbHeight = 0;
                return measuredHeight;
            }
        } else {
            if (this.mThumbHeight == 0) {
                Resources resources = this.getResources();
                Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
                this.mThumbHeight = this.ceil(resources.getDisplayMetrics().density * (float)20);
            }
            float f = this.mThumbHeight;
            RectF rectF = this.mThumbMargin;
            if (rectF == null) {
                Intrinsics.throwNpe();
            }
            float f8 = f + rectF.top;
            RectF rectF8 = this.mThumbMargin;
            if (rectF8 == null) {
                Intrinsics.throwNpe();
            }
            this.mBackHeight = this.ceil(f8 + rectF8.bottom);
            if (this.mBackHeight < 0) {
                this.mBackHeight = 0;
                this.mThumbHeight = 0;
                return measuredHeight;
            }
            textExtraSpace = this.ceil(this.mTextHeight - (float)this.mBackHeight);
            if (textExtraSpace > 0) {
                this.mBackHeight += textExtraSpace;
                this.mThumbHeight += textExtraSpace;
            }
            contentSize = Math.max(this.mThumbHeight, this.mBackHeight);
            measuredHeight = Math.max(contentSize, contentSize + this.getPaddingTop() + this.getPaddingBottom());
            measuredHeight = Math.max(measuredHeight, this.getSuggestedMinimumHeight());
        }
        return measuredHeight;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw || h != oldh) {
            this.setup();
        }
    }

    private final int ceil(double dimen) {
        return (int)Math.ceil(dimen);
    }

    private final void setup() {
        if (this.mThumbWidth == 0 || this.mThumbHeight == 0 || this.mBackWidth == 0 || this.mBackHeight == 0) {
            return;
        }
        if (this.mThumbRadius == -1.0f) {
            this.mThumbRadius = Math.min(this.mThumbWidth, this.mThumbHeight) / 2;
        }
        if (this.mBackRadius == -1.0f) {
            this.mBackRadius = Math.min(this.mBackWidth, this.mBackHeight) / 2;
        }
        int contentWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int contentHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        float f = this.mBackWidth;
        RectF rectF = this.mThumbMargin;
        if (rectF == null) {
            Intrinsics.throwNpe();
        }
        float f2 = f - Math.min(0.0f, rectF.left);
        RectF rectF2 = this.mThumbMargin;
        if (rectF2 == null) {
            Intrinsics.throwNpe();
        }
        int drawingWidth = this.ceil(f2 - Math.min(0.0f, rectF2.right));
        float f3 = this.mBackHeight;
        RectF rectF3 = this.mThumbMargin;
        if (rectF3 == null) {
            Intrinsics.throwNpe();
        }
        float f4 = f3 - Math.min(0.0f, rectF3.top);
        RectF rectF4 = this.mThumbMargin;
        if (rectF4 == null) {
            Intrinsics.throwNpe();
        }
        int drawingHeight = this.ceil(f4 - Math.min(0.0f, rectF4.bottom));
        float thumbTop = 0.0f;
        if (contentHeight <= drawingHeight) {
            float f5 = this.getPaddingTop();
            RectF rectF5 = this.mThumbMargin;
            if (rectF5 == null) {
                Intrinsics.throwNpe();
            }
            thumbTop = f5 + Math.max(0.0f, rectF5.top);
        } else {
            float f6 = this.getPaddingTop();
            RectF rectF6 = this.mThumbMargin;
            if (rectF6 == null) {
                Intrinsics.throwNpe();
            }
            thumbTop = f6 + Math.max(0.0f, rectF6.top) + (float)((contentHeight - drawingHeight + 1) / 2);
        }
        float thumbLeft = 0.0f;
        if (contentWidth <= this.mBackWidth) {
            float f7 = this.getPaddingLeft();
            RectF rectF7 = this.mThumbMargin;
            if (rectF7 == null) {
                Intrinsics.throwNpe();
            }
            thumbLeft = f7 + Math.max(0.0f, rectF7.left);
        } else {
            float f8 = this.getPaddingLeft();
            RectF rectF8 = this.mThumbMargin;
            if (rectF8 == null) {
                Intrinsics.throwNpe();
            }
            thumbLeft = f8 + Math.max(0.0f, rectF8.left) + (float)((contentWidth - drawingWidth + 1) / 2);
        }
        RectF rectF9 = this.mThumbRectF;
        if (rectF9 == null) {
            Intrinsics.throwNpe();
        }
        rectF9.set(thumbLeft, thumbTop, thumbLeft + (float)this.mThumbWidth, thumbTop + (float)this.mThumbHeight);
        RectF rectF10 = this.mThumbRectF;
        if (rectF10 == null) {
            Intrinsics.throwNpe();
        }
        float f9 = rectF10.left;
        RectF rectF11 = this.mThumbMargin;
        if (rectF11 == null) {
            Intrinsics.throwNpe();
        }
        float backLeft = f9 - rectF11.left;
        RectF rectF12 = this.mBackRectF;
        if (rectF12 == null) {
            Intrinsics.throwNpe();
        }
        RectF rectF13 = this.mThumbRectF;
        if (rectF13 == null) {
            Intrinsics.throwNpe();
        }
        float f10 = rectF13.top;
        RectF rectF14 = this.mThumbMargin;
        if (rectF14 == null) {
            Intrinsics.throwNpe();
        }
        float f11 = f10 - rectF14.top;
        float f12 = backLeft + (float)this.mBackWidth;
        RectF rectF15 = this.mThumbRectF;
        if (rectF15 == null) {
            Intrinsics.throwNpe();
        }
        float f13 = rectF15.top;
        RectF rectF16 = this.mThumbMargin;
        if (rectF16 == null) {
            Intrinsics.throwNpe();
        }
        rectF12.set(backLeft, f11, f12, f13 - rectF16.top + (float)this.mBackHeight);
        RectF rectF17 = this.mSafeRectF;
        if (rectF17 == null) {
            Intrinsics.throwNpe();
        }
        RectF rectF18 = this.mThumbRectF;
        if (rectF18 == null) {
            Intrinsics.throwNpe();
        }
        float f14 = rectF18.left;
        RectF rectF19 = this.mBackRectF;
        if (rectF19 == null) {
            Intrinsics.throwNpe();
        }
        float f15 = rectF19.right;
        RectF rectF20 = this.mThumbMargin;
        if (rectF20 == null) {
            Intrinsics.throwNpe();
        }
        float f16 = f15 - rectF20.right;
        RectF rectF21 = this.mThumbRectF;
        if (rectF21 == null) {
            Intrinsics.throwNpe();
        }
        rectF17.set(f14, 0.0f, f16 - rectF21.width(), 0.0f);
        RectF rectF22 = this.mBackRectF;
        if (rectF22 == null) {
            Intrinsics.throwNpe();
        }
        float f17 = rectF22.width();
        RectF rectF23 = this.mBackRectF;
        if (rectF23 == null) {
            Intrinsics.throwNpe();
        }
        float minBackRadius = Math.min(f17, rectF23.height()) / 2.0f;
        this.mBackRadius = Math.min(minBackRadius, this.mBackRadius);
        if (this.mBackDrawable != null) {
            Drawable drawable2 = this.mBackDrawable;
            if (drawable2 == null) {
                Intrinsics.throwNpe();
            }
            RectF rectF24 = this.mBackRectF;
            if (rectF24 == null) {
                Intrinsics.throwNpe();
            }
            int n = (int)rectF24.left;
            RectF rectF25 = this.mBackRectF;
            if (rectF25 == null) {
                Intrinsics.throwNpe();
            }
            int n2 = (int)rectF25.top;
            RectF rectF26 = this.mBackRectF;
            if (rectF26 == null) {
                Intrinsics.throwNpe();
            }
            int n3 = this.ceil(rectF26.right);
            RectF rectF27 = this.mBackRectF;
            if (rectF27 == null) {
                Intrinsics.throwNpe();
            }
            drawable2.setBounds(n, n2, n3, this.ceil(rectF27.bottom));
        }
        if (this.mOnLayout != null) {
            RectF rectF28 = this.mBackRectF;
            if (rectF28 == null) {
                Intrinsics.throwNpe();
            }
            float f18 = rectF28.left;
            RectF rectF29 = this.mBackRectF;
            if (rectF29 == null) {
                Intrinsics.throwNpe();
            }
            float f19 = rectF29.width() + (float)this.mTextThumbInset - (float)this.mThumbWidth;
            RectF rectF30 = this.mThumbMargin;
            if (rectF30 == null) {
                Intrinsics.throwNpe();
            }
            float f20 = f19 - rectF30.right;
            Layout layout2 = this.mOnLayout;
            if (layout2 == null) {
                Intrinsics.throwNpe();
            }
            float onLeft = f18 + (f20 - (float)layout2.getWidth()) / 2.0f - (float)this.mTextAdjust;
            RectF rectF31 = this.mBackRectF;
            if (rectF31 == null) {
                Intrinsics.throwNpe();
            }
            float f21 = rectF31.top;
            RectF rectF32 = this.mBackRectF;
            if (rectF32 == null) {
                Intrinsics.throwNpe();
            }
            float f22 = rectF32.height();
            Layout layout3 = this.mOnLayout;
            if (layout3 == null) {
                Intrinsics.throwNpe();
            }
            float onTop = f21 + (f22 - (float)layout3.getHeight()) / (float)2;
            RectF rectF33 = this.mTextOnRectF;
            if (rectF33 == null) {
                Intrinsics.throwNpe();
            }
            Layout layout4 = this.mOnLayout;
            if (layout4 == null) {
                Intrinsics.throwNpe();
            }
            float f23 = onLeft + (float)layout4.getWidth();
            Layout layout5 = this.mOnLayout;
            if (layout5 == null) {
                Intrinsics.throwNpe();
            }
            rectF33.set(onLeft, onTop, f23, onTop + (float)layout5.getHeight());
        }
        if (this.mOffLayout != null) {
            RectF rectF34 = this.mBackRectF;
            if (rectF34 == null) {
                Intrinsics.throwNpe();
            }
            float f24 = rectF34.right;
            RectF rectF35 = this.mBackRectF;
            if (rectF35 == null) {
                Intrinsics.throwNpe();
            }
            float f25 = rectF35.width() + (float)this.mTextThumbInset - (float)this.mThumbWidth;
            RectF rectF36 = this.mThumbMargin;
            if (rectF36 == null) {
                Intrinsics.throwNpe();
            }
            float f26 = f25 - rectF36.left;
            Layout layout6 = this.mOffLayout;
            if (layout6 == null) {
                Intrinsics.throwNpe();
            }
            float f27 = f24 - (f26 - (float)layout6.getWidth()) / 2.0f;
            Layout layout7 = this.mOffLayout;
            if (layout7 == null) {
                Intrinsics.throwNpe();
            }
            float offLeft = f27 - (float)layout7.getWidth() + (float)this.mTextAdjust;
            RectF rectF37 = this.mBackRectF;
            if (rectF37 == null) {
                Intrinsics.throwNpe();
            }
            float f28 = rectF37.top;
            RectF rectF38 = this.mBackRectF;
            if (rectF38 == null) {
                Intrinsics.throwNpe();
            }
            float f29 = rectF38.height();
            Layout layout8 = this.mOffLayout;
            if (layout8 == null) {
                Intrinsics.throwNpe();
            }
            float offTop = f28 + (f29 - (float)layout8.getHeight()) / (float)2;
            RectF rectF39 = this.mTextOffRectF;
            if (rectF39 == null) {
                Intrinsics.throwNpe();
            }
            Layout layout9 = this.mOffLayout;
            if (layout9 == null) {
                Intrinsics.throwNpe();
            }
            float f30 = offLeft + (float)layout9.getWidth();
            Layout layout10 = this.mOffLayout;
            if (layout10 == null) {
                Intrinsics.throwNpe();
            }
            rectF39.set(offLeft, offTop, f30, offTop + (float)layout10.getHeight());
        }
        this.mReady = true;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        RectF textRectF;
        int alpha;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (!this.mReady) {
            this.setup();
        }
        if (!this.mReady) {
            return;
        }
        if (this.mIsBackUseDrawable) {
            if (this.isFadeBack && this.mCurrentBackDrawable != null && this.mNextBackDrawable != null) {
                Drawable below = this.isChecked() ? this.mCurrentBackDrawable : this.mNextBackDrawable;
                Drawable above = this.isChecked() ? this.mNextBackDrawable : this.mCurrentBackDrawable;
                alpha = (int)((float)255 * this.progress);
                Drawable drawable2 = below;
                if (drawable2 != null) {
                    drawable2.setAlpha(alpha);
                }
                Drawable drawable3 = below;
                if (drawable3 != null) {
                    drawable3.draw(canvas);
                }
                alpha = 255 - alpha;
                Drawable drawable4 = above;
                if (drawable4 != null) {
                    drawable4.setAlpha(alpha);
                }
                Drawable drawable5 = above;
                if (drawable5 != null) {
                    drawable5.draw(canvas);
                }
            } else {
                Drawable drawable6 = this.mBackDrawable;
                if (drawable6 == null) {
                    Intrinsics.throwNpe();
                }
                drawable6.setAlpha(255);
                Drawable drawable7 = this.mBackDrawable;
                if (drawable7 == null) {
                    Intrinsics.throwNpe();
                }
                drawable7.draw(canvas);
            }
        } else if (this.isFadeBack) {
            int alpha2 = 0;
            int colorAlpha = 0;
            int belowColor = this.isChecked() ? this.mCurrBackColor : this.mNextBackColor;
            int aboveColor = this.isChecked() ? this.mNextBackColor : this.mCurrBackColor;
            alpha2 = (int)((float)255 * this.progress);
            colorAlpha = Color.alpha((int)belowColor);
            colorAlpha = colorAlpha * alpha2 / 255;
            Paint paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwNpe();
            }
            paint.setARGB(colorAlpha, Color.red((int)belowColor), Color.green((int)belowColor), Color.blue((int)belowColor));
            RectF rectF = this.mBackRectF;
            if (rectF == null) {
                Intrinsics.throwNpe();
            }
            Paint paint2 = this.mPaint;
            if (paint2 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawRoundRect(rectF, this.mBackRadius, this.mBackRadius, paint2);
            alpha2 = 255 - alpha2;
            colorAlpha = Color.alpha((int)aboveColor);
            colorAlpha = colorAlpha * alpha2 / 255;
            Paint paint3 = this.mPaint;
            if (paint3 == null) {
                Intrinsics.throwNpe();
            }
            paint3.setARGB(colorAlpha, Color.red((int)aboveColor), Color.green((int)aboveColor), Color.blue((int)aboveColor));
            RectF rectF2 = this.mBackRectF;
            if (rectF2 == null) {
                Intrinsics.throwNpe();
            }
            Paint paint4 = this.mPaint;
            if (paint4 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawRoundRect(rectF2, this.mBackRadius, this.mBackRadius, paint4);
            Paint paint5 = this.mPaint;
            if (paint5 == null) {
                Intrinsics.throwNpe();
            }
            paint5.setAlpha(255);
        } else {
            Paint paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwNpe();
            }
            paint.setColor(this.mCurrBackColor);
            RectF rectF = this.mBackRectF;
            if (rectF == null) {
                Intrinsics.throwNpe();
            }
            Paint paint6 = this.mPaint;
            if (paint6 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawRoundRect(rectF, this.mBackRadius, this.mBackRadius, paint6);
        }
        Layout switchText = (double)this.progress > 0.5 ? this.mOnLayout : this.mOffLayout;
        RectF rectF = textRectF = (double)this.progress > 0.5 ? this.mTextOnRectF : this.mTextOffRectF;
        if (switchText != null && textRectF != null) {
            alpha = (int)((float)255 * ((double)this.progress >= 0.75 ? this.progress * (float)4 - (float)3 : ((double)this.progress < 0.25 ? 1.0f - this.progress * (float)4 : 0.0f)));
            int textColor = (double)this.progress > 0.5 ? this.mOnTextColor : this.mOffTextColor;
            int colorAlpha = Color.alpha((int)textColor);
            colorAlpha = colorAlpha * alpha / 255;
            switchText.getPaint().setARGB(colorAlpha, Color.red((int)textColor), Color.green((int)textColor), Color.blue((int)textColor));
            canvas.save();
            canvas.translate(textRectF.left, textRectF.top);
            switchText.draw(canvas);
            canvas.restore();
        }
        RectF rectF3 = this.mPresentThumbRectF;
        if (rectF3 == null) {
            Intrinsics.throwNpe();
        }
        RectF rectF4 = this.mThumbRectF;
        if (rectF4 == null) {
            Intrinsics.throwNpe();
        }
        rectF3.set(rectF4);
        RectF rectF5 = this.mPresentThumbRectF;
        if (rectF5 == null) {
            Intrinsics.throwNpe();
        }
        RectF rectF6 = this.mSafeRectF;
        if (rectF6 == null) {
            Intrinsics.throwNpe();
        }
        rectF5.offset(this.progress * rectF6.width(), 0.0f);
        if (this.mIsThumbUseDrawable) {
            Drawable drawable8 = this.mThumbDrawable;
            if (drawable8 == null) {
                Intrinsics.throwNpe();
            }
            RectF rectF7 = this.mPresentThumbRectF;
            if (rectF7 == null) {
                Intrinsics.throwNpe();
            }
            int n = (int)rectF7.left;
            RectF rectF8 = this.mPresentThumbRectF;
            if (rectF8 == null) {
                Intrinsics.throwNpe();
            }
            int n2 = (int)rectF8.top;
            RectF rectF9 = this.mPresentThumbRectF;
            if (rectF9 == null) {
                Intrinsics.throwNpe();
            }
            int n3 = this.ceil(rectF9.right);
            RectF rectF10 = this.mPresentThumbRectF;
            if (rectF10 == null) {
                Intrinsics.throwNpe();
            }
            drawable8.setBounds(n, n2, n3, this.ceil(rectF10.bottom));
            Drawable drawable9 = this.mThumbDrawable;
            if (drawable9 == null) {
                Intrinsics.throwNpe();
            }
            drawable9.draw(canvas);
        } else {
            Paint paint = this.mPaint;
            if (paint == null) {
                Intrinsics.throwNpe();
            }
            paint.setColor(this.mCurrThumbColor);
            RectF rectF11 = this.mPresentThumbRectF;
            if (rectF11 == null) {
                Intrinsics.throwNpe();
            }
            Paint paint7 = this.mPaint;
            if (paint7 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawRoundRect(rectF11, this.mThumbRadius, this.mThumbRadius, paint7);
        }
        if (this.isDrawDebugRect) {
            RectF rectF12;
            Paint paint = this.mRectPaint;
            if (paint == null) {
                Intrinsics.throwNpe();
            }
            paint.setColor(Color.parseColor((String)"#AA0000"));
            RectF rectF13 = this.mBackRectF;
            if (rectF13 == null) {
                Intrinsics.throwNpe();
            }
            Paint paint8 = this.mRectPaint;
            if (paint8 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawRect(rectF13, paint8);
            Paint paint9 = this.mRectPaint;
            if (paint9 == null) {
                Intrinsics.throwNpe();
            }
            paint9.setColor(Color.parseColor((String)"#0000FF"));
            RectF rectF14 = this.mPresentThumbRectF;
            if (rectF14 == null) {
                Intrinsics.throwNpe();
            }
            Paint paint10 = this.mRectPaint;
            if (paint10 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawRect(rectF14, paint10);
            Paint paint11 = this.mRectPaint;
            if (paint11 == null) {
                Intrinsics.throwNpe();
            }
            paint11.setColor(Color.parseColor((String)"#000000"));
            RectF rectF15 = this.mSafeRectF;
            if (rectF15 == null) {
                Intrinsics.throwNpe();
            }
            float f = rectF15.left;
            RectF rectF16 = this.mThumbRectF;
            if (rectF16 == null) {
                Intrinsics.throwNpe();
            }
            float f2 = rectF16.top;
            RectF rectF17 = this.mSafeRectF;
            if (rectF17 == null) {
                Intrinsics.throwNpe();
            }
            float f3 = rectF17.right;
            RectF rectF18 = this.mThumbRectF;
            if (rectF18 == null) {
                Intrinsics.throwNpe();
            }
            float f4 = rectF18.top;
            Paint paint12 = this.mRectPaint;
            if (paint12 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawLine(f, f2, f3, f4, paint12);
            Paint paint13 = this.mRectPaint;
            if (paint13 == null) {
                Intrinsics.throwNpe();
            }
            paint13.setColor(Color.parseColor((String)"#00CC00"));
            if ((double)this.progress > 0.5) {
                rectF12 = this.mTextOnRectF;
                if (rectF12 == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                rectF12 = this.mTextOffRectF;
                if (rectF12 == null) {
                    Intrinsics.throwNpe();
                }
            }
            Paint paint14 = this.mRectPaint;
            if (paint14 == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawRect(rectF12, paint14);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (!this.mIsThumbUseDrawable && this.mThumbColor != null) {
            ColorStateList colorStateList = this.mThumbColor;
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            this.mCurrThumbColor = colorStateList.getColorForState(this.getDrawableState(), this.mCurrThumbColor);
        } else {
            this.setDrawableState(this.mThumbDrawable);
        }
        int[] nextState = this.isChecked() ? UNCHECKED_PRESSED_STATE : CHECKED_PRESSED_STATE;
        ColorStateList textColors = this.getTextColors();
        if (textColors != null) {
            int defaultTextColor = textColors.getDefaultColor();
            this.mOnTextColor = textColors.getColorForState(CHECKED_PRESSED_STATE, defaultTextColor);
            this.mOffTextColor = textColors.getColorForState(UNCHECKED_PRESSED_STATE, defaultTextColor);
        }
        if (!this.mIsBackUseDrawable && this.mBackColor != null) {
            ColorStateList colorStateList = this.mBackColor;
            if (colorStateList == null) {
                Intrinsics.throwNpe();
            }
            this.mCurrBackColor = colorStateList.getColorForState(this.getDrawableState(), this.mCurrBackColor);
            ColorStateList colorStateList2 = this.mBackColor;
            if (colorStateList2 == null) {
                Intrinsics.throwNpe();
            }
            this.mNextBackColor = colorStateList2.getColorForState(nextState, this.mCurrBackColor);
        } else {
            if (this.mBackDrawable instanceof StateListDrawable && this.isFadeBack) {
                Drawable drawable2 = this.mBackDrawable;
                if (drawable2 == null) {
                    Intrinsics.throwNpe();
                }
                drawable2.setState(nextState);
                Drawable drawable3 = this.mBackDrawable;
                if (drawable3 == null) {
                    Intrinsics.throwNpe();
                }
                this.mNextBackDrawable = drawable3.getCurrent().mutate();
            } else {
                this.mNextBackDrawable = null;
            }
            this.setDrawableState(this.mBackDrawable);
            if (this.mBackDrawable != null) {
                Drawable drawable4 = this.mBackDrawable;
                if (drawable4 == null) {
                    Intrinsics.throwNpe();
                }
                this.mCurrentBackDrawable = drawable4.getCurrent().mutate();
            }
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!(this.isEnabled() && this.isClickable() && this.isFocusable() && this.mReady)) {
            return false;
        }
        int action = event.getAction();
        float deltaX = event.getX() - this.mStartX;
        float deltaY = event.getY() - this.mStartY;
        switch (action) {
            case 0: {
                this.mStartX = event.getX();
                this.mStartY = event.getY();
                this.mLastX = this.mStartX;
                this.setPressed(true);
                break;
            }
            case 2: {
                float x = event.getX();
                RectF rectF = this.mSafeRectF;
                if (rectF == null) {
                    Intrinsics.throwNpe();
                }
                this.setProgress(this.progress + (x - this.mLastX) / rectF.width());
                if (!this.mCatch && (Math.abs(deltaX) > (float)(this.mTouchSlop / 2) || Math.abs(deltaY) > (float)(this.mTouchSlop / 2))) {
                    if (deltaY == 0.0f || Math.abs(deltaX) > Math.abs(deltaY)) {
                        this.catchView();
                    } else if (Math.abs(deltaY) > Math.abs(deltaX)) {
                        return false;
                    }
                }
                this.mLastX = x;
                break;
            }
            case 1: 
            case 3: {
                this.mCatch = false;
                this.setPressed(false);
                float time = event.getEventTime() - event.getDownTime();
                if (Math.abs(deltaX) < (float)this.mTouchSlop && Math.abs(deltaY) < (float)this.mTouchSlop && time < (float)this.mClickTimeout) {
                    this.performClick();
                    break;
                }
                boolean nextStatus = this.getStatusBasedOnPos();
                if (nextStatus != this.isChecked()) {
                    this.playSoundEffect(0);
                    this.setChecked(nextStatus);
                    break;
                }
                this.animateToState(nextStatus);
            }
        }
        return true;
    }

    public boolean performClick() {
        return super.performClick();
    }

    protected final void animateToState(boolean checked) {
        if (this.mProgressAnimator == null) {
            return;
        }
        ObjectAnimator objectAnimator = this.mProgressAnimator;
        if (objectAnimator == null) {
            Intrinsics.throwNpe();
        }
        if (objectAnimator.isRunning()) {
            ObjectAnimator objectAnimator2 = this.mProgressAnimator;
            if (objectAnimator2 == null) {
                Intrinsics.throwNpe();
            }
            objectAnimator2.cancel();
        }
        ObjectAnimator objectAnimator3 = this.mProgressAnimator;
        if (objectAnimator3 == null) {
            Intrinsics.throwNpe();
        }
        objectAnimator3.setDuration(this.animationDuration);
        if (checked) {
            ObjectAnimator objectAnimator4 = this.mProgressAnimator;
            if (objectAnimator4 == null) {
                Intrinsics.throwNpe();
            }
            objectAnimator4.setFloatValues(new float[]{this.progress, 1.0f});
        } else {
            ObjectAnimator objectAnimator5 = this.mProgressAnimator;
            if (objectAnimator5 == null) {
                Intrinsics.throwNpe();
            }
            objectAnimator5.setFloatValues(new float[]{this.progress, 0.0f});
        }
        ObjectAnimator objectAnimator6 = this.mProgressAnimator;
        if (objectAnimator6 == null) {
            Intrinsics.throwNpe();
        }
        objectAnimator6.start();
    }

    private final void catchView() {
        ViewParent parent;
        ViewParent viewParent = parent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
        this.mCatch = true;
    }

    public void setChecked(boolean checked) {
        if (this.isChecked() != checked) {
            this.animateToState(checked);
        }
        if (this.mRestoring) {
            this.setCheckedImmediatelyNoEvent(checked);
        } else {
            super.setChecked(checked);
        }
    }

    public final void setCheckedNoEvent(boolean checked) {
        if (this.mChildOnCheckedChangeListener == null) {
            this.setChecked(checked);
        } else {
            super.setOnCheckedChangeListener(null);
            this.setChecked(checked);
            super.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
        }
    }

    public final void setCheckedImmediatelyNoEvent(boolean checked) {
        if (this.mChildOnCheckedChangeListener == null) {
            this.setCheckedImmediately(checked);
        } else {
            super.setOnCheckedChangeListener(null);
            this.setCheckedImmediately(checked);
            super.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
        }
    }

    public final void toggleNoEvent() {
        if (this.mChildOnCheckedChangeListener == null) {
            this.toggle();
        } else {
            super.setOnCheckedChangeListener(null);
            this.toggle();
            super.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
        }
    }

    public final void toggleImmediatelyNoEvent() {
        if (this.mChildOnCheckedChangeListener == null) {
            this.toggleImmediately();
        } else {
            super.setOnCheckedChangeListener(null);
            this.toggleImmediately();
            super.setOnCheckedChangeListener(this.mChildOnCheckedChangeListener);
        }
    }

    public void setOnCheckedChangeListener(@Nullable CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        super.setOnCheckedChangeListener(onCheckedChangeListener);
        this.mChildOnCheckedChangeListener = onCheckedChangeListener;
    }

    public final void setCheckedImmediately(boolean checked) {
        super.setChecked(checked);
        if (this.mProgressAnimator != null) {
            ObjectAnimator objectAnimator = this.mProgressAnimator;
            if (objectAnimator == null) {
                Intrinsics.throwNpe();
            }
            if (objectAnimator.isRunning()) {
                ObjectAnimator objectAnimator2 = this.mProgressAnimator;
                if (objectAnimator2 == null) {
                    Intrinsics.throwNpe();
                }
                objectAnimator2.cancel();
            }
        }
        this.setProgress(checked ? 1.0f : 0.0f);
        this.invalidate();
    }

    public final void toggleImmediately() {
        this.setCheckedImmediately(!this.isChecked());
    }

    private final void setDrawableState(Drawable drawable2) {
        if (drawable2 != null) {
            int[] myDrawableState = this.getDrawableState();
            drawable2.setState(myDrawableState);
            this.invalidate();
        }
    }

    public final void setThumbDrawableRes(int thumbDrawableRes) {
        this.setThumbDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)thumbDrawableRes));
    }

    public final void setBackDrawableRes(int backDrawableRes) {
        this.setBackDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)backDrawableRes));
    }

    public final void setBackColorRes(int backColorRes) {
        this.setBackColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)backColorRes));
    }

    public final void setThumbColorRes(int thumbColorRes) {
        this.setThumbColor(ContextCompat.getColorStateList((Context)this.getContext(), (int)thumbColorRes));
    }

    public final void setThumbMargin(float left, float top, float right, float bottom) {
        RectF rectF = this.mThumbMargin;
        if (rectF == null) {
            Intrinsics.throwNpe();
        }
        rectF.set(left, top, right, bottom);
        this.mReady = false;
        this.requestLayout();
    }

    public final void setThumbSize(int width, int height) {
        this.mThumbWidth = width;
        this.mThumbHeight = height;
        this.mReady = false;
        this.requestLayout();
    }

    public final void setText(@Nullable CharSequence onText, @Nullable CharSequence offText) {
        this.textOn = onText;
        this.textOff = offText;
        this.mOnLayout = null;
        this.mOffLayout = null;
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    public final void setTextThumbInset(int textThumbInset) {
        this.mTextThumbInset = textThumbInset;
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    public final void setTextExtra(int textExtra) {
        this.mTextExtra = textExtra;
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    public final void setTextAdjust(int textAdjust) {
        this.mTextAdjust = textAdjust;
        this.mReady = false;
        this.requestLayout();
        this.invalidate();
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.setOnText(this.textOn);
        ss.setOffText(this.textOff);
        return (Parcelable)ss;
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        SavedState ss = (SavedState)state;
        this.setText(ss.getOnText(), ss.getOffText());
        this.mRestoring = true;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mRestoring = false;
    }

    public SwitchButton(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    public SwitchButton(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.init(attrs);
    }

    public SwitchButton(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.init(null);
    }

    static {
        Companion = new Companion(null);
        CHECKED_PRESSED_STATE = new int[]{0x10100A0, 16842910, 16842919};
        UNCHECKED_PRESSED_STATE = new int[]{-16842912, 16842910, 16842919};
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006\u0017"}, d2={"Lme/shouheng/uix/widget/button/SwitchButton$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "(Landroid/os/Parcelable;)V", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "offText", "", "getOffText", "()Ljava/lang/CharSequence;", "setOffText", "(Ljava/lang/CharSequence;)V", "onText", "getOnText", "setOnText", "writeToParcel", "", "out", "flags", "", "Companion", "uix-widget_release"})
    public static final class SavedState
    extends View.BaseSavedState {
        @Nullable
        private CharSequence onText;
        @Nullable
        private CharSequence offText;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        @Nullable
        public final CharSequence getOnText() {
            return this.onText;
        }

        public final void setOnText(@Nullable CharSequence charSequence) {
            this.onText = charSequence;
        }

        @Nullable
        public final CharSequence getOffText() {
            return this.offText;
        }

        public final void setOffText(@Nullable CharSequence charSequence) {
            this.offText = charSequence;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            TextUtils.writeToParcel((CharSequence)this.onText, (Parcel)out, (int)flags);
            TextUtils.writeToParcel((CharSequence)this.offText, (Parcel)out, (int)flags);
        }

        public SavedState(@Nullable Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.onText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.offText = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @NotNull
                public SavedState createFromParcel(@NotNull Parcel ins) {
                    Intrinsics.checkParameterIsNotNull((Object)ins, (String)"ins");
                    return new SavedState(ins, null);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        public /* synthetic */ SavedState(Parcel in, DefaultConstructorMarker $constructor_marker) {
            this(in);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/shouheng/uix/widget/button/SwitchButton$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lme/shouheng/uix/widget/button/SwitchButton$SavedState;", "uix-widget_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/shouheng/uix/widget/button/SwitchButton$Companion;", "", "()V", "CHECKED_PRESSED_STATE", "", "DEFAULT_ANIMATION_DURATION", "", "DEFAULT_THUMB_MARGIN_DP", "DEFAULT_THUMB_RANGE_RATIO", "", "DEFAULT_THUMB_SIZE_DP", "DEFAULT_TINT_COLOR", "UNCHECKED_PRESSED_STATE", "uix-widget_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

