/*
 * Decompiled with CFR 0.152.
 */
package me.shib.java.lib.telegram.bot.easybot;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import me.shib.java.lib.telegram.bot.service.TelegramBot;
import me.shib.java.lib.telegram.bot.types.Update;

public class UpdateReceiver {
    private static Map<String, UpdateReceiver> updateReceiverMap;
    private Queue<Update> updatesQueue = new LinkedList<Update>();
    private TelegramBot bot;
    private boolean botStarted;

    private UpdateReceiver(String botAPItoken) {
        this.bot = TelegramBot.getInstance((String)botAPItoken);
        this.botStarted = false;
    }

    protected static synchronized UpdateReceiver getDefaultInstance(String botAPItoken) {
        UpdateReceiver updateReceiver;
        if (updateReceiverMap == null) {
            updateReceiverMap = new HashMap<String, UpdateReceiver>();
        }
        if ((updateReceiver = updateReceiverMap.get(botAPItoken)) == null) {
            updateReceiver = new UpdateReceiver(botAPItoken);
            updateReceiverMap.put(botAPItoken, updateReceiver);
        }
        return updateReceiver;
    }

    private synchronized void fillUpdatesQueue() {
        try {
            Update[] updates = this.bot.getUpdates();
            Collections.addAll(this.updatesQueue, updates);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected synchronized Update getUpdate() {
        Update update = this.updatesQueue.poll();
        while (update == null) {
            this.fillUpdatesQueue();
            update = this.updatesQueue.poll();
        }
        return update;
    }

    protected synchronized void onBotStart() {
        if (!this.botStarted) {
            System.out.println("Starting services for: " + this.bot.getIdentity().getFirst_name() + " (" + this.bot.getIdentity().getUsername() + ")");
            this.botStarted = true;
        }
    }
}

