/*
 * Decompiled with CFR 0.152.
 */
package me.shib.java.lib.telegram.bot.easybot;

import me.shib.java.lib.telegram.bot.easybot.BotConfig;
import me.shib.java.lib.telegram.bot.easybot.DefaultBotModel;
import me.shib.java.lib.telegram.bot.easybot.TBotSweeper;
import me.shib.java.lib.telegram.bot.easybot.UpdateReceiver;
import me.shib.java.lib.telegram.bot.service.TelegramBot;
import me.shib.java.lib.telegram.bot.types.Message;
import me.shib.java.lib.telegram.bot.types.Update;

public class TBotWorker
extends Thread {
    private static int threadCounter = 0;
    private BotConfig config;
    private TelegramBot bot;
    private UpdateReceiver updateReceiver;
    private DefaultBotModel defaultModel;
    private boolean enabled;
    private int threadNumber;

    public TBotWorker(BotConfig config) {
        this.config = config;
        if (config != null && config.getBotApiToken() != null && !config.getBotApiToken().isEmpty()) {
            this.bot = TelegramBot.getInstance((String)config.getBotApiToken());
            this.updateReceiver = UpdateReceiver.getDefaultInstance(this.config.getBotApiToken());
            this.defaultModel = new DefaultBotModel(config);
            this.enabled = true;
        }
        this.threadNumber = 0;
    }

    private static synchronized int getThisThreadNumber(TBotWorker worker) {
        if (worker.threadNumber == 0) {
            worker.threadNumber = ++threadCounter;
        }
        return worker.threadNumber;
    }

    public void startBotWork() {
        if (this.defaultModel != null) {
            TBotSweeper.startDefaultInstance(this.defaultModel);
            this.updateReceiver.onBotStart();
            System.out.println("Starting thread " + TBotWorker.getThisThreadNumber(this) + " with " + this.bot.getIdentity().getUsername() + " using the model: " + this.defaultModel.getModelClassName());
            while (this.enabled) {
                try {
                    Update update = this.updateReceiver.getUpdate();
                    if (update.getMessage() != null) {
                        Message message = update.getMessage();
                        boolean adminIdValid = this.config.isAdmin(message.getChat().getId()) || this.config.isAdmin(message.getFrom().getId());
                        Message commandResponseMessage = null;
                        if (this.config.isValidCommand(message.getText())) {
                            commandResponseMessage = this.defaultModel.onCommand(message);
                        }
                        Message adminResponseMessage = null;
                        if (commandResponseMessage == null && adminIdValid && !this.config.isUserMode(message.getFrom().getId())) {
                            adminResponseMessage = this.defaultModel.onMessageFromAdmin(message);
                        }
                        if (adminResponseMessage != null || commandResponseMessage != null) continue;
                        this.defaultModel.onReceivingMessage(message);
                        continue;
                    }
                    if (update.getInline_query() != null) {
                        this.defaultModel.onInlineQuery(update.getInline_query());
                        continue;
                    }
                    if (update.getChosen_inline_result() == null) continue;
                    this.defaultModel.onChosenInlineResult(update.getChosen_inline_result());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void stopWorker() {
        this.enabled = false;
    }

    @Override
    public void run() {
        this.startBotWork();
    }
}

