/*
 * Decompiled with CFR 0.152.
 */
package me.shib.java.lib.telegram.bot.easybot;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import javax.imageio.ImageIO;
import me.shib.java.lib.telegram.bot.easybot.BotConfig;
import me.shib.java.lib.telegram.bot.easybot.BotModel;
import me.shib.java.lib.telegram.bot.service.TelegramBot;
import me.shib.java.lib.telegram.bot.types.ChatId;
import me.shib.java.lib.telegram.bot.types.ChosenInlineResult;
import me.shib.java.lib.telegram.bot.types.InlineQuery;
import me.shib.java.lib.telegram.bot.types.Message;
import me.shib.java.lib.telegram.bot.types.ParseMode;
import me.shib.java.lib.telegram.bot.types.TelegramFile;

public class DefaultBotModel
extends BotModel {
    private static final Date startTime = new Date();
    private BotConfig config;
    private BotModel appModel;
    private TelegramBot bot;

    protected DefaultBotModel(BotConfig config) {
        super(config);
        this.config = config;
        try {
            Class<?> clazz = Class.forName(config.getBotModelClassName());
            Constructor<?> ctor = clazz.getConstructor(BotConfig.class);
            this.appModel = (BotModel)ctor.newInstance(config);
        }
        catch (Exception e) {
            this.appModel = null;
        }
        this.bot = this.getBot();
    }

    private static String getUpTime() {
        long start = startTime.getTime();
        long current = new Date().getTime();
        long timeDiff = current - start;
        int seconds = (int)((timeDiff /= 1000L) % 60L);
        int mins = (int)((timeDiff /= 60L) % 60L);
        int hours = (int)((timeDiff /= 60L) % 24L);
        return (timeDiff /= 24L) + "d " + hours + "h " + mins + "m " + seconds + "s ";
    }

    private static String getHostInfo() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            String hostname = ip.getHostName();
            return hostname + "(" + ip.getHostAddress() + ")";
        }
        catch (UnknownHostException e) {
            return "Unknown Host";
        }
    }

    protected String getModelClassName() {
        if (this.appModel != null) {
            return this.appModel.getClass().getSimpleName();
        }
        return this.getClass().getSimpleName();
    }

    protected BotConfig getConfig() {
        return this.config;
    }

    @Override
    public Message onReceivingMessage(Message message) {
        Message appModelResponseMessage = null;
        if (this.appModel != null) {
            appModelResponseMessage = this.appModel.onReceivingMessage(message);
        }
        if (appModelResponseMessage != null) {
            return appModelResponseMessage;
        }
        try {
            long[] admins = this.config.getAdminIdList();
            if (admins != null && admins.length > 0) {
                for (long admin : admins) {
                    try {
                        this.bot.forwardMessage(new ChatId(admin), new ChatId(message.getFrom().getId()), message.getMessage_id());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return this.bot.sendMessage(new ChatId(message.getChat().getId()), "Your message has been forwarded to the *admin*. It might take quite sometime to get back to you. Please be patient.", ParseMode.Markdown, false, message.getMessage_id());
            }
            return this.bot.sendMessage(new ChatId(message.getChat().getId()), "The support team is unavailable. Please try later.", null, false, message.getMessage_id());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Message onMessageFromAdmin(Message message) {
        Message appModelResponseMessage = null;
        if (this.appModel != null) {
            appModelResponseMessage = this.appModel.onMessageFromAdmin(message);
        }
        if (appModelResponseMessage != null) {
            return appModelResponseMessage;
        }
        try {
            long replyToUser = message.getReply_to_message().getForward_from().getId();
            if (replyToUser > 0L) {
                if (message.getText() != null) {
                    return this.bot.sendMessage(new ChatId(replyToUser), message.getText());
                }
                if (message.getDocument() != null) {
                    return this.bot.sendDocument(new ChatId(replyToUser), new TelegramFile(message.getDocument().getFile_id()));
                }
                if (message.getVideo() != null) {
                    return this.bot.sendVideo(new ChatId(replyToUser), new TelegramFile(message.getVideo().getFile_id()));
                }
                if (message.getPhoto() != null) {
                    return this.bot.sendPhoto(new ChatId(replyToUser), new TelegramFile(message.getPhoto()[message.getPhoto().length - 1].getFile_id()));
                }
                if (message.getAudio() != null) {
                    return this.bot.sendDocument(new ChatId(replyToUser), new TelegramFile(message.getDocument().getFile_id()));
                }
                if (message.getVoice() != null) {
                    return this.bot.sendDocument(new ChatId(replyToUser), new TelegramFile(message.getDocument().getFile_id()));
                }
                if (message.getSticker() != null) {
                    return this.bot.sendDocument(new ChatId(replyToUser), new TelegramFile(message.getDocument().getFile_id()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private File getCurrentScreenShotFile() {
        try {
            File screenShotFile = new File("screenshots" + File.separator + new Date().getTime() + ".png");
            File parentDir = screenShotFile.getParentFile();
            if (!parentDir.exists() || !parentDir.isDirectory()) {
                parentDir.mkdirs();
            }
            if (parentDir.exists() && parentDir.isDirectory()) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle screenRectangle = new Rectangle(screenSize);
                Robot robot = new Robot();
                BufferedImage image = robot.createScreenCapture(screenRectangle);
                ImageIO.write((RenderedImage)image, "png", screenShotFile);
            }
            return screenShotFile;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Message onStartAndHelp(Message message) throws IOException {
        this.bot.sendChatAction(new ChatId(message.getChat().getId()), TelegramBot.ChatAction.typing);
        return this.bot.sendMessage(new ChatId(message.getChat().getId()), "Hi " + message.getFrom().getFirst_name() + ". My name is *" + this.bot.getIdentity().getFirst_name() + "* (@" + this.bot.getIdentity().getUsername() + "). I'll try to serve you the best" + " with all my efforts. Welcome!", ParseMode.Markdown);
    }

    @Override
    public Message onCommand(Message message) {
        Message appModelResponseMessage = null;
        if (this.appModel != null) {
            appModelResponseMessage = this.appModel.onCommand(message);
        }
        if (appModelResponseMessage != null) {
            return appModelResponseMessage;
        }
        switch (message.getText()) {
            case "/start": {
                if (!this.config.isValidCommand("/start")) break;
                try {
                    return this.onStartAndHelp(message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case "/help": {
                if (!this.config.isValidCommand("/help")) break;
                try {
                    return this.onStartAndHelp(message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case "/scr": {
                if (!this.config.isValidCommand("/scr") || !this.config.isAdmin(message.getChat().getId())) break;
                try {
                    this.bot.sendChatAction(new ChatId(message.getChat().getId()), TelegramBot.ChatAction.upload_document);
                    File screenShotFile = this.getCurrentScreenShotFile();
                    if (screenShotFile != null) {
                        Message returnMessage = this.bot.sendDocument(new ChatId(message.getChat().getId()), new TelegramFile(screenShotFile));
                        screenShotFile.delete();
                        return returnMessage;
                    }
                    return this.bot.sendMessage(new ChatId(message.getChat().getId()), "I couldn't take a screenshot right now. I'm sorry.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case "/status": {
                if (!this.config.isValidCommand("/status") || !this.config.isAdmin(message.getChat().getId())) break;
                try {
                    this.bot.sendChatAction(new ChatId(message.getChat().getId()), TelegramBot.ChatAction.typing);
                    return this.sendStatusMessage(message.getChat().getId());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case "/usermode": {
                if (!this.config.isValidCommand("/usermode") || !this.config.isAdmin(message.getChat().getId())) break;
                this.config.setUserMode(message.getFrom().getId());
                try {
                    return this.bot.sendMessage(new ChatId(message.getChat().getId()), "Switched to *User Mode*", ParseMode.Markdown);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
            case "/adminmode": {
                if (!this.config.isValidCommand("/adminmode") || !this.config.isAdmin(message.getChat().getId())) break;
                this.config.setAdminMode(message.getFrom().getId());
                try {
                    return this.bot.sendMessage(new ChatId(message.getChat().getId()), "Switched to *Admin Mode*", ParseMode.Markdown);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public boolean onInlineQuery(InlineQuery query) {
        boolean appModelResponse = false;
        if (this.appModel != null) {
            appModelResponse = this.appModel.onInlineQuery(query);
        }
        return appModelResponse;
    }

    @Override
    public boolean onChosenInlineResult(ChosenInlineResult chosenInlineResult) {
        boolean appModelResponse = false;
        if (this.appModel != null) {
            appModelResponse = this.appModel.onChosenInlineResult(chosenInlineResult);
        }
        return appModelResponse;
    }

    @Override
    public Message sendStatusMessage(long chatId) {
        Message appModelResponseMessage = null;
        if (this.appModel != null) {
            appModelResponseMessage = this.appModel.sendStatusMessage(chatId);
        }
        if (appModelResponseMessage != null) {
            return appModelResponseMessage;
        }
        try {
            return this.bot.sendMessage(new ChatId(chatId), "Reporting status:\nHost: " + DefaultBotModel.getHostInfo() + "\nUp Time: " + DefaultBotModel.getUpTime());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

