/*
 * Decompiled with CFR 0.152.
 */
package me.saket.telephoto.subsamplingimage.internal;

import android.content.Context;
import androidx.exifinterface.media.ExifInterface;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import me.saket.telephoto.subsamplingimage.AssetImageSource;
import me.saket.telephoto.subsamplingimage.FileImageSource;
import me.saket.telephoto.subsamplingimage.RawImageSource;
import me.saket.telephoto.subsamplingimage.ResourceImageSource;
import me.saket.telephoto.subsamplingimage.SubSamplingImageSource;
import me.saket.telephoto.subsamplingimage.UriImageSource;
import me.saket.telephoto.subsamplingimage.internal.ExifInterfaceCompatibleInputStream;
import okio.FileSystem;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lme/saket/telephoto/subsamplingimage/internal/ExifMetadata;", "", "orientation", "Lme/saket/telephoto/subsamplingimage/internal/ExifMetadata$ImageOrientation;", "(Lme/saket/telephoto/subsamplingimage/internal/ExifMetadata$ImageOrientation;)V", "getOrientation", "()Lme/saket/telephoto/subsamplingimage/internal/ExifMetadata$ImageOrientation;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "ImageOrientation", "sub-sampling-image_release"})
public final class ExifMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageOrientation orientation;

    public ExifMetadata(@NotNull ImageOrientation orientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.orientation = orientation;
    }

    @NotNull
    public final ImageOrientation getOrientation() {
        return this.orientation;
    }

    @NotNull
    public final ImageOrientation component1() {
        return this.orientation;
    }

    @NotNull
    public final ExifMetadata copy(@NotNull ImageOrientation orientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        return new ExifMetadata(orientation);
    }

    public static /* synthetic */ ExifMetadata copy$default(ExifMetadata exifMetadata, ImageOrientation imageOrientation, int n, Object object) {
        if ((n & 1) != 0) {
            imageOrientation = exifMetadata.orientation;
        }
        return exifMetadata.copy(imageOrientation);
    }

    @NotNull
    public String toString() {
        return "ExifMetadata(orientation=" + this.orientation + ")";
    }

    public int hashCode() {
        return this.orientation.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExifMetadata)) {
            return false;
        }
        ExifMetadata exifMetadata = (ExifMetadata)other;
        return this.orientation == exifMetadata.orientation;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lme/saket/telephoto/subsamplingimage/internal/ExifMetadata$Companion;", "", "()V", "read", "Lme/saket/telephoto/subsamplingimage/internal/ExifMetadata;", "context", "Landroid/content/Context;", "source", "Lme/saket/telephoto/subsamplingimage/SubSamplingImageSource;", "(Landroid/content/Context;Lme/saket/telephoto/subsamplingimage/SubSamplingImageSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sub-sampling-image_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object read(@NotNull Context context, @NotNull SubSamplingImageSource source, @NotNull Continuation<? super ExifMetadata> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ExifMetadata>, Object>(source, context, null){
                int label;
                final /* synthetic */ SubSamplingImageSource $source;
                final /* synthetic */ Context $context;
                {
                    this.$source = $source;
                    this.$context = $context;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ImageOrientation imageOrientation;
                            InputStream inputStream;
                            ResultKt.throwOnFailure((Object)object);
                            SubSamplingImageSource subSamplingImageSource = this.$source;
                            if (subSamplingImageSource instanceof FileImageSource) {
                                inputStream = Okio.buffer((Source)FileSystem.SYSTEM.source(((FileImageSource)this.$source).getPath())).inputStream();
                            } else if (subSamplingImageSource instanceof RawImageSource) {
                                inputStream = ((RawImageSource)this.$source).peek().inputStream();
                            } else if (subSamplingImageSource instanceof AssetImageSource) {
                                inputStream = ((AssetImageSource)this.$source).peek(this.$context);
                            } else if (subSamplingImageSource instanceof ResourceImageSource) {
                                inputStream = ((ResourceImageSource)this.$source).peek(this.$context);
                            } else if (subSamplingImageSource instanceof UriImageSource) {
                                inputStream = ((UriImageSource)this.$source).peek(this.$context);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            InputStream inputStream2 = inputStream;
                            ExifInterface exif = new ExifInterface((InputStream)new ExifInterfaceCompatibleInputStream(inputStream2));
                            switch (exif.getRotationDegrees()) {
                                case 0: {
                                    imageOrientation = ImageOrientation.None;
                                    break;
                                }
                                case 90: {
                                    imageOrientation = ImageOrientation.Orientation90;
                                    break;
                                }
                                case 180: {
                                    imageOrientation = ImageOrientation.Orientation180;
                                    break;
                                }
                                case 270: {
                                    imageOrientation = ImageOrientation.Orientation270;
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException(("Invalid image orientation at " + exif.getRotationDegrees() + "\u00b0").toString());
                                }
                            }
                            return new ExifMetadata(imageOrientation);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ExifMetadata> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lme/saket/telephoto/subsamplingimage/internal/ExifMetadata$ImageOrientation;", "", "degrees", "", "(Ljava/lang/String;II)V", "getDegrees", "()I", "None", "Orientation90", "Orientation180", "Orientation270", "sub-sampling-image_release"})
    public static final class ImageOrientation
    extends Enum<ImageOrientation> {
        private final int degrees;
        public static final /* enum */ ImageOrientation None = new ImageOrientation(0);
        public static final /* enum */ ImageOrientation Orientation90 = new ImageOrientation(90);
        public static final /* enum */ ImageOrientation Orientation180 = new ImageOrientation(180);
        public static final /* enum */ ImageOrientation Orientation270 = new ImageOrientation(270);
        private static final /* synthetic */ ImageOrientation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ImageOrientation(int degrees) {
            this.degrees = degrees;
        }

        public final int getDegrees() {
            return this.degrees;
        }

        public static ImageOrientation[] values() {
            return (ImageOrientation[])$VALUES.clone();
        }

        public static ImageOrientation valueOf(String value) {
            return Enum.valueOf(ImageOrientation.class, value);
        }

        @NotNull
        public static EnumEntries<ImageOrientation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = imageOrientationArray = new ImageOrientation[]{ImageOrientation.None, ImageOrientation.Orientation90, ImageOrientation.Orientation180, ImageOrientation.Orientation270};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

