/*
 * Decompiled with CFR 0.152.
 */
package me.saket.telephoto.subsamplingimage;

import android.content.Context;
import android.graphics.BitmapRegionDecoder;
import android.net.Uri;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.ImageBitmap;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import me.saket.telephoto.subsamplingimage.SubSamplingImageSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lme/saket/telephoto/subsamplingimage/UriImageSource;", "Lme/saket/telephoto/subsamplingimage/SubSamplingImageSource;", "uri", "Landroid/net/Uri;", "preview", "Landroidx/compose/ui/graphics/ImageBitmap;", "(Landroid/net/Uri;Landroidx/compose/ui/graphics/ImageBitmap;)V", "getPreview", "()Landroidx/compose/ui/graphics/ImageBitmap;", "component1", "component2", "copy", "decoder", "Landroid/graphics/BitmapRegionDecoder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "peek", "Ljava/io/InputStream;", "toString", "", "sub-sampling-image_release"})
@Immutable
public final class UriImageSource
implements SubSamplingImageSource {
    @NotNull
    private final Uri uri;
    @Nullable
    private final ImageBitmap preview;

    public UriImageSource(@NotNull Uri uri, @Nullable ImageBitmap preview) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.uri = uri;
        this.preview = preview;
    }

    @Override
    @Nullable
    public ImageBitmap getPreview() {
        return this.preview;
    }

    @NotNull
    public final InputStream peek(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = context.getContentResolver().openInputStream(this.uri);
        if (inputStream == null) {
            throw new IllegalStateException(("Failed to read uri: " + this.uri).toString());
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object decoder(@NotNull Context context, @NotNull Continuation<? super BitmapRegionDecoder> $completion) {
        BitmapRegionDecoder bitmapRegionDecoder;
        Closeable closeable = this.peek(context);
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            BitmapRegionDecoder bitmapRegionDecoder2 = BitmapRegionDecoder.newInstance((InputStream)stream, (boolean)false);
            Intrinsics.checkNotNull((Object)bitmapRegionDecoder2);
            BitmapRegionDecoder bitmapRegionDecoder3 = bitmapRegionDecoder2;
            bitmapRegionDecoder = bitmapRegionDecoder3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmapRegionDecoder, (String)"use(...)");
        return bitmapRegionDecoder;
    }

    private final Uri component1() {
        return this.uri;
    }

    @Nullable
    public final ImageBitmap component2() {
        return this.preview;
    }

    @NotNull
    public final UriImageSource copy(@NotNull Uri uri, @Nullable ImageBitmap preview) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new UriImageSource(uri, preview);
    }

    public static /* synthetic */ UriImageSource copy$default(UriImageSource uriImageSource, Uri uri, ImageBitmap imageBitmap, int n, Object object) {
        if ((n & 1) != 0) {
            uri = uriImageSource.uri;
        }
        if ((n & 2) != 0) {
            imageBitmap = uriImageSource.preview;
        }
        return uriImageSource.copy(uri, imageBitmap);
    }

    @NotNull
    public String toString() {
        return "UriImageSource(uri=" + this.uri + ", preview=" + this.preview + ")";
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = result * 31 + (this.preview == null ? 0 : this.preview.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UriImageSource)) {
            return false;
        }
        UriImageSource uriImageSource = (UriImageSource)other;
        if (!Intrinsics.areEqual((Object)this.uri, (Object)uriImageSource.uri)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.preview, (Object)uriImageSource.preview);
    }
}

