/*
 * Decompiled with CFR 0.152.
 */
package me.saket.telephoto.subsamplingimage;

import android.content.Context;
import android.graphics.BitmapRegionDecoder;
import androidx.compose.runtime.Immutable;
import androidx.compose.ui.graphics.ImageBitmap;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.saket.telephoto.subsamplingimage.SubSamplingImageSource;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0011\u0010\u0013\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u00c2\u0003J7\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u00c6\u0001J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lme/saket/telephoto/subsamplingimage/RawImageSource;", "Lme/saket/telephoto/subsamplingimage/SubSamplingImageSource;", "source", "Lkotlin/Function0;", "Lokio/Source;", "preview", "Landroidx/compose/ui/graphics/ImageBitmap;", "onClose", "Ljava/io/Closeable;", "Lokio/Closeable;", "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/graphics/ImageBitmap;Ljava/io/Closeable;)V", "getPreview", "()Landroidx/compose/ui/graphics/ImageBitmap;", "getSource", "()Lkotlin/jvm/functions/Function0;", "close", "", "component1", "component2", "component3", "copy", "decoder", "Landroid/graphics/BitmapRegionDecoder;", "context", "Landroid/content/Context;", "(Landroid/content/Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "equals", "", "other", "", "hashCode", "", "peek", "Lokio/BufferedSource;", "toString", "", "sub-sampling-image_release"})
@Immutable
public final class RawImageSource
implements SubSamplingImageSource {
    @NotNull
    private final Function0<Source> source;
    @Nullable
    private final ImageBitmap preview;
    @Nullable
    private final Closeable onClose;

    public RawImageSource(@NotNull Function0<? extends Source> source, @Nullable ImageBitmap preview, @Nullable Closeable onClose) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.source = source;
        this.preview = preview;
        this.onClose = onClose;
    }

    public /* synthetic */ RawImageSource(Function0 function0, ImageBitmap imageBitmap, Closeable closeable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            imageBitmap = null;
        }
        this((Function0<? extends Source>)function0, imageBitmap, closeable);
    }

    @NotNull
    public final Function0<Source> getSource() {
        return this.source;
    }

    @Override
    @Nullable
    public ImageBitmap getPreview() {
        return this.preview;
    }

    @NotNull
    public final BufferedSource peek() {
        return Okio.buffer((Source)((Source)this.source.invoke())).peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object decoder(@NotNull Context context, @NotNull Continuation<? super BitmapRegionDecoder> $completion) {
        BitmapRegionDecoder bitmapRegionDecoder;
        Closeable closeable = Okio.buffer((Source)((Source)this.source.invoke())).inputStream();
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            BitmapRegionDecoder bitmapRegionDecoder2 = BitmapRegionDecoder.newInstance((InputStream)stream, (boolean)false);
            Intrinsics.checkNotNull((Object)bitmapRegionDecoder2);
            BitmapRegionDecoder bitmapRegionDecoder3 = bitmapRegionDecoder2;
            bitmapRegionDecoder = bitmapRegionDecoder3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmapRegionDecoder, (String)"use(...)");
        return bitmapRegionDecoder;
    }

    @Override
    public void close() {
        block0: {
            Closeable closeable = this.onClose;
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    @NotNull
    public final Function0<Source> component1() {
        return this.source;
    }

    @Nullable
    public final ImageBitmap component2() {
        return this.preview;
    }

    private final Closeable component3() {
        return this.onClose;
    }

    @NotNull
    public final RawImageSource copy(@NotNull Function0<? extends Source> source, @Nullable ImageBitmap preview, @Nullable Closeable onClose) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        return new RawImageSource(source, preview, onClose);
    }

    public static /* synthetic */ RawImageSource copy$default(RawImageSource rawImageSource, Function0 function0, ImageBitmap imageBitmap, Closeable closeable, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = rawImageSource.source;
        }
        if ((n & 2) != 0) {
            imageBitmap = rawImageSource.preview;
        }
        if ((n & 4) != 0) {
            closeable = rawImageSource.onClose;
        }
        return rawImageSource.copy(function0, imageBitmap, closeable);
    }

    @NotNull
    public String toString() {
        return "RawImageSource(source=" + this.source + ", preview=" + this.preview + ", onClose=" + this.onClose + ")";
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + (this.preview == null ? 0 : this.preview.hashCode());
        result = result * 31 + (this.onClose == null ? 0 : this.onClose.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RawImageSource)) {
            return false;
        }
        RawImageSource rawImageSource = (RawImageSource)other;
        if (!Intrinsics.areEqual(this.source, rawImageSource.source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.preview, (Object)rawImageSource.preview)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.onClose, (Object)rawImageSource.onClose);
    }
}

