/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemHolder;
import me.panpf.adapter.more.MoreItemFactory;
import me.panpf.adapter.more.MoreItemHolder;

public class ItemStorage {
    @NonNull
    private final Object headerItemListLock = new Object();
    @NonNull
    private final Object itemListLock = new Object();
    @NonNull
    private final Object itemFactoryListLock = new Object();
    @NonNull
    private final Object footerItemListLock = new Object();
    @NonNull
    private AssemblyAdapter adapter;
    private int itemTypeIndex = 0;
    private int headerItemPosition;
    private int footerItemPosition;
    private boolean itemFactoryLocked;
    @Nullable
    private ArrayList<ItemHolder> headerItemList;
    @Nullable
    private List dataList;
    @Nullable
    private ArrayList<ItemHolder> footerItemList;
    @Nullable
    private MoreItemHolder moreItemHolder;
    @Nullable
    private ArrayList<ItemFactory> itemFactoryList;
    @Nullable
    private SparseArray<Object> itemFactoryArray;
    private boolean notifyOnChange = true;

    public ItemStorage(@NonNull AssemblyAdapter adapter) {
        this.adapter = adapter;
    }

    public ItemStorage(@NonNull AssemblyAdapter adapter, @Nullable List dataList) {
        this.adapter = adapter;
        this.dataList = dataList;
    }

    public ItemStorage(@NonNull AssemblyAdapter adapter, @Nullable Object[] dataArray) {
        this.adapter = adapter;
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    @NonNull
    public AssemblyAdapter getAdapter() {
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemFactory(@NonNull ItemFactory itemFactory) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        itemFactory.setItemType(this.itemTypeIndex++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemFactory.getItemType(), (Object)itemFactory);
        Object object = this.itemFactoryListLock;
        synchronized (object) {
            if (this.itemFactoryList == null) {
                this.itemFactoryList = new ArrayList(5);
            }
            this.itemFactoryList.add(itemFactory);
        }
    }

    @Nullable
    public List<ItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    public int getItemFactoryCount() {
        return this.itemFactoryList != null ? this.itemFactoryList.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <DATA> ItemHolder<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        itemFactory.setItemType(this.itemTypeIndex++);
        ItemHolder<DATA> itemHolder = new ItemHolder<DATA>(this, itemFactory, data, true);
        itemHolder.setPosition(this.headerItemPosition++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemFactory.getItemType(), itemHolder);
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList == null) {
                this.headerItemList = new ArrayList(1);
            }
            this.headerItemList.add(itemHolder);
        }
        return itemHolder;
    }

    @NonNull
    public <DATA> ItemHolder<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.addHeaderItem(itemFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <DATA> ItemHolder<DATA> addHeaderItem(@NonNull ItemHolder<DATA> itemHolder) {
        if (itemHolder == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemHolder is null or item factory list locked");
        }
        if (itemHolder.getItemStorage() != null) {
            throw new IllegalArgumentException("Cannot be added repeatedly");
        }
        itemHolder.getItemFactory().setAdapter(this.adapter);
        itemHolder.getItemFactory().setItemType(this.itemTypeIndex++);
        itemHolder.setItemStorage(this);
        itemHolder.setHeader(true);
        itemHolder.setPosition(this.headerItemPosition++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemHolder.getItemFactory().getItemType(), itemHolder);
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList == null) {
                this.headerItemList = new ArrayList(1);
            }
            this.headerItemList.add(itemHolder);
        }
        return itemHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void headerEnabledChanged(@NonNull ItemHolder itemHolder) {
        if (itemHolder == null || itemHolder.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (itemHolder.isEnabled()) {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList == null) {
                    this.headerItemList = new ArrayList(1);
                }
                this.headerItemList.add(itemHolder);
                Collections.sort(this.headerItemList, new Comparator<ItemHolder>(){

                    @Override
                    public int compare(ItemHolder lhs, ItemHolder rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList != null && this.headerItemList.remove(itemHolder) && this.notifyOnChange) {
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
    }

    @Nullable
    public List<ItemHolder> getHeaderItemList() {
        return this.headerItemList;
    }

    public int getHeaderItemCount() {
        return this.headerItemList != null ? this.headerItemList.size() : 0;
    }

    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.headerItemList != null ? this.headerItemList.get(positionInHeaderList).getData() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <DATA> ItemHolder<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        itemFactory.setItemType(this.itemTypeIndex++);
        ItemHolder<DATA> itemHolder = new ItemHolder<DATA>(this, itemFactory, data, false);
        itemHolder.setPosition(this.footerItemPosition++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemFactory.getItemType(), itemHolder);
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList == null) {
                this.footerItemList = new ArrayList(1);
            }
            this.footerItemList.add(itemHolder);
        }
        return itemHolder;
    }

    @NonNull
    public <DATA> ItemHolder<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.addFooterItem(itemFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public <DATA> ItemHolder<DATA> addFooterItem(@NonNull ItemHolder<DATA> itemHolder) {
        if (itemHolder == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemHolder is null or item factory list locked");
        }
        if (itemHolder.getItemStorage() != null) {
            throw new IllegalArgumentException("Cannot be added repeatedly");
        }
        itemHolder.getItemFactory().setAdapter(this.adapter);
        itemHolder.getItemFactory().setItemType(this.itemTypeIndex++);
        itemHolder.setItemStorage(this);
        itemHolder.setHeader(false);
        itemHolder.setPosition(this.footerItemPosition++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemHolder.getItemFactory().getItemType(), itemHolder);
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList == null) {
                this.footerItemList = new ArrayList(1);
            }
            this.footerItemList.add(itemHolder);
        }
        return itemHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void footerEnabledChanged(@NonNull ItemHolder itemHolder) {
        if (itemHolder == null || itemHolder.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (itemHolder.isEnabled()) {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList == null) {
                    this.footerItemList = new ArrayList(1);
                }
                this.footerItemList.add(itemHolder);
                Collections.sort(this.footerItemList, new Comparator<ItemHolder>(){

                    @Override
                    public int compare(ItemHolder lhs, ItemHolder rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList != null && this.footerItemList.remove(itemHolder) && this.notifyOnChange) {
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
    }

    @Nullable
    public List<ItemHolder> getFooterItemList() {
        return this.footerItemList;
    }

    public int getFooterItemCount() {
        return this.footerItemList != null ? this.footerItemList.size() : 0;
    }

    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.footerItemList != null ? this.footerItemList.get(positionInFooterList).getData() : null;
    }

    @NonNull
    public <DATA> MoreItemHolder<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory, @Nullable DATA data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        if (this.moreItemHolder != null) {
            itemFactory.setItemType(this.moreItemHolder.getItemFactory().getItemType());
        } else {
            itemFactory.setItemType(this.itemTypeIndex++);
        }
        itemFactory.loadMoreFinished(false);
        MoreItemHolder<DATA> moreItemHolder = new MoreItemHolder<DATA>(this, itemFactory, data, false);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemFactory.getItemType(), moreItemHolder);
        this.moreItemHolder = moreItemHolder;
        return moreItemHolder;
    }

    @NonNull
    public <DATA> MoreItemHolder<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory) {
        return this.setMoreItem(itemFactory, null);
    }

    @NonNull
    public <DATA> MoreItemHolder<DATA> setMoreItem(@NonNull MoreItemHolder<DATA> newItemHolder) {
        if (newItemHolder == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemHolder is null or item factory list locked");
        }
        newItemHolder.getItemFactory().setAdapter(this.adapter);
        if (this.moreItemHolder != null) {
            newItemHolder.getItemFactory().setItemType(this.moreItemHolder.getItemFactory().getItemType());
        } else {
            newItemHolder.getItemFactory().setItemType(this.itemTypeIndex++);
        }
        newItemHolder.getItemFactory().loadMoreFinished(false);
        newItemHolder.setItemStorage(this);
        newItemHolder.setHeader(false);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(newItemHolder.getItemFactory().getItemType(), newItemHolder);
        this.moreItemHolder = newItemHolder;
        return newItemHolder;
    }

    @Nullable
    public MoreItemHolder getMoreItemHolder() {
        return this.moreItemHolder;
    }

    public boolean hasMoreFooter() {
        return this.moreItemHolder != null && this.moreItemHolder.isEnabled();
    }

    public void setEnabledMoreItem(boolean enabledMoreItem) {
        if (this.moreItemHolder != null) {
            this.moreItemHolder.setEnabled(enabledMoreItem);
        }
    }

    public void loadMoreFinished(boolean loadMoreEnd) {
        if (this.moreItemHolder != null) {
            this.moreItemHolder.loadMoreFinished(loadMoreEnd);
        }
    }

    public void loadMoreFailed() {
        if (this.moreItemHolder != null) {
            this.moreItemHolder.loadMoreFailed();
        }
    }

    @Nullable
    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(@Nullable List dataList) {
        Object object = this.itemListLock;
        synchronized (object) {
            this.dataList = dataList;
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@Nullable Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(collection.size());
            }
            this.dataList.addAll(collection);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Object ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(items.length);
            }
            Collections.addAll(this.dataList, items);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@Nullable Object object, int index) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList == null) {
                this.dataList = new ArrayList();
            }
            this.dataList.add(index, object);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NonNull Object object) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList != null) {
                this.dataList.remove(object);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                this.dataList.clear();
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(@NonNull Comparator comparator) {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                Collections.sort(this.dataList, comparator);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    public boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }

    public int getViewTypeCount() {
        this.itemFactoryLocked = true;
        return this.itemTypeIndex > 0 ? this.itemTypeIndex : 1;
    }

    @Nullable
    public Object getItemFactoryByViewType(int viewType) {
        return this.itemFactoryArray != null ? this.itemFactoryArray.get(viewType) : null;
    }
}

