/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import java.util.List;
import me.panpf.adapter.pager.AssemblyFragmentAdapter;
import me.panpf.adapter.pager.AssemblyFragmentItemFactory;
import me.panpf.adapter.pager.FixedFragmentItemInfo;

public class FragmentItemActor {
    @NonNull
    private AssemblyFragmentAdapter adapter;

    public FragmentItemActor(@NonNull AssemblyFragmentAdapter adapter) {
        this.adapter = adapter;
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.adapter.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.adapter.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.adapter.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }

    public int getItemCount() {
        return this.adapter.getHeaderItemCount() + this.adapter.getDataCount() + this.adapter.getFooterItemCount();
    }

    public Fragment getItem(int position) {
        int headerItemCount = this.adapter.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        List<FixedFragmentItemInfo> headerItemList = this.adapter.getHeaderItemList();
        if (headerItemList != null && position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            FixedFragmentItemInfo fixedItemInfo = headerItemList.get(positionInHeaderList);
            return fixedItemInfo.getItemFactory().dispatchCreateFragment(position, fixedItemInfo.getData());
        }
        int dataCount = this.adapter.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        List<AssemblyFragmentItemFactory> itemFactoryList = this.adapter.getItemFactoryList();
        if (itemFactoryList != null && position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.adapter.getData(positionInDataList);
            if (dataObject == null) {
                throw new IllegalArgumentException("data is null, position is " + position + ", positionInDataList is " + positionInDataList);
            }
            int size = itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyFragmentItemFactory itemFactory = itemFactoryList.get(w);
                if (!itemFactory.isTarget(dataObject)) continue;
                return itemFactory.dispatchCreateFragment(position, dataObject);
            }
            throw new IllegalStateException(String.format("Didn't find suitable AssemblyFragmentItemFactory. position=%d, dataObject=%s", position, dataObject.getClass().getName()));
        }
        int footerItemCount = this.adapter.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        List<FixedFragmentItemInfo> footerItemList = this.adapter.getFooterItemList();
        if (footerItemList != null && position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            FixedFragmentItemInfo fixedItemInfo = footerItemList.get(positionInFooterList);
            return fixedItemInfo.getItemFactory().dispatchCreateFragment(position, fixedItemInfo.getData());
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }
}

