/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.AssemblyItem;
import me.panpf.adapter.AssemblyItemFactory;
import me.panpf.adapter.FixedItemInfo;
import me.panpf.adapter.Item;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.expandable.ExpandableItemActor;
import me.panpf.adapter.expandable.ExpandableItemStorage;
import me.panpf.adapter.more.AssemblyLoadMoreItem;
import me.panpf.adapter.more.AssemblyLoadMoreItemFactory;
import me.panpf.adapter.more.LoadMoreFixedItemInfo;

public class AssemblyExpandableAdapter
extends BaseExpandableListAdapter
implements AssemblyAdapter {
    @NonNull
    private ExpandableItemStorage storage;
    @NonNull
    private ExpandableItemActor actor = new ExpandableItemActor(this);
    private ExpandCallback expandCallback;

    public AssemblyExpandableAdapter() {
        this.storage = new ExpandableItemStorage(this);
    }

    public AssemblyExpandableAdapter(@Nullable List dataList) {
        this.storage = new ExpandableItemStorage((AssemblyAdapter)this, dataList);
    }

    public AssemblyExpandableAdapter(@Nullable Object[] dataArray) {
        this.storage = new ExpandableItemStorage((AssemblyAdapter)this, dataArray);
    }

    @Override
    public <ITEM extends AssemblyItem> void addItemFactory(@NonNull AssemblyItemFactory<ITEM> itemFactory) {
        this.storage.addItemFactory(itemFactory);
    }

    public <ITEM extends AssemblyItem> void addGroupItemFactory(@NonNull AssemblyItemFactory<ITEM> groupItemFactory) {
        this.storage.addItemFactory(groupItemFactory);
    }

    public <ITEM extends AssemblyItem> void addChildItemFactory(@NonNull AssemblyItemFactory<ITEM> childItemFactory) {
        this.storage.addChildItemFactory(childItemFactory);
    }

    @Override
    @Nullable
    public List<ItemFactory> getItemFactoryList() {
        return this.storage.getItemFactoryList();
    }

    @Nullable
    public List<ItemFactory> getGroupItemFactoryList() {
        return this.storage.getItemFactoryList();
    }

    @Nullable
    public List<ItemFactory> getChildItemFactoryList() {
        return this.storage.getChildItemFactoryList();
    }

    @Override
    public int getItemFactoryCount() {
        return this.storage.getItemFactoryCount();
    }

    public int getGroupItemFactoryCount() {
        return this.storage.getItemFactoryCount();
    }

    public int getChildItemFactoryCount() {
        return this.storage.getChildItemFactoryCount();
    }

    @Override
    @NonNull
    public <ITEM extends AssemblyItem> FixedItemInfo addHeaderItem(@NonNull AssemblyItemFactory<ITEM> itemFactory, @Nullable Object data) {
        return this.storage.addHeaderItem(itemFactory, data);
    }

    @Override
    @NonNull
    public <ITEM extends AssemblyItem> FixedItemInfo addHeaderItem(@NonNull AssemblyItemFactory<ITEM> itemFactory) {
        return this.storage.addHeaderItem(itemFactory);
    }

    @Override
    public void headerEnabledChanged(@NonNull FixedItemInfo headerItemInfo) {
        this.storage.headerEnabledChanged(headerItemInfo);
    }

    @Override
    public List<FixedItemInfo> getHeaderItemList() {
        return this.storage.getHeaderItemList();
    }

    @Override
    public int getHeaderItemCount() {
        return this.storage.getHeaderItemCount();
    }

    @Override
    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.storage.getHeaderData(positionInHeaderList);
    }

    @Override
    @NonNull
    public <ITEM extends AssemblyItem> FixedItemInfo addFooterItem(@NonNull AssemblyItemFactory<ITEM> itemFactory, @Nullable Object data) {
        return this.storage.addFooterItem(itemFactory, data);
    }

    @Override
    @NonNull
    public <ITEM extends AssemblyItem> FixedItemInfo addFooterItem(@NonNull AssemblyItemFactory<ITEM> itemFactory) {
        return this.storage.addHeaderItem(itemFactory);
    }

    @Override
    public void footerEnabledChanged(@NonNull FixedItemInfo footerItemInfo) {
        this.storage.footerEnabledChanged(footerItemInfo);
    }

    @Override
    public List<FixedItemInfo> getFooterItemList() {
        return this.storage.getFooterItemList();
    }

    @Override
    public int getFooterItemCount() {
        return this.storage.getFooterItemCount();
    }

    @Override
    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.storage.getFooterData(positionInFooterList);
    }

    @Override
    @NonNull
    public <ITEM extends AssemblyLoadMoreItem> LoadMoreFixedItemInfo setLoadMoreItem(@NonNull AssemblyLoadMoreItemFactory<ITEM> itemFactory, @Nullable Object data) {
        return this.storage.setLoadMoreItem(itemFactory, data);
    }

    @Override
    @NonNull
    public <ITEM extends AssemblyLoadMoreItem> LoadMoreFixedItemInfo setLoadMoreItem(@NonNull AssemblyLoadMoreItemFactory<ITEM> itemFactory) {
        return this.storage.setLoadMoreItem(itemFactory);
    }

    @Override
    @Nullable
    public LoadMoreFixedItemInfo getLoadMoreFixedItemInfo() {
        return this.storage.getLoadMoreFixedItemInfo();
    }

    @Override
    public void setDisableLoadMore(boolean disableLoadMore) {
        this.storage.setDisableLoadMore(disableLoadMore);
    }

    @Override
    public boolean hasLoadMoreFooter() {
        return this.storage.hasLoadMoreFooter();
    }

    @Override
    public void loadMoreFinished(boolean loadMoreEnd) {
        this.storage.loadMoreFinished(loadMoreEnd);
    }

    @Override
    public void loadMoreFailed() {
        this.storage.loadMoreFailed();
    }

    @Override
    public List getDataList() {
        return this.storage.getDataList();
    }

    @Override
    public void setDataList(@Nullable List dataList) {
        this.storage.setDataList(dataList);
    }

    @Override
    public void addAll(@Nullable Collection collection) {
        this.storage.addAll(collection);
    }

    @Override
    public void addAll(Object ... items) {
        this.storage.addAll(items);
    }

    @Override
    public void insert(@NonNull Object object, int index) {
        this.storage.insert(object, index);
    }

    @Override
    public void remove(@NonNull Object object) {
        this.storage.remove(object);
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public void sort(@NonNull Comparator comparator) {
        this.storage.sort(comparator);
    }

    @Override
    public int getDataCount() {
        return this.storage.getDataCount();
    }

    @Override
    @Nullable
    public Object getData(int positionInDataList) {
        return this.storage.getData(positionInDataList);
    }

    @Override
    public int getItemCount() {
        return this.actor.getItemCount();
    }

    @Override
    @Nullable
    public Object getItem(int position) {
        return this.actor.getItem(position);
    }

    @Override
    public int getPositionInPart(int position) {
        return this.actor.getPositionInPart(position);
    }

    @Override
    public boolean isNotifyOnChange() {
        return this.storage.isNotifyOnChange();
    }

    @Override
    public void setNotifyOnChange(boolean notifyOnChange) {
        this.storage.setNotifyOnChange(notifyOnChange);
    }

    @Override
    public int getSpanSize(int position) {
        return this.actor.getSpanSize(position);
    }

    public int getGroupCount() {
        return this.actor.getItemCount();
    }

    @Nullable
    public Object getGroup(int groupPosition) {
        return this.actor.getItem(groupPosition);
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public int getGroupTypeCount() {
        return this.storage.getViewTypeCount();
    }

    public int getGroupType(int groupPosition) {
        return this.actor.getItemViewType(groupPosition);
    }

    public int getChildrenCount(int groupPosition) {
        return this.actor.getChildrenCount(groupPosition);
    }

    @Nullable
    public Object getChild(int groupPosition, int childPosition) {
        return this.actor.getChild(groupPosition, childPosition);
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public int getChildTypeCount() {
        return this.storage.getChildTypeCount();
    }

    public int getChildType(int groupPosition, int childPosition) {
        return this.actor.getChildType(groupPosition, childPosition);
    }

    public boolean hasStableIds() {
        return this.expandCallback != null && this.expandCallback.hasStableIds();
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return this.expandCallback != null && this.expandCallback.isChildSelectable(groupPosition, childPosition);
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        Item groupItem;
        if (convertView == null) {
            groupItem = this.createGroupItem(parent, this.getGroupType(groupPosition));
            convertView = groupItem.getItemView();
            convertView.setTag((Object)groupItem);
        } else {
            groupItem = (Item)convertView.getTag();
        }
        this.bindGroupItem(groupItem, isExpanded, groupPosition);
        return convertView;
    }

    private Item createGroupItem(ViewGroup parent, int viewType) {
        Object itemObject = this.storage.getItemFactoryByViewType(viewType);
        if (itemObject instanceof AssemblyItemFactory) {
            AssemblyItemFactory itemFactory = (AssemblyItemFactory)itemObject;
            return itemFactory.dispatchCreateItem(parent);
        }
        if (itemObject instanceof FixedItemInfo) {
            FixedItemInfo fixedItemInfo = (FixedItemInfo)itemObject;
            return fixedItemInfo.getItemFactory().dispatchCreateItem(parent);
        }
        throw new IllegalStateException(String.format("Unknown groupViewType: %d, itemFactory: %s", viewType, itemObject != null ? itemObject.getClass().getName() : "null"));
    }

    private void bindGroupItem(@NonNull Item groupItem, boolean isExpanded, int groupPosition) {
        Object group = this.getGroup(groupPosition);
        if (group != null) {
            groupItem.setExpanded(isExpanded);
            groupItem.setData(groupPosition, group);
        }
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        Item childItem;
        if (convertView == null) {
            childItem = this.createChildItem(parent, this.getChildType(groupPosition, childPosition));
            convertView = childItem.getItemView();
            convertView.setTag((Object)childItem);
        } else {
            childItem = (Item)convertView.getTag();
        }
        this.bindChildItem(childItem, groupPosition, childPosition, isLastChild);
        return convertView;
    }

    private Item createChildItem(ViewGroup parent, int viewType) {
        Object itemObject = this.storage.getChildItemFactoryByViewType(viewType);
        if (itemObject instanceof AssemblyItemFactory) {
            AssemblyItemFactory itemFactory = (AssemblyItemFactory)itemObject;
            return itemFactory.dispatchCreateItem(parent);
        }
        throw new IllegalStateException(String.format("Unknown childViewType: %d, itemFactory: %s", viewType, itemObject != null ? itemObject.getClass().getName() : "null"));
    }

    private void bindChildItem(Item childItem, int groupPosition, int childPosition, boolean isLastChild) {
        Object child = this.getChild(groupPosition, childPosition);
        if (child != null) {
            childItem.setGroupPosition(groupPosition);
            childItem.setLastChild(isLastChild);
            childItem.setData(childPosition, child);
        }
    }

    public void setExpandCallback(ExpandCallback expandCallback) {
        this.expandCallback = expandCallback;
    }

    public static interface ExpandCallback {
        public boolean hasStableIds();

        public boolean isChildSelectable(int var1, int var2);
    }
}

