/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.util.Log;
import android.widget.ScrollView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.setupwizardlib.template.RequireScrollMixin;
import com.android.setupwizardlib.view.BottomScrollView;

public class ScrollViewScrollHandlingDelegate
implements RequireScrollMixin.ScrollHandlingDelegate,
BottomScrollView.BottomScrollListener {
    private static final String TAG = "ScrollViewDelegate";
    @NonNull
    private final RequireScrollMixin mRequireScrollMixin;
    @Nullable
    private final BottomScrollView mScrollView;

    public ScrollViewScrollHandlingDelegate(@NonNull RequireScrollMixin requireScrollMixin, @Nullable ScrollView scrollView) {
        this.mRequireScrollMixin = requireScrollMixin;
        if (scrollView instanceof BottomScrollView) {
            this.mScrollView = (BottomScrollView)scrollView;
        } else {
            Log.w((String)TAG, (String)("Cannot set non-BottomScrollView. Found=" + scrollView));
            this.mScrollView = null;
        }
    }

    @Override
    public void onScrolledToBottom() {
        this.mRequireScrollMixin.notifyScrollabilityChange(false);
    }

    @Override
    public void onRequiresScroll() {
        this.mRequireScrollMixin.notifyScrollabilityChange(true);
    }

    @Override
    public void startListening() {
        if (this.mScrollView != null) {
            this.mScrollView.setBottomScrollListener(this);
        } else {
            Log.w((String)TAG, (String)"Cannot require scroll. Scroll view is null.");
        }
    }

    @Override
    public void pageScrollDown() {
        if (this.mScrollView != null) {
            this.mScrollView.pageScroll(130);
        }
    }
}

