/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.view.MotionEvent;
import android.widget.TextView;

public interface TouchableMovementMethod {
    public MotionEvent getLastTouchEvent();

    public boolean isLastTouchEventHandled();

    public static class TouchableLinkMovementMethod
    extends LinkMovementMethod
    implements TouchableMovementMethod {
        boolean mLastEventResult = false;
        MotionEvent mLastEvent;

        public static TouchableLinkMovementMethod getInstance() {
            return new TouchableLinkMovementMethod();
        }

        public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
            this.mLastEvent = event;
            boolean result = super.onTouchEvent(widget, buffer, event);
            this.mLastEventResult = event.getAction() == 0 ? Selection.getSelectionStart((CharSequence)buffer) != -1 : result;
            return result;
        }

        @Override
        public MotionEvent getLastTouchEvent() {
            return this.mLastEvent;
        }

        @Override
        public boolean isLastTouchEventHandled() {
            return this.mLastEventResult;
        }
    }
}

