/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ScrollView;

public class BottomScrollView
extends ScrollView {
    private BottomScrollListener mListener;
    private int mScrollThreshold;
    private boolean mRequiringScroll = false;
    private final Runnable mCheckScrollRunnable = new Runnable(){

        @Override
        public void run() {
            BottomScrollView.this.checkScroll();
        }
    };

    public BottomScrollView(Context context) {
        super(context);
    }

    public BottomScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BottomScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setBottomScrollListener(BottomScrollListener l) {
        this.mListener = l;
    }

    @VisibleForTesting
    public int getScrollThreshold() {
        return this.mScrollThreshold;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        View child = this.getChildAt(0);
        if (child != null) {
            this.mScrollThreshold = Math.max(0, child.getMeasuredHeight() - b + t - this.getPaddingBottom());
        }
        if (b - t > 0) {
            this.post(this.mCheckScrollRunnable);
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (oldt != t) {
            this.checkScroll();
        }
    }

    private void checkScroll() {
        if (this.mListener != null) {
            if (this.getScrollY() >= this.mScrollThreshold) {
                this.mListener.onScrolledToBottom();
            } else if (!this.mRequiringScroll) {
                this.mRequiringScroll = true;
                this.mListener.onRequiresScroll();
            }
        }
    }

    public static interface BottomScrollListener {
        public void onScrolledToBottom();

        public void onRequiresScroll();
    }
}

