/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.content.res.ColorStateList;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.ViewStub;
import android.widget.ProgressBar;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.template.Mixin;

public class ProgressBarMixin
implements Mixin {
    private TemplateLayout mTemplateLayout;
    @Nullable
    private ColorStateList mColor;

    public ProgressBarMixin(TemplateLayout layout2) {
        this.mTemplateLayout = layout2;
    }

    public boolean isShown() {
        Object progressBar = this.mTemplateLayout.findManagedViewById(R.id.suw_layout_progress);
        return progressBar != null && progressBar.getVisibility() == 0;
    }

    public void setShown(boolean shown) {
        if (shown) {
            ProgressBar progressBar = this.getProgressBar();
            if (progressBar != null) {
                progressBar.setVisibility(0);
            }
        } else {
            ProgressBar progressBar = this.peekProgressBar();
            if (progressBar != null) {
                progressBar.setVisibility(8);
            }
        }
    }

    private ProgressBar getProgressBar() {
        ProgressBar progressBar = this.peekProgressBar();
        if (progressBar == null) {
            ViewStub progressBarStub = (ViewStub)this.mTemplateLayout.findManagedViewById(R.id.suw_layout_progress_stub);
            if (progressBarStub != null) {
                progressBarStub.inflate();
            }
            this.setColor(this.mColor);
        }
        return this.peekProgressBar();
    }

    public ProgressBar peekProgressBar() {
        return (ProgressBar)this.mTemplateLayout.findManagedViewById(R.id.suw_layout_progress);
    }

    public void setColor(@Nullable ColorStateList color) {
        ProgressBar bar;
        this.mColor = color;
        if (Build.VERSION.SDK_INT >= 21 && (bar = this.peekProgressBar()) != null) {
            bar.setIndeterminateTintList(color);
            if (Build.VERSION.SDK_INT >= 23 || color != null) {
                bar.setProgressBackgroundTintList(color);
            }
        }
    }

    @Nullable
    public ColorStateList getColor() {
        return this.mColor;
    }
}

