/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.setupwizardlib.template.RequireScrollMixin;

public class ListViewScrollHandlingDelegate
implements RequireScrollMixin.ScrollHandlingDelegate,
AbsListView.OnScrollListener {
    private static final String TAG = "ListViewDelegate";
    private static final int SCROLL_DURATION = 500;
    @NonNull
    private final RequireScrollMixin mRequireScrollMixin;
    @Nullable
    private final ListView mListView;

    public ListViewScrollHandlingDelegate(@NonNull RequireScrollMixin requireScrollMixin, @Nullable ListView listView) {
        this.mRequireScrollMixin = requireScrollMixin;
        this.mListView = listView;
    }

    @Override
    public void startListening() {
        if (this.mListView != null) {
            this.mListView.setOnScrollListener((AbsListView.OnScrollListener)this);
            ListAdapter adapter = this.mListView.getAdapter();
            if (this.mListView.getLastVisiblePosition() < adapter.getCount()) {
                this.mRequireScrollMixin.notifyScrollabilityChange(true);
            }
        } else {
            Log.w((String)TAG, (String)"Cannot require scroll. List view is null");
        }
    }

    @Override
    public void pageScrollDown() {
        if (this.mListView != null) {
            int height = this.mListView.getHeight();
            this.mListView.smoothScrollBy(height, 500);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (firstVisibleItem + visibleItemCount >= totalItemCount) {
            this.mRequireScrollMixin.notifyScrollabilityChange(false);
        } else {
            this.mRequireScrollMixin.notifyScrollabilityChange(true);
        }
    }
}

