/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.template.HeaderMixin;

public class ColoredHeaderMixin
extends HeaderMixin {
    public ColoredHeaderMixin(TemplateLayout layout2, AttributeSet attrs, int defStyleAttr) {
        super(layout2, attrs, defStyleAttr);
        TypedArray a = layout2.getContext().obtainStyledAttributes(attrs, R.styleable.SuwColoredHeaderMixin, defStyleAttr, 0);
        ColorStateList headerColor = a.getColorStateList(R.styleable.SuwColoredHeaderMixin_suwHeaderColor);
        if (headerColor != null) {
            this.setColor(headerColor);
        }
        a.recycle();
    }

    public void setColor(ColorStateList color) {
        TextView titleView = this.getTextView();
        if (titleView != null) {
            titleView.setTextColor(color);
        }
    }

    public ColorStateList getColor() {
        TextView titleView = this.getTextView();
        return titleView != null ? titleView.getTextColors() : null;
    }
}

