/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.items;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.SwitchCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.items.Item;

public class SwitchItem
extends Item
implements CompoundButton.OnCheckedChangeListener {
    private boolean mChecked = false;
    private OnCheckedChangeListener mListener;

    public SwitchItem() {
    }

    public SwitchItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwSwitchItem);
        this.mChecked = a.getBoolean(R.styleable.SuwSwitchItem_android_checked, false);
        a.recycle();
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.notifyItemChanged();
            if (this.mListener != null) {
                this.mListener.onCheckedChange(this, checked);
            }
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    @Override
    protected int getDefaultLayoutResource() {
        return R.layout.suw_items_switch;
    }

    public void toggle(View view) {
        this.mChecked = !this.mChecked;
        SwitchCompat switchView = (SwitchCompat)view.findViewById(R.id.suw_items_switch);
        switchView.setChecked(this.mChecked);
    }

    @Override
    public void onBindView(View view) {
        super.onBindView(view);
        SwitchCompat switchView = (SwitchCompat)view.findViewById(R.id.suw_items_switch);
        switchView.setOnCheckedChangeListener(null);
        switchView.setChecked(this.mChecked);
        switchView.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        switchView.setEnabled(this.isEnabled());
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mListener = listener;
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        this.mChecked = isChecked;
        if (this.mListener != null) {
            this.mListener.onCheckedChange(this, isChecked);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChange(SwitchItem var1, boolean var2);
    }
}

