/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.text.Annotation;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.TextAppearanceSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.android.setupwizardlib.span.LinkSpan;
import com.android.setupwizardlib.span.SpanHelper;
import com.android.setupwizardlib.util.LinkAccessibilityHelper;

public class RichTextView
extends TextView {
    private static final String TAG = "RichTextView";
    private static final String ANNOTATION_LINK = "link";
    private static final String ANNOTATION_TEXT_APPEARANCE = "textAppearance";
    private LinkAccessibilityHelper mAccessibilityHelper;

    public static CharSequence getRichText(Context context, CharSequence text) {
        if (text instanceof Spanned) {
            Annotation[] spans;
            SpannableString spannable = new SpannableString(text);
            for (Annotation span : spans = (Annotation[])spannable.getSpans(0, spannable.length(), Annotation.class)) {
                String key = span.getKey();
                if (ANNOTATION_TEXT_APPEARANCE.equals(key)) {
                    String textAppearance = span.getValue();
                    int style2 = context.getResources().getIdentifier(textAppearance, "style", context.getPackageName());
                    if (style2 == 0) {
                        Log.w((String)TAG, (String)("Cannot find resource: " + style2));
                    }
                    TextAppearanceSpan textAppearanceSpan = new TextAppearanceSpan(context, style2);
                    SpanHelper.replaceSpan((Spannable)spannable, span, textAppearanceSpan);
                    continue;
                }
                if (!ANNOTATION_LINK.equals(key)) continue;
                LinkSpan link = new LinkSpan(span.getValue());
                SpanHelper.replaceSpan((Spannable)spannable, span, (Object)link);
            }
            return spannable;
        }
        return text;
    }

    public RichTextView(Context context) {
        super(context);
        this.init();
    }

    public RichTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mAccessibilityHelper = new LinkAccessibilityHelper(this);
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)this.mAccessibilityHelper);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        text = RichTextView.getRichText(this.getContext(), text);
        super.setText(text, type);
        boolean hasLinks = this.hasLinks(text);
        if (hasLinks) {
            this.setMovementMethod(LinkMovementMethod.getInstance());
        } else {
            this.setMovementMethod(null);
        }
        this.setFocusable(hasLinks);
    }

    private boolean hasLinks(CharSequence text) {
        if (text instanceof Spanned) {
            ClickableSpan[] spans = (ClickableSpan[])((Spanned)text).getSpans(0, text.length(), ClickableSpan.class);
            return spans.length > 0;
        }
        return false;
    }

    protected boolean dispatchHoverEvent(MotionEvent event) {
        if (this.mAccessibilityHelper != null && this.mAccessibilityHelper.dispatchHoverEvent(event)) {
            return true;
        }
        return super.dispatchHoverEvent(event);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (Build.VERSION.SDK_INT >= 17) {
            int[] state = this.getDrawableState();
            for (Drawable drawable : this.getCompoundDrawablesRelative()) {
                if (drawable == null || !drawable.setState(state)) continue;
                this.invalidateDrawable(drawable);
            }
        }
    }
}

