/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.android.setupwizardlib.R;

public class IntrinsicSizeFrameLayout
extends FrameLayout {
    private int mIntrinsicHeight = 0;
    private int mIntrinsicWidth = 0;

    public IntrinsicSizeFrameLayout(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public IntrinsicSizeFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    @TargetApi(value=11)
    public IntrinsicSizeFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwMaxSizeFrameLayout, defStyleAttr, 0);
        this.mIntrinsicHeight = a.getDimensionPixelSize(R.styleable.SuwMaxSizeFrameLayout_android_height, 0);
        this.mIntrinsicWidth = a.getDimensionPixelSize(R.styleable.SuwMaxSizeFrameLayout_android_width, 0);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(this.getIntrinsicMeasureSpec(widthMeasureSpec, this.mIntrinsicWidth), this.getIntrinsicMeasureSpec(heightMeasureSpec, this.mIntrinsicHeight));
    }

    private int getIntrinsicMeasureSpec(int measureSpec, int intrinsicSize) {
        if (intrinsicSize <= 0) {
            return measureSpec;
        }
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        if (mode == 0) {
            return View.MeasureSpec.makeMeasureSpec((int)this.mIntrinsicHeight, (int)0x40000000);
        }
        if (mode == Integer.MIN_VALUE) {
            return View.MeasureSpec.makeMeasureSpec((int)Math.min(size, this.mIntrinsicHeight), (int)0x40000000);
        }
        return measureSpec;
    }
}

