/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.template;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.TemplateLayout;
import com.android.setupwizardlib.items.ItemAdapter;
import com.android.setupwizardlib.items.ItemGroup;
import com.android.setupwizardlib.items.ItemInflater;
import com.android.setupwizardlib.template.Mixin;
import com.android.setupwizardlib.util.DrawableLayoutDirectionHelper;

public class ListMixin
implements Mixin {
    private TemplateLayout mTemplateLayout;
    @Nullable
    private ListView mListView;
    private Drawable mDivider;
    private Drawable mDefaultDivider;
    private int mDividerInset;

    public ListMixin(@NonNull TemplateLayout layout2, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        this.mTemplateLayout = layout2;
        Context context = layout2.getContext();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SuwListMixin, defStyleAttr, 0);
        int entries = a.getResourceId(R.styleable.SuwListMixin_android_entries, 0);
        if (entries != 0) {
            ItemGroup inflated = (ItemGroup)new ItemInflater(context).inflate(entries);
            this.setAdapter((ListAdapter)new ItemAdapter(inflated));
        }
        int dividerInset = a.getDimensionPixelSize(R.styleable.SuwListMixin_suwDividerInset, 0);
        this.setDividerInset(dividerInset);
        a.recycle();
    }

    public ListView getListView() {
        return this.getListViewInternal();
    }

    @Nullable
    private ListView getListViewInternal() {
        View list;
        if (this.mListView == null && (list = this.mTemplateLayout.findManagedViewById(16908298)) instanceof ListView) {
            this.mListView = (ListView)list;
        }
        return this.mListView;
    }

    public void onLayout() {
        if (this.mDivider == null) {
            this.updateDivider();
        }
    }

    public ListAdapter getAdapter() {
        ListView listView = this.getListViewInternal();
        if (listView != null) {
            ListAdapter adapter = listView.getAdapter();
            if (adapter instanceof HeaderViewListAdapter) {
                return ((HeaderViewListAdapter)adapter).getWrappedAdapter();
            }
            return adapter;
        }
        return null;
    }

    public void setAdapter(ListAdapter adapter) {
        ListView listView = this.getListViewInternal();
        if (listView != null) {
            listView.setAdapter(adapter);
        }
    }

    public void setDividerInset(int inset) {
        this.mDividerInset = inset;
        this.updateDivider();
    }

    public int getDividerInset() {
        return this.mDividerInset;
    }

    private void updateDivider() {
        ListView listView = this.getListViewInternal();
        if (listView == null) {
            return;
        }
        boolean shouldUpdate = true;
        if (Build.VERSION.SDK_INT >= 19) {
            shouldUpdate = this.mTemplateLayout.isLayoutDirectionResolved();
        }
        if (shouldUpdate) {
            if (this.mDefaultDivider == null) {
                this.mDefaultDivider = listView.getDivider();
            }
            this.mDivider = DrawableLayoutDirectionHelper.createRelativeInsetDrawable(this.mDefaultDivider, this.mDividerInset, 0, 0, 0, (View)this.mTemplateLayout);
            listView.setDivider(this.mDivider);
        }
    }

    public Drawable getDivider() {
        return this.mDivider;
    }
}

