/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.android.setupwizardlib.GlifLayout;
import com.android.setupwizardlib.R;
import com.android.setupwizardlib.template.ListMixin;
import com.android.setupwizardlib.template.ListViewScrollHandlingDelegate;
import com.android.setupwizardlib.template.RequireScrollMixin;

public class GlifListLayout
extends GlifLayout {
    private static final String TAG = "GlifListLayout";
    private ListMixin mListMixin;

    public GlifListLayout(Context context) {
        this(context, 0, 0);
    }

    public GlifListLayout(Context context, int template) {
        this(context, template, 0);
    }

    public GlifListLayout(Context context, int template, int containerId) {
        super(context, template, containerId);
        this.init(context, null, 0);
    }

    public GlifListLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    @TargetApi(value=11)
    public GlifListLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mListMixin = new ListMixin(this, attrs, defStyleAttr);
        this.registerMixin(ListMixin.class, this.mListMixin);
        RequireScrollMixin requireScrollMixin = this.getMixin(RequireScrollMixin.class);
        requireScrollMixin.setScrollHandlingDelegate(new ListViewScrollHandlingDelegate(requireScrollMixin, this.getListView()));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mListMixin.onLayout();
    }

    @Override
    protected View onInflateTemplate(LayoutInflater inflater, int template) {
        if (template == 0) {
            template = R.layout.suw_glif_list_template;
        }
        return super.onInflateTemplate(inflater, template);
    }

    @Override
    protected ViewGroup findContainer(int containerId) {
        if (containerId == 0) {
            containerId = 16908298;
        }
        return super.findContainer(containerId);
    }

    public ListView getListView() {
        return this.mListMixin.getListView();
    }

    public void setAdapter(ListAdapter adapter) {
        this.mListMixin.setAdapter(adapter);
    }

    public ListAdapter getAdapter() {
        return this.mListMixin.getAdapter();
    }

    public void setDividerInset(int inset) {
        this.mListMixin.setDividerInset(inset);
    }

    public int getDividerInset() {
        return this.mListMixin.getDividerInset();
    }

    public Drawable getDivider() {
        return this.mListMixin.getDivider();
    }
}

