/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import me.majiajie.barcodereader.ui.view.ScanDrawable;

public class ScanView
extends View
implements Animatable {
    private ScanDrawable mDrawable;
    private Rect mRect;

    public ScanView(Context context) {
        super(context);
    }

    public ScanView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ScanView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int lenght = (int)(200.0f * this.getContext().getResources().getDisplayMetrics().density);
        float startX = Math.max(0.0f, (float)(w - lenght) / 2.0f);
        float startY = Math.max(0.0f, (float)(h - lenght) / 2.0f);
        this.mRect = new Rect((int)startX, (int)startY, (int)(startX + (float)lenght), (int)(startY + (float)lenght));
        this.mDrawable = new ScanDrawable(this.getContext(), w, h, lenght);
        this.mDrawable.setCallback((Drawable.Callback)this);
        this.start();
    }

    public void invalidateDrawable(@NonNull Drawable drawable) {
        super.invalidateDrawable(drawable);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mDrawable.draw(canvas);
    }

    public void start() {
        if (this.mDrawable != null) {
            this.mDrawable.start();
        }
    }

    public void stop() {
        if (this.mDrawable != null) {
            this.mDrawable.stop();
        }
    }

    public boolean isRunning() {
        return this.mDrawable != null && this.mDrawable.isRunning();
    }

    public Rect getFramingRect(int previewWidth, int previewHeight, boolean isVertical) {
        int tmpHeight;
        int tmpWidth;
        if (isVertical) {
            tmpWidth = previewHeight;
            tmpHeight = previewWidth;
        } else {
            tmpWidth = previewWidth;
            tmpHeight = previewHeight;
        }
        int left = this.mRect.left * tmpWidth / this.getWidth();
        int right = this.mRect.right * tmpWidth / this.getWidth();
        int top = this.mRect.top * tmpHeight / this.getHeight();
        int bottom = this.mRect.bottom * tmpHeight / this.getHeight();
        Rect rect = new Rect();
        if (isVertical) {
            rect.set(top, tmpWidth - right, bottom, tmpWidth - left);
        } else {
            rect.set(left, top, right, bottom);
        }
        return rect;
    }
}

