/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.ui.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.animation.AccelerateDecelerateInterpolator;

public class ScanDrawable
extends Drawable
implements Animatable {
    private final int ANIM_TIME = 3000;
    private final int COLOR_OUTSIDE_BACKGROUND = 0x66000000;
    private final int COLOR_LINE_BACKGROUND = -1;
    private int mScanViewLenght;
    private int mWidth;
    private int mHeight;
    private Paint mPaintLine;
    private Paint mPaintBackground;
    private Path mPathLine;
    private Path mPathFrame;
    private Path mPathBackground;
    private ValueAnimator mAnimator;
    private float mStartX;
    private float mStartY;
    private float mEndX;
    private float mEndY;

    ScanDrawable(Context context, int width, int height, int scanViewLenght) {
        this.mWidth = width;
        this.mHeight = height;
        this.mScanViewLenght = scanViewLenght;
        this.mPaintBackground = new Paint();
        this.mPaintBackground.setColor(0x66000000);
        this.mPaintBackground.setAntiAlias(true);
        this.mPathBackground = new Path();
        RectF rectF = new RectF((float)((this.mWidth - this.mScanViewLenght) / 2), (float)((this.mHeight - this.mScanViewLenght) / 2), (float)(this.mWidth - (this.mWidth - this.mScanViewLenght) / 2), (float)(this.mHeight - (this.mHeight - this.mScanViewLenght) / 2));
        this.mPathBackground.addRect(new RectF(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight), Path.Direction.CW);
        this.mPathBackground.addRect(rectF, Path.Direction.CCW);
        float one_dp = 1.0f * context.getResources().getDisplayMetrics().density;
        this.mPaintLine = new Paint();
        this.mPaintLine.setColor(-1);
        this.mPaintLine.setStrokeWidth(one_dp * 2.0f);
        this.mPaintLine.setStyle(Paint.Style.STROKE);
        this.mPaintLine.setAntiAlias(true);
        this.mPaintLine.setStrokeCap(Paint.Cap.ROUND);
        this.mPaintLine.setStrokeJoin(Paint.Join.ROUND);
        this.mPathLine = new Path();
        this.mStartX = (float)((this.mWidth - this.mScanViewLenght) / 2) + one_dp;
        this.mStartY = this.mEndY = (float)(this.mHeight - this.mScanViewLenght) / 2.0f;
        this.mEndX = this.mStartX + (float)this.mScanViewLenght - one_dp;
        this.mPathLine.moveTo(this.mStartX, this.mStartY);
        this.mPathLine.lineTo(this.mEndX, this.mEndY);
        float eight_dp = 8.0f * context.getResources().getDisplayMetrics().density;
        float padding = eight_dp * 2.0f;
        this.mPathFrame = new Path();
        this.mPathFrame.moveTo((float)((this.mWidth - this.mScanViewLenght) / 2) + padding, (float)(this.mHeight - this.mScanViewLenght) / 2.0f + padding + eight_dp);
        this.mPathFrame.rLineTo(0.0f, -eight_dp);
        this.mPathFrame.rLineTo(eight_dp, 0.0f);
        this.mPathFrame.rMoveTo((float)this.mScanViewLenght - padding * 2.0f - eight_dp * 2.0f, 0.0f);
        this.mPathFrame.rLineTo(eight_dp, 0.0f);
        this.mPathFrame.rLineTo(0.0f, eight_dp);
        this.mPathFrame.rMoveTo(0.0f, (float)this.mScanViewLenght - padding * 2.0f - eight_dp * 2.0f);
        this.mPathFrame.rLineTo(0.0f, eight_dp);
        this.mPathFrame.rLineTo(-eight_dp, 0.0f);
        this.mPathFrame.rMoveTo(-((float)this.mScanViewLenght - padding * 2.0f - eight_dp * 2.0f), 0.0f);
        this.mPathFrame.rLineTo(-eight_dp, 0.0f);
        this.mPathFrame.rLineTo(0.0f, -eight_dp);
        this.setupAnimators();
    }

    public void draw(Canvas canvas) {
        canvas.drawPath(this.mPathBackground, this.mPaintBackground);
        canvas.drawPath(this.mPathLine, this.mPaintLine);
        canvas.drawPath(this.mPathFrame, this.mPaintLine);
    }

    public void setAlpha(int alpha) {
        this.mPaintLine.setAlpha(alpha);
        this.mPaintBackground.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaintLine.setColorFilter(colorFilter);
        this.mPaintBackground.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public void start() {
        this.mAnimator.start();
    }

    public void stop() {
        this.mAnimator.end();
    }

    public boolean isRunning() {
        return this.mAnimator.isRunning();
    }

    public int getIntrinsicHeight() {
        return this.mHeight;
    }

    public int getIntrinsicWidth() {
        return this.mWidth;
    }

    private void setupAnimators() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.setDuration(3000L);
        valueAnimator.setRepeatCount(-1);
        valueAnimator.setRepeatMode(2);
        valueAnimator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float n = ((Float)animation.getAnimatedValue()).floatValue();
                Path path = new Path();
                ScanDrawable.this.mStartY = (ScanDrawable.this.mEndY = (float)(ScanDrawable.this.mHeight - ScanDrawable.this.mScanViewLenght) / 2.0f + (float)ScanDrawable.this.mScanViewLenght * n);
                path.moveTo(ScanDrawable.this.mStartX, ScanDrawable.this.mStartY);
                path.lineTo(ScanDrawable.this.mEndX, ScanDrawable.this.mEndY);
                ScanDrawable.this.mPathLine = path;
                ScanDrawable.this.invalidateSelf();
            }
        });
        this.mAnimator = valueAnimator;
    }
}

