/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.ui.view;

import android.content.Context;
import android.hardware.Camera;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.IOException;
import java.util.List;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    private Context mContext;
    private SurfaceHolder mHolder;
    private Camera mCamera;
    private CameraPreviewListener mCameraPreviewListener;

    public void setCameraPreviewListener(CameraPreviewListener listener) {
        this.mCameraPreviewListener = listener;
    }

    public CameraPreview(Context context, Camera camera) {
        super(context);
        this.mContext = context;
        this.mCamera = camera;
        this.mHolder = this.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        try {
            boolean isVertical = this.mContext.getResources().getConfiguration().orientation == 1;
            Camera.Parameters parameters = this.mCamera.getParameters();
            Camera.Size size = this.getCloselyPreSize(isVertical, holder.getSurfaceFrame().width(), holder.getSurfaceFrame().height(), 1920, 1080, parameters.getSupportedPreviewSizes());
            holder.setFixedSize(size.width, size.height);
            this.mCamera.setPreviewDisplay(holder);
            this.mCamera.startPreview();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        if (this.mHolder.getSurface() == null) {
            return;
        }
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mCamera.setPreviewDisplay(this.mHolder);
            this.mCamera.startPreview();
            if (this.mCameraPreviewListener != null) {
                this.mCameraPreviewListener.onStartPreview();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    private Camera.Size getCloselyPreSize(boolean vertical, int surfaceWidth, int surfaceHeight, int maxWidth, int maxHeight, List<Camera.Size> preSizeList) {
        int tmpHeight;
        int tmpWidth;
        if (vertical) {
            tmpWidth = surfaceHeight;
            tmpHeight = surfaceWidth;
        } else {
            tmpWidth = surfaceWidth;
            tmpHeight = surfaceHeight;
        }
        for (Camera.Size size : preSizeList) {
            if (size.width != tmpWidth || size.height != tmpHeight) continue;
            return size;
        }
        float reqRatio = (float)tmpWidth / (float)tmpHeight;
        float deltaRatioMin = Float.MAX_VALUE;
        Camera.Size retSize = null;
        for (Camera.Size size : preSizeList) {
            float curRatio;
            float deltaRatio;
            if (size.width > maxWidth || size.height > maxHeight || !((deltaRatio = Math.abs(reqRatio - (curRatio = (float)size.width / (float)size.height))) < deltaRatioMin)) continue;
            deltaRatioMin = deltaRatio;
            retSize = size;
        }
        return retSize;
    }

    public static interface CameraPreviewListener {
        public void onStartPreview();
    }
}

