/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.ui;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.google.zxing.DecodeHintType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import me.majiajie.barcodereader.BarcodeFormat;
import me.majiajie.barcodereader.R;
import me.majiajie.barcodereader.decode.DecodeCallback;
import me.majiajie.barcodereader.decode.DecodeHandlerHelper;
import me.majiajie.barcodereader.decode.DecodeResult;
import me.majiajie.barcodereader.helper.RotationEventHelper;
import me.majiajie.barcodereader.ui.CameraUtils;
import me.majiajie.barcodereader.ui.ScanController;
import me.majiajie.barcodereader.ui.view.CameraPreview;
import me.majiajie.barcodereader.ui.view.ScanView;

public class ScanFragment
extends Fragment
implements ScanController {
    private static final String ARG_FORMATS = "ARG_FORMATS";
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();
    protected Context mContext;
    protected FrameLayout mCameraPreview;
    protected ScanView mScanView;
    private CheckBox mCheckBoxLight;
    private Collection<com.google.zxing.BarcodeFormat> mBarcodeFormatList;
    private RotationEventHelper mRotationEventHelper;
    private Camera mCamera;
    private boolean mFlashSupported;
    protected DecodeHandlerHelper mDecodeHandlerHelper;
    protected DecodeHandlerHelper mSecondDecodeHandlerHelper;
    private CameraPreview.CameraPreviewListener mCameraPreviewListener = new CameraPreview.CameraPreviewListener(){

        @Override
        public void onStartPreview() {
            ScanFragment.this.scanAgain();
        }
    };
    private RotationEventHelper.RotationEventListener mRotationEventListener = new RotationEventHelper.RotationEventListener(){

        @Override
        public void onRotationChanged(int rotation) {
            if (ScanFragment.this.mCamera != null) {
                ScanFragment.this.mCamera.setDisplayOrientation(ORIENTATIONS.get(rotation));
            }
        }
    };
    private ScanCallBack mScanCallBack;
    private boolean mIsSucceed = false;

    public static ScanFragment newInstance(int[] barcodeFormats) {
        Bundle args = new Bundle();
        args.putIntArray(ARG_FORMATS, barcodeFormats);
        ScanFragment fragment = new ScanFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
        if (!(context instanceof ScanCallBack)) {
            throw new ClassCastException(context.toString() + " must implements ScanCallBack");
        }
        this.mScanCallBack = (ScanCallBack)context;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            int[] formats = bundle.getIntArray(ARG_FORMATS);
            this.mBarcodeFormatList = new ArrayList<com.google.zxing.BarcodeFormat>();
            if (formats != null && formats.length > 0) {
                for (int n : formats) {
                    this.mBarcodeFormatList.add(BarcodeFormat.getZxingFormat(n));
                }
            } else {
                this.mBarcodeFormatList.add(com.google.zxing.BarcodeFormat.QR_CODE);
                this.mBarcodeFormatList.add(com.google.zxing.BarcodeFormat.CODE_128);
            }
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_scan, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mCameraPreview = (FrameLayout)view.findViewById(R.id.camera_preview);
        this.mScanView = (ScanView)view.findViewById(R.id.scanView);
        this.mCheckBoxLight = (CheckBox)view.findViewById(R.id.checkBox_light);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initDecodeThread();
        this.initEvent();
    }

    public void onResume() {
        super.onResume();
        this.mDecodeHandlerHelper.start();
        this.mSecondDecodeHandlerHelper.start();
        this.startPreview();
        this.mRotationEventHelper = new RotationEventHelper(this.mContext);
        this.mRotationEventHelper.setListener(this.mRotationEventListener);
        this.mRotationEventHelper.enable();
    }

    public void onPause() {
        super.onPause();
        this.mRotationEventHelper.disable();
        this.mRotationEventHelper = null;
        this.mCheckBoxLight.setChecked(false);
        this.releaseCamera();
        this.mDecodeHandlerHelper.stopThread();
        this.mSecondDecodeHandlerHelper.stopThread();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mContext = null;
    }

    @Override
    public void scanAgain() {
        if (this.mCamera != null) {
            this.mCamera.setOneShotPreviewCallback(new Camera.PreviewCallback(){

                public void onPreviewFrame(byte[] data, Camera camera) {
                    Camera.Size size = camera.getParameters().getPreviewSize();
                    int width = size.width;
                    int height = size.height;
                    boolean isVertical = ScanFragment.this.mContext.getResources().getConfiguration().orientation == 1;
                    Rect rect = ScanFragment.this.mScanView.getFramingRect(width, height, isVertical);
                    ScanFragment.this.mDecodeHandlerHelper.decode(data, width, height, rect, isVertical);
                    ScanFragment.this.mSecondDecodeHandlerHelper.decode(data, width, height, new Rect(0, 0, width, height), !isVertical);
                }
            });
        }
    }

    private void initDecodeThread() {
        EnumMap<DecodeHintType, Object> hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        hints.put(DecodeHintType.POSSIBLE_FORMATS, (Object)this.mBarcodeFormatList);
        hints.put(DecodeHintType.TRY_HARDER, (Object)false);
        this.mDecodeHandlerHelper = new DecodeHandlerHelper(new DecodeCallback(){

            @Override
            public void onDecodeFailed() {
                ScanFragment.this.mScanCallBack.onDecodeFailed();
            }

            @Override
            public void onDecodeSucceed(DecodeResult result) {
                if (!ScanFragment.this.mIsSucceed) {
                    if (ScanFragment.this.mCamera != null) {
                        ScanFragment.this.mCamera.setPreviewCallbackWithBuffer(null);
                        ScanFragment.this.mCamera.stopPreview();
                    }
                    ScanFragment.this.mIsSucceed = true;
                    ScanFragment.this.mScanCallBack.onDecodeSucceed(result);
                }
            }
        }, hints);
        EnumMap<DecodeHintType, Object> secondHints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        secondHints.put(DecodeHintType.POSSIBLE_FORMATS, (Object)this.mBarcodeFormatList);
        secondHints.put(DecodeHintType.TRY_HARDER, (Object)true);
        this.mSecondDecodeHandlerHelper = new DecodeHandlerHelper(new DecodeCallback(){

            @Override
            public void onDecodeFailed() {
            }

            @Override
            public void onDecodeSucceed(DecodeResult result) {
                if (!ScanFragment.this.mIsSucceed) {
                    if (ScanFragment.this.mCamera != null) {
                        ScanFragment.this.mCamera.setPreviewCallbackWithBuffer(null);
                        ScanFragment.this.mCamera.stopPreview();
                    }
                    ScanFragment.this.mIsSucceed = true;
                    ScanFragment.this.mScanCallBack.onDecodeSucceed(result);
                }
            }
        }, secondHints);
    }

    private void initEvent() {
        this.mCheckBoxLight.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (!ScanFragment.this.openFlash(isChecked)) {
                    buttonView.setChecked(!isChecked);
                    Toast.makeText((Context)ScanFragment.this.mContext, (int)R.string.hint_no_flash, (int)0).show();
                }
            }
        });
    }

    private boolean openFlash(boolean open) {
        if (this.mFlashSupported && this.mCamera != null) {
            Camera.Parameters params = this.mCamera.getParameters();
            params.setFlashMode(open ? "torch" : "off");
            this.mCamera.setParameters(params);
            return true;
        }
        return false;
    }

    private void startPreview() {
        if (this.mCamera == null) {
            List flashModes;
            Camera.Parameters params;
            List focusModes;
            this.mCamera = CameraUtils.getCameraInstance();
            if (this.mCamera == null) {
                Toast.makeText((Context)this.mContext, (int)R.string.hint_no_background_camera, (int)0).show();
                return;
            }
            WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
            if (windowManager != null) {
                int displayRotation = windowManager.getDefaultDisplay().getRotation();
                this.mCamera.setDisplayOrientation(ORIENTATIONS.get(displayRotation));
            }
            if ((focusModes = (params = this.mCamera.getParameters()).getSupportedFocusModes()) != null && focusModes.contains("continuous-picture")) {
                params.setFocusMode("continuous-picture");
                this.mCamera.setParameters(params);
                this.mCamera.cancelAutoFocus();
            }
            if ((flashModes = params.getSupportedFlashModes()) != null && flashModes.contains("torch") && flashModes.contains("off")) {
                this.mFlashSupported = true;
            }
            CameraPreview preview = new CameraPreview(this.mContext, this.mCamera);
            preview.setCameraPreviewListener(this.mCameraPreviewListener);
            this.mCameraPreview.addView((View)preview);
        }
    }

    private void releaseCamera() {
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallbackWithBuffer(null);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
            this.mCameraPreview.removeAllViews();
        }
    }

    static {
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
    }

    public static interface ScanCallBack {
        public void onDecodeFailed();

        public void onDecodeSucceed(DecodeResult var1);
    }
}

