/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.ui;

import android.content.Context;
import android.hardware.Camera;

public class CameraUtils {
    private CameraUtils() {
    }

    public static boolean checkCameraHardware(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public static Camera getCameraInstance() {
        Camera c = null;
        try {
            c = Camera.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public static Camera getFrontCameraInstance() {
        try {
            int numberOfCameras = Camera.getNumberOfCameras();
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            for (int i = 0; i < numberOfCameras; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != 1) continue;
                return Camera.open((int)i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isBack(int id2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)id2, (Camera.CameraInfo)cameraInfo);
        return cameraInfo.facing == 0;
    }

    public static int orientation(int id2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)id2, (Camera.CameraInfo)cameraInfo);
        return cameraInfo.orientation;
    }

    public static boolean canDisableShutterSound(int id2) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)id2, (Camera.CameraInfo)cameraInfo);
        return cameraInfo.canDisableShutterSound;
    }
}

