/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.helper;

import android.content.Context;
import android.view.OrientationEventListener;
import android.view.WindowManager;

public class RotationEventHelper
extends OrientationEventListener {
    private Context mContext;
    private RotationEventListener mListener;
    private int mRotation;

    public void setListener(RotationEventListener listener) {
        this.mListener = listener;
    }

    public RotationEventHelper(Context context) {
        super(context);
        this.mContext = context;
        this.mRotation = this.getWindowRotation();
    }

    public void enable() {
        super.enable();
    }

    public void disable() {
        super.disable();
    }

    public void onOrientationChanged(int orientation) {
        int newRotation;
        if (orientation < 0) {
            return;
        }
        if (orientation >= 0 && orientation <= 60) {
            newRotation = 0;
        } else if (orientation > 60 && orientation < 120) {
            newRotation = 3;
        } else if (orientation >= 120 && orientation <= 240) {
            newRotation = 2;
        } else if (orientation > 240 && orientation < 300) {
            newRotation = 1;
        } else if (orientation >= 300 && orientation <= 360) {
            newRotation = 0;
        } else {
            return;
        }
        if (this.mListener != null && this.mRotation != newRotation && this.getWindowRotation() == newRotation) {
            this.mRotation = newRotation;
            this.mListener.onRotationChanged(this.mRotation);
        }
    }

    private int getWindowRotation() {
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        if (windowManager != null) {
            return windowManager.getDefaultDisplay().getRotation();
        }
        return 0;
    }

    public static interface RotationEventListener {
        public void onRotationChanged(int var1);
    }
}

