/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.helper;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import me.majiajie.barcodereader.R;

public class RequestPermissionFragment
extends Fragment {
    private Context mContext;
    private static final String ARG_PERMISSIONS = "PERMISSIONS";
    private static final String ARG_HINT_TEXT = "ARG_HINT_TEXT";
    private static final int REQUEST_PERMISSIONS_CODE = 6666;
    private String[] mPermissions;
    private String mHint;
    private RequestPermissionsCallback mRequestPermissionsCallback;

    public static RequestPermissionFragment newInstance(String[] permissions, @Nullable String hint) {
        Bundle args = new Bundle();
        args.putStringArray(ARG_PERMISSIONS, permissions);
        args.putString(ARG_HINT_TEXT, hint);
        RequestPermissionFragment fragment = new RequestPermissionFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
        if (!(context instanceof RequestPermissionsCallback)) {
            throw new ClassCastException(context.toString() + " must implements RequestPermissionsCallback");
        }
        this.mRequestPermissionsCallback = (RequestPermissionsCallback)context;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mPermissions = args.getStringArray(ARG_PERMISSIONS);
            this.mHint = args.getString(ARG_HINT_TEXT);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 6666 && this.mRequestPermissionsCallback != null) {
            boolean result = true;
            for (int grant : grantResults) {
                if (grant != -1) continue;
                result = false;
                break;
            }
            this.mRequestPermissionsCallback.onRequestPermissionsResult(result);
        }
    }

    public boolean checkPermissions() {
        if (this.mPermissions != null) {
            for (String permissionName : this.mPermissions) {
                if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)permissionName) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void requestPermissions() {
        if (TextUtils.isEmpty((CharSequence)this.mHint)) {
            this.requestPermissions(this.mPermissions, 6666);
        } else {
            this.showPermissionsHintDialog();
        }
    }

    private void showPermissionsHintDialog() {
        new AlertDialog.Builder(this.mContext).setTitle(R.string.notice).setMessage((CharSequence)this.mHint).setPositiveButton(17039370, null).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                RequestPermissionFragment.this.requestPermissions(RequestPermissionFragment.this.mPermissions, 6666);
            }
        }).show();
    }

    public static interface RequestPermissionsCallback {
        public void onRequestPermissionsResult(boolean var1);
    }
}

