/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.encode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.majiajie.barcodereader.encode.BarCodeEncodeUtils;

public class QRCodeGenerateHelper {
    private String mContent;
    private int mSize;
    private int mColor;
    private int mBackgroundColor;
    private Drawable mIconDrawable;
    private Bitmap mIconBitmap;
    private int mIconStrokeColor;
    private boolean mIconRoundAngle;
    private Map<EncodeHintType, Object> mHints;

    private QRCodeGenerateHelper(Builder builder) {
        this.mContent = builder.content;
        this.mSize = builder.size;
        this.mColor = builder.color;
        this.mBackgroundColor = builder.backgroundColor;
        this.mIconDrawable = builder.iconDrawable;
        this.mIconBitmap = builder.iconBitmap;
        this.mIconStrokeColor = builder.iconStrokeColor;
        this.mIconRoundAngle = builder.iconRoundAngle;
        this.mHints = new HashMap<EncodeHintType, Object>();
        this.mHints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        this.mHints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        this.mHints.put(EncodeHintType.MARGIN, 2);
        this.mHints.put(EncodeHintType.DATA_MATRIX_SHAPE, SymbolShapeHint.FORCE_SQUARE);
    }

    public Bitmap generateBitmap() throws IOException {
        BitMatrix bitMatrix = this.generateBitMatrix();
        if (bitMatrix == null) {
            return null;
        }
        int codeSize = 0;
        for (int i = 0; i < this.mSize; ++i) {
            if (!bitMatrix.get(i, i)) continue;
            codeSize = this.mSize - i * 2;
            break;
        }
        Bitmap bitmap = BarCodeEncodeUtils.toBitmap(bitMatrix, this.mColor, this.mBackgroundColor);
        if (this.mIconBitmap != null) {
            this.addIcon(bitmap, codeSize);
        } else if (this.mIconDrawable != null) {
            this.addIcon(BarCodeEncodeUtils.drawableToBitmap(this.mIconDrawable), codeSize);
        }
        return bitmap;
    }

    public BitMatrix generateBitMatrix() throws IOException {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        try {
            bitMatrix = multiFormatWriter.encode(this.mContent, BarcodeFormat.QR_CODE, this.mSize, this.mSize, this.mHints);
        }
        catch (WriterException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        return bitMatrix;
    }

    private void addIcon(Bitmap bitmap, int codeSize) {
        RectF rectF_icon;
        float w = (float)codeSize * 0.28f;
        float left = ((float)this.mSize - w) / 2.0f;
        float top = ((float)this.mSize - w) / 2.0f;
        float right = left + w;
        float bottom = top + w;
        RectF rectF = new RectF(left, top, right, bottom);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setColor(this.mIconStrokeColor);
        paint.setAntiAlias(true);
        if (this.mIconStrokeColor == 0) {
            rectF_icon = new RectF(left, top, right, bottom);
        } else {
            if (this.mIconRoundAngle) {
                canvas.drawRoundRect(rectF, w * 0.17f, w * 0.17f, paint);
            } else {
                canvas.drawRect(rectF, paint);
            }
            float padding = w * 0.05f;
            rectF_icon = new RectF(left + padding, top + padding, right - padding, bottom - padding);
        }
        if (this.mIconRoundAngle) {
            float width = rectF_icon.width();
            float height = rectF_icon.height();
            Bitmap temBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)width), (int)((int)height), (boolean)false);
            canvas.drawBitmap(BarCodeEncodeUtils.getRounndImg(temBitmap), rectF_icon.left, rectF_icon.top, null);
        } else {
            canvas.drawBitmap(bitmap, null, rectF_icon, null);
        }
    }

    public static class Builder {
        private static final int SIZE_DEFAULT = 354;
        private String content;
        private int size;
        private int color;
        private int backgroundColor;
        private Drawable iconDrawable;
        private Bitmap iconBitmap;
        private int iconStrokeColor;
        private boolean iconRoundAngle;

        public Builder(String content) {
            this.content = content;
            this.color = -16777216;
            this.backgroundColor = 0;
            this.size = 354;
            this.iconStrokeColor = 0;
            this.iconRoundAngle = false;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder color(@ColorInt int color) {
            this.color = color;
            return this;
        }

        public Builder backgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder icon(Drawable drawable) {
            this.iconDrawable = drawable;
            this.iconBitmap = null;
            return this;
        }

        public Builder icon(Bitmap bitmap) {
            this.iconBitmap = bitmap;
            this.iconDrawable = null;
            return this;
        }

        public Builder iconStroke(@ColorInt int color) {
            this.iconStrokeColor = color;
            return this;
        }

        public Builder iconRoundAngle(boolean round) {
            this.iconRoundAngle = round;
            return this;
        }

        public QRCodeGenerateHelper build() {
            return new QRCodeGenerateHelper(this);
        }
    }
}

