/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.encode;

import android.graphics.Bitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.majiajie.barcodereader.BarcodeFormat;
import me.majiajie.barcodereader.encode.BarCodeEncodeUtils;

public class BarCodeGenerateHelper {
    private String mContent;
    private int mWidth;
    private int mHeight;
    private int mColor;
    private int mBackgroundColor;
    private int mFormat;
    private Map<EncodeHintType, Object> mHints;

    private BarCodeGenerateHelper(Builder builder) {
        this.mContent = builder.content;
        this.mWidth = builder.width;
        this.mHeight = builder.height;
        this.mColor = builder.color;
        this.mFormat = builder.format;
        this.mBackgroundColor = builder.backgroundColor;
        this.mHints = new HashMap<EncodeHintType, Object>();
        this.mHints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        this.mHints.put(EncodeHintType.MARGIN, 2);
    }

    public Bitmap generateBitmap() throws IOException {
        BitMatrix bitMatrix = this.generateBitMatrix();
        return bitMatrix == null ? null : BarCodeEncodeUtils.toBitmap(bitMatrix, this.mColor, this.mBackgroundColor);
    }

    public BitMatrix generateBitMatrix() throws IOException {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        try {
            bitMatrix = multiFormatWriter.encode(this.mContent, BarcodeFormat.getZxingFormat(this.mFormat), this.mWidth, this.mHeight, this.mHints);
        }
        catch (WriterException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        return bitMatrix;
    }

    public static class Builder {
        private static final int WIDTH_DEFAULT = 708;
        private static final int HEIGHT_DEFAULT = 354;
        private String content;
        private int width;
        private int height;
        private int color;
        private int backgroundColor;
        private int format;

        public Builder(String content, int format) {
            if (format == 11) {
                throw new IllegalArgumentException("format can't be QRcode");
            }
            this.content = content;
            this.format = format;
            this.color = -16777216;
            this.backgroundColor = 0;
            this.width = 708;
            this.height = 354;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder backgroundColor(int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public BarCodeGenerateHelper build() {
            return new BarCodeGenerateHelper(this);
        }
    }
}

