/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.decode;

import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.google.zxing.DecodeHintType;
import java.lang.ref.WeakReference;
import java.util.Map;
import me.majiajie.barcodereader.R;
import me.majiajie.barcodereader.decode.DecodeBean;
import me.majiajie.barcodereader.decode.DecodeCallback;
import me.majiajie.barcodereader.decode.DecodeHandler;
import me.majiajie.barcodereader.decode.DecodeResult;

public class DecodeHandlerHelper {
    private final String TAG = "DecodeHandlerHelper";
    private HandlerThread mHandlerThread;
    private DecodeHandler mDecodeHandler;
    private final DecodeCallback mDecodeCallBack;
    private final Map<DecodeHintType, Object> mHints;
    private boolean isStoped;
    private boolean isDecoding;

    public DecodeHandlerHelper(DecodeCallback callBack, Map<DecodeHintType, Object> hints) {
        this.mDecodeCallBack = callBack;
        this.mHints = hints;
    }

    public void start() {
        this.isStoped = false;
        this.mHandlerThread = new HandlerThread("DecodeHandlerHelper");
        this.mHandlerThread.start();
        this.mDecodeHandler = new DecodeHandler(this.mHandlerThread.getLooper(), new DecodeCallbackHandler(this, this.mDecodeCallBack), this.mHints);
    }

    public void stopThread() {
        this.isStoped = true;
        this.mDecodeHandler.removeMessages(R.id.decode);
        this.mDecodeHandler.removeMessages(R.id.decode_vertical);
        if (this.mHandlerThread != null) {
            if (Build.VERSION.SDK_INT >= 18) {
                this.mHandlerThread.quitSafely();
            } else {
                this.mHandlerThread.quit();
            }
            try {
                this.mHandlerThread.join();
                this.mHandlerThread = null;
                this.mDecodeHandler = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void decode(byte[] data, int width, int height, Rect rect, boolean neadRotate) {
        if (!this.isStoped && !this.isDecoding) {
            this.isDecoding = true;
            DecodeBean bean = new DecodeBean(data, width, height, rect);
            this.mDecodeHandler.obtainMessage(neadRotate ? R.id.decode_vertical : R.id.decode, bean).sendToTarget();
        }
    }

    private void done() {
        this.isDecoding = false;
    }

    public static class DecodeCallbackHandler
    extends Handler {
        private WeakReference<DecodeHandlerHelper> mHelper;
        private DecodeCallback mCallBack;

        DecodeCallbackHandler(DecodeHandlerHelper helper, DecodeCallback mCallBack) {
            super(Looper.getMainLooper());
            this.mCallBack = mCallBack;
            this.mHelper = new WeakReference<DecodeHandlerHelper>(helper);
        }

        public void handleMessage(Message msg) {
            DecodeHandlerHelper decodeHandlerHelper = (DecodeHandlerHelper)this.mHelper.get();
            if (decodeHandlerHelper != null) {
                decodeHandlerHelper.done();
                int what = msg.what;
                if (what == R.id.decode_succeeded) {
                    Bundle bundle = msg.getData();
                    byte[] b = bundle.getByteArray("barcode_bitmap");
                    float scaledFactor = bundle.getFloat("barcode_scaled_factor");
                    String text = bundle.getString("barcode_raw_result");
                    int format = bundle.getInt("barcode_format");
                    this.mCallBack.onDecodeSucceed(new DecodeResult(text, b, scaledFactor, format));
                } else if (what == R.id.decode_failed) {
                    this.mCallBack.onDecodeFailed();
                }
            }
        }
    }
}

