/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader.decode;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import me.majiajie.barcodereader.BarcodeFormat;
import me.majiajie.barcodereader.R;
import me.majiajie.barcodereader.decode.DecodeBean;

public class DecodeHandler
extends Handler {
    static final String BARCODE_BITMAP = "barcode_bitmap";
    static final String BARCODE_SCALED_FACTOR = "barcode_scaled_factor";
    static final String BARCODE_RAW_RESULT = "barcode_raw_result";
    static final String BARCODE_FORMAT = "barcode_format";
    private final Handler resultHandler;
    private final MultiFormatReader multiFormatReader = new MultiFormatReader();
    private boolean running = true;

    DecodeHandler(Looper looper, Handler callBackHandler, Map<DecodeHintType, Object> hints) {
        super(looper);
        this.multiFormatReader.setHints(hints);
        this.resultHandler = callBackHandler;
    }

    public void handleMessage(Message message) {
        if (!this.running) {
            return;
        }
        int what = message.what;
        if (what == R.id.decode) {
            this.decode((DecodeBean)message.obj);
        } else if (what == R.id.decode_vertical) {
            this.decodeVertical((DecodeBean)message.obj);
        } else if (what == R.id.quit) {
            this.running = false;
            Looper looper = Looper.myLooper();
            if (looper != null) {
                if (Build.VERSION.SDK_INT >= 18) {
                    looper.quitSafely();
                } else {
                    looper.quit();
                }
            }
        }
    }

    private void decodeVertical(DecodeBean decodeBean) {
        int oldWidth = decodeBean.getWidth();
        byte[] oldData = decodeBean.getData();
        Rect oldRect = decodeBean.getRect();
        int rectHeight = oldRect.height();
        int rectWidth = oldRect.width();
        int data_max_size = oldData.length;
        int rect_max_size = rectHeight * rectWidth;
        byte[] newData = new byte[rect_max_size];
        for (int y = 0; y < rectHeight; ++y) {
            for (int x = 0; x < rectWidth; ++x) {
                int tem_a = (x + 1) * rectHeight - y - 1;
                int tem_b = x + (oldRect.top + y) * oldWidth + oldRect.left;
                if (tem_a >= rect_max_size || tem_b >= data_max_size) continue;
                newData[tem_a] = oldData[tem_b];
            }
        }
        this.decode(new DecodeBean(newData, rectHeight, rectWidth, new Rect(0, 0, rectHeight, rectWidth)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(DecodeBean decodeBean) {
        Result rawResult = null;
        PlanarYUVLuminanceSource source = this.buildLuminanceSource(decodeBean.getData(), decodeBean.getWidth(), decodeBean.getHeight(), decodeBean.getRect());
        if (source != null) {
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            try {
                rawResult = this.multiFormatReader.decodeWithState(bitmap);
            }
            catch (ReaderException readerException) {
            }
            finally {
                this.multiFormatReader.reset();
            }
        }
        if (this.resultHandler != null) {
            Message message;
            if (rawResult != null) {
                message = this.resultHandler.obtainMessage(R.id.decode_succeeded);
                Bundle bundle = new Bundle();
                this.bundleThumbnail(source, bundle);
                bundle.putString(BARCODE_RAW_RESULT, rawResult.getText());
                bundle.putInt(BARCODE_FORMAT, BarcodeFormat.conversion(rawResult.getBarcodeFormat()));
                message.setData(bundle);
                message.sendToTarget();
            } else {
                message = this.resultHandler.obtainMessage(R.id.decode_failed);
                message.sendToTarget();
            }
        }
    }

    private void bundleThumbnail(PlanarYUVLuminanceSource source, Bundle bundle) {
        int[] pixels = source.renderThumbnail();
        int width = source.getThumbnailWidth();
        int height = source.getThumbnailHeight();
        Bitmap bitmap = Bitmap.createBitmap((int[])pixels, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)out);
        bundle.putByteArray(BARCODE_BITMAP, out.toByteArray());
        bundle.putFloat(BARCODE_SCALED_FACTOR, (float)width / (float)source.getWidth());
    }

    private PlanarYUVLuminanceSource buildLuminanceSource(byte[] data, int width, int height, Rect rect) {
        if (rect == null) {
            return null;
        }
        Rect newRect = new Rect(rect);
        if (newRect.right > width) {
            newRect.right = width;
        }
        if (newRect.left < 0) {
            newRect.left = 0;
        }
        if (newRect.top < 0) {
            newRect.top = 0;
        }
        if (newRect.bottom > height) {
            newRect.bottom = height;
        }
        return new PlanarYUVLuminanceSource(data, width, height, newRect.left, newRect.top, newRect.width(), newRect.height(), false);
    }
}

