/*
 * Decompiled with CFR 0.152.
 */
package me.majiajie.barcodereader;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.MenuItem;
import android.widget.Toast;
import me.majiajie.barcodereader.BaseScanSucceedFragment;
import me.majiajie.barcodereader.R;
import me.majiajie.barcodereader.decode.DecodeResult;
import me.majiajie.barcodereader.helper.RequestPermissionFragment;
import me.majiajie.barcodereader.ui.ScanController;
import me.majiajie.barcodereader.ui.ScanFragment;

public class ScanActivity
extends AppCompatActivity
implements ScanFragment.ScanCallBack,
RequestPermissionFragment.RequestPermissionsCallback {
    public static final int REQUEST_CODE = 110;
    public static final String ARG_DECODE_RESULT = "ARG_DECODE_RESULT";
    public static final String ARG_THEME = "ARG_THEME";
    public static final String ARG_SCAN_FORMAT = "ARG_SCAN_FORMAT";
    public static final String ARG_FRAGMENT = "ARG_FRAGMENT";
    private static final String TAG_COMPLETE_FRAGMENT = "TAG_COMPLETE_FRAGMENT";
    private static final String TAG_REQUEST_PERMISSION = "TAG_REQUEST_PERMISSION";
    private final String[] CAMERA_PERMISSION = new String[]{"android.permission.CAMERA"};
    private RequestPermissionFragment mRequestPermissionFragment;
    private ScanController mScanController;
    private int[] mBarFormat;
    private BaseScanSucceedFragment mBaseScanSucceedFragment;
    private boolean once = true;

    public static void startActivityForResult(Activity activity, @StyleRes int theme, @Nullable int[] scanFormat, @Nullable Class<? extends BaseScanSucceedFragment> clz) {
        ScanActivity.startActivityForResult(activity, theme, scanFormat, clz, 110);
    }

    public static void startActivityForResult(Activity activity, @StyleRes int theme, @Nullable int[] scanFormat) {
        ScanActivity.startActivityForResult(activity, theme, scanFormat, null, 110);
    }

    public static void startActivityForResult(Activity activity, @StyleRes int theme, @Nullable int[] scanFormat, @Nullable Class<? extends BaseScanSucceedFragment> clz, int requestCode) {
        Intent intent = new Intent((Context)activity, ScanActivity.class);
        intent.putExtra(ARG_THEME, theme);
        intent.putExtra(ARG_SCAN_FORMAT, scanFormat);
        intent.putExtra(ARG_FRAGMENT, clz == null ? "" : clz.getName());
        activity.startActivityForResult(intent, requestCode);
    }

    public static DecodeResult getResult(Intent data) {
        return (DecodeResult)data.getParcelableExtra(ARG_DECODE_RESULT);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Intent intent = this.getIntent();
        int theme = intent.getIntExtra(ARG_THEME, 0);
        if (theme != 0) {
            this.setTheme(theme);
        }
        this.mBarFormat = intent.getIntArrayExtra(ARG_SCAN_FORMAT);
        String fragmentName = intent.getStringExtra(ARG_FRAGMENT);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_scan);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        this.mRequestPermissionFragment = (RequestPermissionFragment)this.getSupportFragmentManager().findFragmentByTag(TAG_REQUEST_PERMISSION);
        if (this.mRequestPermissionFragment == null) {
            this.mRequestPermissionFragment = RequestPermissionFragment.newInstance(this.CAMERA_PERMISSION, this.getString(R.string.dialog_hint_camera_permission));
            FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
            transaction.add((Fragment)this.mRequestPermissionFragment, TAG_REQUEST_PERMISSION).commit();
        }
        if (!TextUtils.isEmpty((CharSequence)fragmentName)) {
            try {
                this.mBaseScanSucceedFragment = (BaseScanSucceedFragment)this.getSupportFragmentManager().findFragmentByTag(TAG_COMPLETE_FRAGMENT);
                if (this.mBaseScanSucceedFragment == null) {
                    this.mBaseScanSucceedFragment = (BaseScanSucceedFragment)((Object)Class.forName(fragmentName).newInstance());
                    this.getSupportFragmentManager().beginTransaction().add((Fragment)this.mBaseScanSucceedFragment, TAG_COMPLETE_FRAGMENT).commit();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.once) {
            this.once = false;
            if (this.mRequestPermissionFragment.checkPermissions()) {
                this.startScanBarcode();
            } else {
                this.mRequestPermissionFragment.requestPermissions();
            }
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onDecodeFailed() {
        if (this.mScanController != null) {
            this.mScanController.scanAgain();
        }
    }

    @Override
    public void onDecodeSucceed(DecodeResult result) {
        if (this.mBaseScanSucceedFragment != null) {
            this.mBaseScanSucceedFragment.onDecodeSucceed(result);
        } else {
            Intent intent = new Intent();
            intent.putExtra(ARG_DECODE_RESULT, (Parcelable)result);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    @Override
    public void onRequestPermissionsResult(boolean grantResult) {
        if (grantResult) {
            this.startScanBarcode();
        } else {
            Toast.makeText((Context)this, (int)R.string.hint_no_camera_permission, (int)1).show();
        }
    }

    private void startScanBarcode() {
        ScanFragment fragment = (ScanFragment)this.getSupportFragmentManager().findFragmentById(R.id.layout_fragment);
        if (fragment == null) {
            fragment = ScanFragment.newInstance(this.mBarFormat);
            FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
            fragmentTransaction.add(R.id.layout_fragment, (Fragment)fragment).commitAllowingStateLoss();
        }
        this.mScanController = fragment;
    }
}

