/*
 * Decompiled with CFR 0.152.
 */
package me.leolin.shortcutbadger;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import java.util.List;
import me.leolin.shortcutbadger.ShortcutBadgeException;
import me.leolin.shortcutbadger.impl.AdwHomeBadger;
import me.leolin.shortcutbadger.impl.ApexHomeBadger;
import me.leolin.shortcutbadger.impl.AsusHomeLauncher;
import me.leolin.shortcutbadger.impl.DefaultBadger;
import me.leolin.shortcutbadger.impl.LGHomeBadger;
import me.leolin.shortcutbadger.impl.NewHtcHomeBadger;
import me.leolin.shortcutbadger.impl.NovaHomeBadger;
import me.leolin.shortcutbadger.impl.SamsungHomeBadger;
import me.leolin.shortcutbadger.impl.SolidHomeBadger;
import me.leolin.shortcutbadger.impl.SonyHomeBadger;
import me.leolin.shortcutbadger.impl.XiaomiHomeBadger;

public abstract class ShortcutBadger {
    private static final String LOG_TAG = ShortcutBadger.class.getSimpleName();
    private static final List<Class<? extends ShortcutBadger>> BADGERS = new LinkedList<Class<? extends ShortcutBadger>>();
    private static ShortcutBadger mShortcutBadger;
    protected Context mContext;

    public static ShortcutBadger with(Context context) {
        return ShortcutBadger.getShortcutBadger(context);
    }

    public static void setBadge(Context context, int badgeCount) throws ShortcutBadgeException {
        try {
            ShortcutBadger.getShortcutBadger(context).executeBadge(badgeCount);
        }
        catch (Throwable e) {
            throw new ShortcutBadgeException("Unable to execute badge:" + e.getMessage());
        }
    }

    private static ShortcutBadger getShortcutBadger(Context context) {
        if (mShortcutBadger != null) {
            return mShortcutBadger;
        }
        Log.d((String)LOG_TAG, (String)"Finding badger");
        try {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.HOME");
            ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
            String currentHomePackage = resolveInfo.activityInfo.packageName;
            if (Build.MANUFACTURER.equalsIgnoreCase("Xiaomi")) {
                mShortcutBadger = new XiaomiHomeBadger(context);
                return mShortcutBadger;
            }
            for (Class<? extends ShortcutBadger> badger : BADGERS) {
                Constructor<? extends ShortcutBadger> constructor = badger.getConstructor(Context.class);
                ShortcutBadger shortcutBadger = constructor.newInstance(context);
                if (!shortcutBadger.getSupportLaunchers().contains(currentHomePackage)) continue;
                mShortcutBadger = shortcutBadger;
                break;
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        if (mShortcutBadger == null) {
            mShortcutBadger = new DefaultBadger(context);
        }
        Log.d((String)LOG_TAG, (String)("Returning badger:" + mShortcutBadger.getClass().getCanonicalName()));
        return mShortcutBadger;
    }

    private ShortcutBadger() {
    }

    protected ShortcutBadger(Context context) {
        this.mContext = context;
    }

    protected abstract void executeBadge(int var1) throws ShortcutBadgeException;

    protected abstract List<String> getSupportLaunchers();

    protected String getEntryActivityName() {
        ComponentName componentName = this.mContext.getPackageManager().getLaunchIntentForPackage(this.mContext.getPackageName()).getComponent();
        return componentName.getClassName();
    }

    protected String getContextPackageName() {
        return this.mContext.getPackageName();
    }

    public void count(int count) {
        try {
            this.executeBadge(count);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    public void remove() {
        this.count(0);
    }

    static {
        BADGERS.add(AdwHomeBadger.class);
        BADGERS.add(ApexHomeBadger.class);
        BADGERS.add(LGHomeBadger.class);
        BADGERS.add(NewHtcHomeBadger.class);
        BADGERS.add(NovaHomeBadger.class);
        BADGERS.add(SamsungHomeBadger.class);
        BADGERS.add(SolidHomeBadger.class);
        BADGERS.add(SonyHomeBadger.class);
        BADGERS.add(XiaomiHomeBadger.class);
        BADGERS.add(AsusHomeLauncher.class);
    }
}

