/*
 * Decompiled with CFR 0.152.
 */
package me.leolin.shortcutbadger.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import me.leolin.shortcutbadger.ShortcutBadgeException;

public class ImageUtil {
    public static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static byte[] bitmapToByteArray(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static byte[] drawBadgeOnAppIcon(Context context, int badgeCount) throws ShortcutBadgeException {
        float height;
        float width;
        Bitmap appIcon = null;
        String gText = String.valueOf(badgeCount);
        List packages = context.getPackageManager().getInstalledPackages(0);
        for (PackageInfo packageInfo : packages) {
            if (!context.getPackageName().equals(packageInfo.packageName)) continue;
            Drawable drawable = packageInfo.applicationInfo.loadIcon(context.getPackageManager());
            appIcon = ImageUtil.drawableToBitmap(drawable);
        }
        if (appIcon == null) {
            throw new ShortcutBadgeException("count not load the app Icon");
        }
        if (badgeCount == 0) {
            return ImageUtil.bitmapToByteArray(appIcon);
        }
        float scale = context.getResources().getDisplayMetrics().density;
        Bitmap.Config bitmapConfig = appIcon.getConfig();
        if (bitmapConfig == null) {
            bitmapConfig = Bitmap.Config.ARGB_8888;
        }
        float radius = ((width = (float)(appIcon = appIcon.copy(bitmapConfig, true)).getWidth()) > (height = (float)appIcon.getHeight()) ? width : height) / 4.0f;
        float cx = (float)appIcon.getWidth() - radius;
        float cy = radius;
        Paint paint_red = new Paint();
        paint_red.setColor(-65536);
        Paint paint_white = new Paint();
        paint_white.setColor(-1);
        Canvas canvas = new Canvas(appIcon);
        canvas.drawCircle(cx, cy, radius, paint_white);
        canvas.drawCircle(cx, cy, radius * 6.0f / 7.0f, paint_red);
        Paint paint_text = new Paint(1);
        paint_text.setColor(-1);
        int textSize = (int)((double)radius * 0.7);
        if (gText.length() > 1) {
            textSize = (int)((double)radius * 0.5);
        }
        paint_text.setTextSize((float)((int)((float)textSize * scale)));
        paint_text.setFakeBoldText(true);
        Rect bounds = new Rect();
        paint_text.getTextBounds(gText, 0, gText.length(), bounds);
        float bw = bounds.width() / 2;
        if (gText.endsWith("1")) {
            bw = (float)((double)bw * 1.25);
        }
        float bh = bounds.height() / 2;
        canvas.drawText(gText, cx - bw, cy + bh, paint_text);
        return ImageUtil.bitmapToByteArray(appIcon);
    }
}

