/*
 * Decompiled with CFR 0.152.
 */
package me.leolin.shortcutbadger;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import me.leolin.shortcutbadger.ShortcutBadgeException;
import me.leolin.shortcutbadger.impl.AdwHomeBadger;
import me.leolin.shortcutbadger.impl.AndroidHomeBadger;
import me.leolin.shortcutbadger.impl.ApexHomeBadger;
import me.leolin.shortcutbadger.impl.LGHomeBadger;
import me.leolin.shortcutbadger.impl.NewHtcHomeBadger;
import me.leolin.shortcutbadger.impl.NovaHomeBadger;
import me.leolin.shortcutbadger.impl.SamsungHomeBadger;
import me.leolin.shortcutbadger.impl.SonyHomeBadger;

public abstract class ShortcutBadger {
    private static final String HOME_PACKAGE_SONY1 = "com.sonyericsson.home";
    private static final String HOME_PACKAGE_SONY2 = "com.anddoes.launcher";
    private static final String HOME_PACKAGE_SAMSUNG1 = "com.sec.android.app.launcher";
    private static final String HOME_PACKAGE_SAMSUNG2 = "com.sec.android.app.twlauncher";
    private static final String HOME_PACKAGE_LG1 = "com.lge.launcher";
    private static final String HOME_PACKAGE_LG2 = "com.lge.launcher2";
    private static final String HOME_PACKAGE_HTC = "com.htc.launcher";
    private static final String HOME_PACKAGE_APEX = "com.anddoes.launcher";
    private static final String HOME_PACKAGE_ADW = "org.adw.launcher";
    private static final String HOME_PACKAGE_ADW_EX = "org.adwfreak.launcher";
    private static final String HOME_PACKAGE_NOVA = "com.teslacoilsw.launcher";
    private static final String HOME_PACKAGE_ANDROID1 = "com.android.launcher";
    private static final String HOME_PACKAGE_ANDROID2 = "com.android.launcher2";
    private static final String HOME_PACKAGE_ANDROID3 = "com.google.android.googlequicksearchbox";
    private static final String MESSAGE_NOT_SUPPORT_BADGE_COUNT = "ShortBadger is currently not support the badgeCount \"%d\"";
    private static final String MESSAGE_NOT_SUPPORT_THIS_HOME = "ShortcutBadger is currently not support the home launcher package \"%s\"";
    private static final int MIN_BADGE_COUNT = 0;
    private static final int MAX_BADGE_COUNT = 99;
    private static ShortcutBadger sShortcutBadger;
    protected Context mContext;

    private ShortcutBadger() {
    }

    protected ShortcutBadger(Context context) {
        this.mContext = context;
    }

    protected abstract void executeBadge(int var1) throws ShortcutBadgeException;

    public static void setBadge(Context context, int badgeCount) throws ShortcutBadgeException {
        if (badgeCount < 0 || badgeCount > 99) {
            String exceptionMessage = String.format(MESSAGE_NOT_SUPPORT_BADGE_COUNT, badgeCount);
            throw new ShortcutBadgeException(exceptionMessage);
        }
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        String currentHomePackage = resolveInfo.activityInfo.packageName;
        ShortcutBadger shortcutBadger = ShortcutBadger.getShortcutBadger(currentHomePackage, context);
        if (shortcutBadger == null) {
            String exceptionMessage = String.format(MESSAGE_NOT_SUPPORT_THIS_HOME, currentHomePackage);
            throw new ShortcutBadgeException(exceptionMessage);
        }
        try {
            shortcutBadger.executeBadge(badgeCount);
        }
        catch (Throwable e) {
            throw new ShortcutBadgeException("Unable to execute badge:" + e.getMessage());
        }
        shortcutBadger.executeBadge(badgeCount);
    }

    private static ShortcutBadger getShortcutBadger(String currentHomePackage, Context context) {
        if (sShortcutBadger != null) {
            return sShortcutBadger;
        }
        if (Build.MANUFACTURER.toLowerCase().contains("meizu")) {
            return null;
        }
        if (HOME_PACKAGE_SONY1.equals(currentHomePackage) || "com.anddoes.launcher".equals(currentHomePackage)) {
            sShortcutBadger = new SonyHomeBadger(context);
        } else if (HOME_PACKAGE_SAMSUNG1.equals(currentHomePackage) || HOME_PACKAGE_SAMSUNG2.equals(currentHomePackage)) {
            sShortcutBadger = new SamsungHomeBadger(context);
        } else if (HOME_PACKAGE_LG1.equals(currentHomePackage) || HOME_PACKAGE_LG2.equals(currentHomePackage)) {
            sShortcutBadger = new LGHomeBadger(context);
        } else if (HOME_PACKAGE_HTC.equals(currentHomePackage)) {
            sShortcutBadger = new NewHtcHomeBadger(context);
        } else if (HOME_PACKAGE_ANDROID1.equals(currentHomePackage) || HOME_PACKAGE_ANDROID2.equals(currentHomePackage) || HOME_PACKAGE_ANDROID3.equals(currentHomePackage)) {
            sShortcutBadger = new AndroidHomeBadger(context);
        } else if ("com.anddoes.launcher".equals(currentHomePackage)) {
            sShortcutBadger = new ApexHomeBadger(context);
        } else if (HOME_PACKAGE_ADW.equals(currentHomePackage) || HOME_PACKAGE_ADW_EX.equals(currentHomePackage)) {
            sShortcutBadger = new AdwHomeBadger(context);
        } else if (HOME_PACKAGE_NOVA.equals(currentHomePackage)) {
            sShortcutBadger = new NovaHomeBadger(context);
        }
        return sShortcutBadger;
    }

    protected String getEntryActivityName() {
        ComponentName componentName = this.mContext.getPackageManager().getLaunchIntentForPackage(this.mContext.getPackageName()).getComponent();
        return componentName.getClassName();
    }

    protected String getContextPackageName() {
        return this.mContext.getPackageName();
    }
}

