/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.mikrotik.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import me.legrange.mikrotik.ApiConnectionException;
import me.legrange.mikrotik.impl.ApiDataException;
import me.legrange.mikrotik.impl.Command;
import me.legrange.mikrotik.impl.Parameter;

final class Util {
    Util() {
    }

    static void write(Command cmd, OutputStream out) throws UnsupportedEncodingException, IOException {
        List<String> props;
        Util.encode(cmd.getCommand(), out);
        for (Parameter param : cmd.getParameters()) {
            Util.encode(String.format("=%s=%s", param.getName(), param.hasValue() ? param.getValue() : ""), out);
        }
        String tag = cmd.getTag();
        if (tag != null && !tag.equals("")) {
            Util.encode(String.format(".tag=%s", tag), out);
        }
        if (!(props = cmd.getProperties()).isEmpty()) {
            StringBuilder buf = new StringBuilder("=.proplist=");
            for (int i = 0; i < props.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(props.get(i));
            }
            Util.encode(buf.toString(), out);
        }
        for (String query : cmd.getQueries()) {
            Util.encode(query, out);
        }
        out.write(0);
    }

    static String decode(InputStream in) throws ApiDataException, ApiConnectionException {
        StringBuilder res = new StringBuilder();
        Util.decode(in, res);
        return res.toString();
    }

    private static void decode(InputStream in, StringBuilder result) throws ApiDataException, ApiConnectionException {
        try {
            int len = Util.readLen(in);
            if (len > 0) {
                byte[] buf = new byte[len];
                for (int i = 0; i < len; ++i) {
                    int c = in.read();
                    if (c < 0) {
                        throw new ApiDataException("Truncated data. Expected to read more bytes");
                    }
                    buf[i] = (byte)(c & 0xFF);
                }
                String res = new String(buf, Charset.forName("UTF-8"));
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(res);
                Util.decode(in, result);
            }
        }
        catch (IOException ex) {
            throw new ApiConnectionException(ex.getMessage(), ex);
        }
    }

    static String hashMD5(String s) throws ApiDataException {
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new ApiDataException("Cannot find MD5 digest algorithm");
        }
        byte[] defaultBytes = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            defaultBytes[i] = (byte)(0xFF & s.charAt(i));
        }
        algorithm.reset();
        algorithm.update(defaultBytes);
        byte[] messageDigest = algorithm.digest();
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < messageDigest.length; ++i) {
            String hex = Integer.toHexString(0xFF & messageDigest[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    static String hexStrToStr(String s) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < s.length(); i += 2) {
            ret.append((char)Integer.parseInt(s.substring(i, i + 2), 16));
        }
        return ret.toString();
    }

    private static void encode(String word, OutputStream out) throws UnsupportedEncodingException, IOException {
        byte[] bytes = word.getBytes("UTF-8");
        int len = bytes.length;
        if (len < 128) {
            out.write(len);
        } else if (len < 16384) {
            out.write((len |= 0x8000) >> 8);
            out.write(len);
        } else if (len < 131072) {
            out.write((len |= 0xC00000) >> 16);
            out.write(len >> 8);
            out.write(len);
        } else if (len < 0x10000000) {
            out.write((len |= 0xE0000000) >> 24);
            out.write(len >> 16);
            out.write(len >> 8);
            out.write(len);
        } else {
            out.write(240);
            out.write(len >> 24);
            out.write(len >> 16);
            out.write(len >> 8);
            out.write(len);
        }
        out.write(bytes);
    }

    private static int readLen(InputStream in) throws IOException {
        int c = in.read();
        if (c > 0 && (c & 0x80) != 0) {
            if ((c & 0xC0) == 128) {
                c &= 0xFFFFFF3F;
                c = c << 8 | in.read();
            } else if ((c & 0xE0) == 192) {
                c &= 0xFFFFFF1F;
                c = c << 8 | in.read();
                c = c << 8 | in.read();
            } else if ((c & 0xF0) == 224) {
                c &= 0xFFFFFF0F;
                c = c << 8 | in.read();
                c = c << 8 | in.read();
                c = c << 8 | in.read();
            } else if ((c & 0xF8) == 240) {
                c = in.read();
                c = c << 8 | in.read();
                c = c << 8 | in.read();
                c = c << 8 | in.read();
                c = c << 8 | in.read();
            }
        }
        return c;
    }
}

