/*
 * Decompiled with CFR 0.152.
 */
package me.leejay.jenkins.dateparameter;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import me.leejay.jenkins.dateparameter.IntegerParamMethod;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringLocalDateValue
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(StringLocalDateValue.class);
    private static final long serialVersionUID = 8295455815421939737L;
    private static final String JAVA_PATTERN = "^LocalDate(Time)?\\.now\\(\\)(\\.(plus|minus)(Seconds|Minutes|Hours|Days|Months|Years)\\([0-9]+\\))*;?$";
    private final String stringLocalDate;
    private final String stringDateFormat;

    public StringLocalDateValue(String stringLocalDate, String stringDateFormat) {
        this.stringLocalDate = stringLocalDate;
        this.stringDateFormat = stringDateFormat;
    }

    public String getStringLocalDate() {
        return this.stringLocalDate;
    }

    public String getStringValue() {
        return this.stringLocalDate;
    }

    public boolean isCompletionFormat() {
        try {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.stringDateFormat);
            return LocalDateTime.parse((String)this.stringLocalDate, (DateTimeFormatter)formatter) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isJavaFormat() {
        return this.stringLocalDate.matches(JAVA_PATTERN);
    }

    public String getStringDateFormat() {
        return this.stringDateFormat;
    }

    LocalDateTime parseJava() {
        List<String> codes = Arrays.asList(this.stringLocalDate.split("\\."));
        if (codes.size() == 2) {
            if (this.stringLocalDate.matches("^LocalDate(Time)?\\.now\\(\\);?$")) {
                return LocalDateTime.now();
            }
            return null;
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        for (String code : codes.subList(2, codes.size())) {
            IntegerParamMethod paramMethod = new IntegerParamMethod(code);
            if (paramMethod.getName() == null || paramMethod.getParameter() == null) {
                return null;
            }
            try {
                Method method = localDateTime.getClass().getMethod(paramMethod.getName(), Integer.TYPE);
                localDateTime = (LocalDateTime)method.invoke((Object)localDateTime, paramMethod.getParameter());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
        return localDateTime;
    }

    String getValue() {
        if (this.isCompletionFormat()) {
            return this.stringLocalDate;
        }
        if (this.isJavaFormat()) {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)this.stringDateFormat);
            return this.parseJava().toString(formatter);
        }
        return "";
    }
}

