/*
 * Decompiled with CFR 0.152.
 */
package me.ledge.link.api.vos.datapoints;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.ledge.link.api.vos.datapoints.FinancialAccountVo;

public class Card
extends FinancialAccountVo {
    @SerializedName(value="card_network")
    public CardNetwork cardNetwork;
    @SerializedName(value="last_four_digits")
    public String lastFourDigits;
    @SerializedName(value="pan")
    public String PANToken;
    @SerializedName(value="cvv_number")
    public String CVVToken;
    @SerializedName(value="expiration")
    public String expirationDate;

    public Card() {
        super(null, FinancialAccountVo.FinancialAccountType.Card, false);
        this.cardNetwork = null;
        this.lastFourDigits = null;
        this.PANToken = null;
        this.CVVToken = null;
        this.expirationDate = null;
    }

    public Card(String accountId, CardNetwork type, String PANToken, String CVVToken, String lastFourDigits, String expirationDate, boolean verified) {
        super(accountId, FinancialAccountVo.FinancialAccountType.Card, verified);
        this.cardNetwork = type;
        this.lastFourDigits = lastFourDigits;
        this.PANToken = PANToken;
        this.CVVToken = CVVToken;
        this.expirationDate = expirationDate;
    }

    protected Card(FinancialAccountVo.FinancialAccountType accountType, String accountId, CardNetwork type, String PANToken, String CVVToken, String lastFourDigits, String expirationDate, boolean verified) {
        super(accountId, accountType, verified);
        this.cardNetwork = type;
        this.lastFourDigits = lastFourDigits;
        this.PANToken = PANToken;
        this.CVVToken = CVVToken;
        this.expirationDate = expirationDate;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject gsonObject = super.toJSON();
        gsonObject.addProperty("type", "card");
        gsonObject.addProperty("card_network", this.cardNetwork.name());
        gsonObject.addProperty("pan_token", this.PANToken);
        gsonObject.addProperty("cvv_token", this.CVVToken);
        gsonObject.addProperty("last_four", this.lastFourDigits);
        gsonObject.addProperty("expiration", this.getAPIFormatExpirationDate(this.expirationDate));
        return gsonObject;
    }

    private String getAPIFormatExpirationDate(String expirationDate) {
        String formattedExpirationDate;
        String CARD_EXPIRATION_FORMAT = "MM/yy";
        String API_FORMAT = "yyyy-MM";
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yy");
        try {
            Date date = dateFormat.parse(expirationDate);
            dateFormat.applyPattern("yyyy-MM");
            formattedExpirationDate = dateFormat.format(date);
        }
        catch (ParseException e) {
            formattedExpirationDate = null;
        }
        return formattedExpirationDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Card card = (Card)o;
        if (this.cardNetwork != card.cardNetwork) {
            return false;
        }
        if (this.lastFourDigits != null ? !this.lastFourDigits.equals(card.lastFourDigits) : card.lastFourDigits != null) {
            return false;
        }
        if (this.PANToken != null ? !this.PANToken.equals(card.PANToken) : card.PANToken != null) {
            return false;
        }
        if (this.CVVToken != null ? !this.CVVToken.equals(card.CVVToken) : card.CVVToken != null) {
            return false;
        }
        return this.expirationDate != null ? this.expirationDate.equals(card.expirationDate) : card.expirationDate == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode() + (this.cardNetwork != null ? this.cardNetwork.hashCode() : 0);
        result = 31 * result + (this.lastFourDigits != null ? this.lastFourDigits.hashCode() : 0);
        result = 31 * result + (this.PANToken != null ? this.PANToken.hashCode() : 0);
        result = 31 * result + (this.CVVToken != null ? this.CVVToken.hashCode() : 0);
        result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
        return result;
    }

    public static enum CardNetwork {
        VISA,
        MASTERCARD,
        AMEX;

    }
}

